/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.renderer.list;

import com.nepxion.swing.renderer.list.CellRendererLabel;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;

public class RadioButtonCellRendererPanel
extends JPanel {
    private JRadioButton radioButton = new JRadioButton();
    private CellRendererLabel label = new CellRendererLabel();

    public RadioButtonCellRendererPanel() {
        this.radioButton.setBackground(UIManager.getColor("Tree.textBackground"));
        this.label.setForeground(UIManager.getColor("Tree.textForeground"));
        this.add(this.radioButton);
        this.add(this.label);
        this.setBackground(Color.white);
    }

    public JRadioButton getRadioButton() {
        return this.radioButton;
    }

    public CellRendererLabel getLabel() {
        return this.label;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension radioDimension = this.radioButton.getPreferredSize();
        Dimension labelDimension = this.label.getPreferredSize();
        return new Dimension(radioDimension.width + labelDimension.width, radioDimension.height < labelDimension.height ? labelDimension.height : radioDimension.height);
    }

    @Override
    public void setBackground(Color background) {
        if (background instanceof ColorUIResource) {
            background = null;
        }
        super.setBackground(background);
    }

    @Override
    public void doLayout() {
        Dimension radioDimension = this.radioButton.getPreferredSize();
        Dimension labelDimension = this.label.getPreferredSize();
        int radioHeight = 0;
        int labelHeight = 0;
        if (radioDimension.height < labelDimension.height) {
            radioHeight = (labelDimension.height - radioDimension.height) / 2;
        } else {
            labelHeight = (radioDimension.height - labelDimension.height) / 2;
        }
        this.radioButton.setBounds(2, radioHeight, radioDimension.width, radioDimension.height);
        this.label.setBounds(radioDimension.width + 4, labelHeight, labelDimension.width, labelDimension.height);
    }
}

