/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.chart.pie;

import com.nepxion.swing.chart.pie.IPieChartPlot;
import com.nepxion.swing.chart.pie.PieChartPlotAdapter;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.HashMap;
import java.util.Map;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.data.general.PieDataset;

public class PieChartPlot3D
extends PiePlot3D
implements IPieChartPlot {
    private PieChartPlotAdapter adapter;
    private Map sectionOutlineStrokeMap = new HashMap();
    private Map sectionOutlinePaintMap = new HashMap();

    public PieChartPlot3D() {
        this.adapter = new PieChartPlotAdapter();
        this.updateSelectionData();
    }

    public PieChartPlot3D(PieDataset dataset) {
        super(dataset);
        this.adapter = new PieChartPlotAdapter();
        this.updateSelectionData();
    }

    @Override
    public void updateSelectionData() {
        this.sectionOutlineStrokeMap.clear();
        this.sectionOutlinePaintMap.clear();
        for (Comparable key : this.getDataset().getKeys()) {
            Stroke stroke = super.getSectionOutlineStroke(key);
            if (stroke == null) {
                stroke = DEFAULT_OUTLINE_STROKE;
            }
            this.sectionOutlineStrokeMap.put(key, stroke);
            Paint paint = super.getSectionOutlinePaint(key);
            if (paint == null) {
                paint = DEFAULT_OUTLINE_PAINT;
            }
            this.sectionOutlinePaintMap.put(key, paint);
        }
    }

    @Override
    public void updateSelectionUI() {
        for (Comparable key : this.getDataset().getKeys()) {
            Stroke stroke = this.adapter.getSectionOutlineStroke(key);
            if (stroke == null) {
                stroke = (Stroke)this.sectionOutlineStrokeMap.get(key);
            }
            super.setSectionOutlineStroke(key, stroke);
            Paint paint = this.adapter.getSectionOutlinePaint(key);
            if (paint == null) {
                paint = (Paint)this.sectionOutlinePaintMap.get(key);
            }
            super.setSectionOutlinePaint(key, paint);
        }
    }

    @Override
    public void dispatchMouseOver(Comparable key) {
        this.adapter.dispatchMouseOver(key);
        this.updateSelectionUI();
    }

    @Override
    public void dispatchMouseDown(Comparable key) {
        this.adapter.dispatchMouseDown(key);
        this.updateSelectionUI();
    }

    public void setSectionOutlineStroke(Comparable key, Stroke stroke) {
        super.setSectionOutlineStroke(key, stroke);
        this.sectionOutlineStrokeMap.put(key, stroke);
    }

    public void setSectionOutlinePaint(Comparable key, Paint paint) {
        super.setSectionOutlinePaint(key, paint);
        this.sectionOutlinePaintMap.put(key, paint);
    }

    @Override
    public Comparable getSelectionKey() {
        return this.adapter.getSelectionKey();
    }

    @Override
    public PieChartPlotAdapter getAdapter() {
        return this.adapter;
    }
}

