/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.border.Border;

public class RoundBorder
implements Border {
    public static final int RAISED = 0;
    public static final int LOWERED = 1;
    protected int etchType;
    protected int radius;
    protected Color highlight;
    protected Color shadow;
    protected boolean indent;

    public RoundBorder() {
        this(false);
    }

    public RoundBorder(boolean indent) {
        this(1, 3, indent);
    }

    public RoundBorder(int etchType, int radius) {
        this(etchType, radius, false);
    }

    public RoundBorder(int etchType, int radius, boolean indent) {
        this(etchType, radius, null, null, indent);
    }

    public RoundBorder(Color highlight, Color shadow) {
        this(highlight, shadow, false);
    }

    public RoundBorder(Color highlight, Color shadow, boolean indent) {
        this(1, highlight, shadow, indent);
    }

    public RoundBorder(int etchType, Color highlight, Color shadow) {
        this(etchType, highlight, shadow, false);
    }

    public RoundBorder(int etchType, Color highlight, Color shadow, boolean indent) {
        this(etchType, 3, highlight, shadow, indent);
    }

    public RoundBorder(int etchType, int radius, Color highlight, Color shadow) {
        this(etchType, radius, highlight, shadow, false);
    }

    public RoundBorder(int etchType, int radius, Color highlight, Color shadow, boolean indent) {
        this.etchType = etchType;
        this.radius = radius;
        this.highlight = highlight;
        this.shadow = shadow;
        this.indent = indent;
    }

    public int getEtchType() {
        return this.etchType;
    }

    public Color getHighlightColor(Component c) {
        return this.highlight != null ? this.highlight : c.getBackground().brighter();
    }

    public Color getHighlightColor() {
        return this.highlight;
    }

    public Color getShadowColor(Component c) {
        return this.shadow != null ? this.shadow : c.getBackground().darker();
    }

    public Color getShadowColor() {
        return this.shadow;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        if (this.indent) {
            int d = (int)((double)this.radius * Math.cos(0.7853981633974483) + 2.0);
            return new Insets(d, d, d, d);
        }
        return new Insets(2, 2, 2, 2);
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        if (this.indent) {
            int d;
            insets.right = insets.bottom = (d = (int)((double)this.radius * Math.cos(0.7853981633974483) + 2.0));
            insets.top = insets.bottom;
            insets.left = insets.bottom;
            return insets;
        }
        insets.bottom = 2;
        insets.right = 2;
        insets.top = 2;
        insets.left = 2;
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int w = width;
        int h = height;
        int r = this.radius;
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.translate(x, y);
        if (this.etchType == 1) {
            g.setColor(this.getShadowColor(c));
            g.drawRoundRect(0, 0, w - 2, h - 2, 2 * r, 2 * r);
        }
        g.setColor(this.etchType == 1 ? this.getHighlightColor(c) : this.getShadowColor(c));
        g.drawLine(1, h - r - 2, 1, r + 1);
        g.drawLine(r + 1, 1, w - r - 2, 1);
        g.drawLine(r, h - 1, w - r - 1, h - 1);
        g.drawLine(w - 1, h - r - 1, w - 1, r);
        int ax = 1;
        int ay = 1;
        int arcSide = 2 * r;
        int startAngle = 90;
        int arcAngle = 90;
        g.drawArc(ax, ay, arcSide, arcSide, startAngle, arcAngle);
        ax = 1;
        ay = h - 2 * r - 1;
        startAngle = 180;
        g.drawArc(ax, ay, arcSide, arcSide, startAngle, arcAngle);
        ax = w - 2 * r - 1;
        ay = h - 2 * r - 1;
        startAngle = -90;
        g.drawArc(ax, ay, arcSide, arcSide, startAngle, arcAngle);
        ax = w - 2 * r - 1;
        ay = 1;
        startAngle = 0;
        g.drawArc(ax, ay, arcSide, arcSide, startAngle, arcAngle);
        if (this.etchType == 0) {
            g.setColor(this.getHighlightColor(c));
            g.drawRoundRect(0, 0, w - 2, h - 2, 2 * r, 2 * r);
        }
        g.translate(-x, -y);
    }
}

