/*
 * Decompiled with CFR 0.152.
 */
package y.algo;

import java.util.Arrays;
import y.algo.Bfs;
import y.algo.Dfs;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeList;
import y.base.Graph;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.base.NodeMap;
import y.base.YList;
import y.util.Maps;

public class Trees {
    private Trees() {
    }

    public static EdgeList[] getTreeEdges(Graph graph) {
        return Trees.getTreeEdges(graph, Trees.getTreeNodes(graph));
    }

    public static EdgeList[] getTreeEdges(Graph graph, NodeList[] nodeListArray) {
        EdgeList[] edgeListArray = new EdgeList[nodeListArray.length];
        int[] nArray = new int[graph.nodeCount()];
        int n = 1;
        int n2 = 0;
        while (n2 < nodeListArray.length) {
            NodeList nodeList = nodeListArray[n2];
            EdgeList edgeList = new EdgeList();
            NodeCursor nodeCursor = nodeList.nodes();
            while (nodeCursor.ok()) {
                nArray[nodeCursor.node().index()] = n;
                nodeCursor.next();
            }
            NodeCursor nodeCursor2 = nodeList.nodes();
            while (nodeCursor2.ok()) {
                Node node = nodeCursor2.node();
                EdgeCursor edgeCursor = node.outEdges();
                while (edgeCursor.ok()) {
                    Edge edge = edgeCursor.edge();
                    if (nArray[edge.opposite(node).index()] == n && !edge.isSelfLoop()) {
                        edgeList.push(edge);
                    }
                    edgeCursor.next();
                }
                nodeCursor2.next();
            }
            edgeListArray[n2] = edgeList;
            ++n2;
            ++n;
        }
        return edgeListArray;
    }

    public static NodeList[] getTreeNodes(Graph graph) {
        Object object;
        Node node;
        int[] nArray = new int[graph.nodeCount()];
        YList yList = new YList();
        NodeList nodeList = new NodeList();
        boolean bl = false;
        NodeCursor nodeCursor = graph.nodes();
        while (nodeCursor.ok()) {
            node = nodeCursor.node();
            nArray[node.index()] = node.outDegree();
            if (node.outDegree() == 0 && node.inDegree() == 1) {
                nodeList.addLast(node);
            }
            nodeCursor.next();
        }
        while (!nodeList.isEmpty()) {
            node = nodeList.popNode();
            if (node.inDegree() <= 0) continue;
            object = node.firstInEdge().source();
            int n = ((Node)object).index();
            nArray[n] = nArray[n] - 1;
            if (((Node)object).inDegree() > 1 || nArray[((Node)object).index()] != 0) continue;
            nodeList.addLast(object);
        }
        object = graph.nodes();
        while (object.ok()) {
            NodeList nodeList2;
            node = object.node();
            int n = nArray[node.index()];
            if (n == 0 && node.inDegree() != 1 && node.outDegree() > 0) {
                nodeList2 = new NodeList();
                nodeList2.addLast(node);
                Trees.a(node, nodeList2);
                yList.addLast(nodeList2);
            } else if (n > 0 && n < node.outDegree()) {
                nodeList2 = new NodeList();
                nodeList2.addLast(node);
                NodeCursor nodeCursor2 = node.successors();
                while (nodeCursor2.ok()) {
                    Node node2 = nodeCursor2.node();
                    if (nArray[node2.index()] == 0 && node2.inDegree() == 1) {
                        nodeList2.addLast(node2);
                        Trees.a(node2, nodeList2);
                    }
                    nodeCursor2.next();
                }
                yList.addLast(nodeList2);
            }
            object.next();
        }
        return (NodeList[])yList.toArray(new NodeList[yList.size()]);
    }

    public static NodeList[] getUndirectedTreeNodes(Graph graph) {
        Object object;
        NodeList[] nodeListArray = new NodeList[graph.nodeCount()];
        EdgeList[] edgeListArray = new EdgeList[graph.nodeCount()];
        YList yList = new YList();
        NodeList nodeList = new NodeList();
        int n = 0;
        while (n < graph.nodeCount()) {
            nodeListArray[n] = new NodeList();
            ++n;
        }
        NodeCursor nodeCursor = graph.nodes();
        while (nodeCursor.ok()) {
            int n2 = nodeCursor.node().index();
            nodeListArray[n2] = new NodeList();
            edgeListArray[n2] = new EdgeList();
            object = nodeCursor.node().edges();
            while (object.ok()) {
                edgeListArray[n2].add(object.edge());
                object.next();
            }
            if (edgeListArray[n2].size() == 1) {
                nodeList.addLast(nodeCursor.node());
            }
            nodeCursor.next();
        }
        while (!nodeList.isEmpty()) {
            Node node = nodeList.popNode();
            if (edgeListArray[node.index()].size() == 0) continue;
            Edge edge = edgeListArray[node.index()].edges().edge();
            object = edge.opposite(node);
            nodeListArray[((Node)object).index()].splice(nodeListArray[node.index()]);
            nodeListArray[((Node)object).index()].addLast(node);
            edgeListArray[((Node)object).index()].remove(edge);
            if (edgeListArray[((Node)object).index()].size() != 1) continue;
            nodeList.addLast(object);
        }
        NodeCursor nodeCursor2 = graph.nodes();
        while (nodeCursor2.ok()) {
            int n3 = nodeCursor2.node().index();
            if (nodeListArray[n3].size() > 0) {
                nodeListArray[n3].addFirst(nodeCursor2.node());
                yList.add(nodeListArray[n3]);
            }
            nodeCursor2.next();
        }
        return (NodeList[])yList.toArray(new NodeList[yList.size()]);
    }

    public static boolean isNaryTree(Graph graph, int n) {
        if (Trees.isRootedTree(graph)) {
            NodeCursor nodeCursor = graph.nodes();
            while (nodeCursor.ok()) {
                if (nodeCursor.node().outDegree() > n) {
                    return false;
                }
                nodeCursor.next();
            }
            return true;
        }
        return false;
    }

    public static boolean isRootedTree(Graph graph) {
        if (graph.isEmpty()) {
            return true;
        }
        boolean bl = false;
        NodeCursor nodeCursor = graph.nodes();
        while (nodeCursor.ok()) {
            Node node = nodeCursor.node();
            if (node.inDegree() == 0) {
                if (bl) {
                    return false;
                }
                bl = true;
            } else if (node.inDegree() != 1) {
                return false;
            }
            nodeCursor.next();
        }
        return bl;
    }

    public static boolean isTree(Graph graph) {
        _a _a2 = new _a();
        _a2.start(graph);
        return _a2.n;
    }

    public static boolean isForest(Graph graph) {
        if (graph.isEmpty()) {
            return true;
        }
        boolean bl = false;
        NodeCursor nodeCursor = graph.nodes();
        while (nodeCursor.ok()) {
            Node node = nodeCursor.node();
            if (node.inDegree() == 0) {
                bl = true;
            } else if (node.inDegree() != 1) {
                return false;
            }
            nodeCursor.next();
        }
        return bl;
    }

    public static NodeList getLeafNodes(Graph graph, boolean bl) {
        NodeList nodeList = new NodeList();
        NodeCursor nodeCursor = graph.nodes();
        while (nodeCursor.ok()) {
            Node node = nodeCursor.node();
            if (bl && node.outDegree() == 0 || !bl && node.degree() == 1) {
                nodeList.add(node);
            }
            nodeCursor.next();
        }
        return nodeList;
    }

    public static Node getCenterRoot(Graph graph) {
        NodeList[] nodeListArray = Bfs.getLayers(graph, Trees.getLeafNodes(graph, false));
        return nodeListArray[nodeListArray.length - 1].firstNode();
    }

    public static Node getRoot(Graph graph) {
        NodeCursor nodeCursor = graph.nodes();
        Node node = null;
        int n = 0;
        nodeCursor.toFirst();
        while (nodeCursor.ok()) {
            if (nodeCursor.node().inDegree() == 0) {
                node = nodeCursor.node();
                ++n;
            }
            nodeCursor.next();
        }
        if (n == 1) {
            return node;
        }
        n = 0;
        nodeCursor.toFirst();
        while (nodeCursor.ok()) {
            if (nodeCursor.node().outDegree() == 0) {
                node = nodeCursor.node();
                ++n;
            }
            nodeCursor.next();
        }
        if (n == 1) {
            return node;
        }
        return Trees.getWeightedCenterNode(graph);
    }

    public static EdgeList directTree(Graph graph) {
        return Trees.directTree(graph, Trees.getRoot(graph));
    }

    public static Node getWeightedCenterNode(Graph graph) {
        int[] nArray = new int[graph.nodeCount()];
        NodeMap nodeMap = Maps.createIndexNodeMap(nArray);
        return Trees.getWeightedCenterNode(graph, nodeMap);
    }

    public static Node getWeightedCenterNode(Graph graph, NodeMap nodeMap) {
        Node node = graph.firstNode();
        Node[] nodeArray = new Node[1];
        int[] nArray = new int[graph.nodeCount()];
        Arrays.fill(nArray, -1);
        EdgeList edgeList = Trees.directTree(graph, node);
        Trees.a(node, nodeMap, nodeArray, nArray, -1);
        EdgeCursor edgeCursor = edgeList.edges();
        while (edgeCursor.ok()) {
            graph.reverseEdge(edgeCursor.edge());
            edgeCursor.next();
        }
        return nodeArray[0];
    }

    private static int a(Node node, NodeMap nodeMap, Node[] nodeArray, int[] nArray, int n) {
        int n2 = 0;
        Edge edge = node.firstOutEdge();
        while (edge != null) {
            Node node2 = edge.target();
            int n3 = Trees.a(node2, nodeMap, nodeArray, nArray, n);
            if (n3 > n) {
                n = n3;
            }
            n2 += nArray[node2.index()];
            edge = edge.nextOutEdge();
        }
        int n4 = n2 * (node.getGraph().N() - 1 - n2);
        Edge edge2 = node.firstOutEdge();
        while (edge2 != null) {
            Node node3 = edge2.target();
            Edge edge3 = edge2.nextOutEdge();
            while (edge3 != null) {
                Node node4 = edge3.target();
                n4 += nArray[node3.index()] * nArray[node4.index()];
                edge3 = edge3.nextOutEdge();
            }
            edge2 = edge2.nextOutEdge();
        }
        nodeMap.setInt(node, n4);
        nArray[node.index()] = n2 + 1;
        if (n4 > n) {
            n = n4;
            nodeArray[0] = node;
        }
        return n;
    }

    public static EdgeList directTree(Graph graph, Node node) {
        final EdgeList edgeList = new EdgeList();
        Dfs dfs = new Dfs(){

            protected void preTraverse(Edge edge, Node node, boolean bl) {
                if (bl && edge.source() == node) {
                    edgeList.push(edge);
                }
            }
        };
        dfs.setDirectedMode(false);
        dfs.start(graph, node);
        EdgeCursor edgeCursor = edgeList.edges();
        while (edgeCursor.ok()) {
            graph.reverseEdge(edgeCursor.edge());
            edgeCursor.next();
        }
        return edgeList;
    }

    private static void a(Node node, NodeList nodeList) {
        NodeCursor nodeCursor = node.successors();
        while (nodeCursor.ok()) {
            Node node2 = nodeCursor.node();
            nodeList.addLast(node2);
            Trees.a(node2, nodeList);
            nodeCursor.next();
        }
    }

    static class _a
    extends Dfs {
        boolean n = true;

        _a() {
            this.setDirectedMode(false);
        }

        protected void preTraverse(Edge edge, Node node, boolean bl) {
            if (!bl) {
                this.n = false;
            }
        }

        protected void lookFurther(Node node) {
            this.n = false;
        }
    }
}

