/*
 * Decompiled with CFR 0.152.
 */
package com.toedter.calendar;

import com.toedter.calendar.DateUtil;
import com.toedter.calendar.IDateEditor;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JSpinnerDateEditor
extends JSpinner
implements IDateEditor,
FocusListener,
ChangeListener {
    private static final long serialVersionUID = 5692204052306085316L;
    protected Date date;
    protected String dateFormatString;
    protected SimpleDateFormat dateFormatter = (SimpleDateFormat)DateFormat.getDateInstance(2);

    public JSpinnerDateEditor() {
        super(new SpinnerDateModel());
        ((JSpinner.DateEditor)this.getEditor()).getTextField().addFocusListener(this);
        DateUtil dateUtil = new DateUtil();
        this.setMinSelectableDate(dateUtil.getMinSelectableDate());
        this.setMaxSelectableDate(dateUtil.getMaxSelectableDate());
        this.addChangeListener(this);
    }

    public Date getDate() {
        if (this.date == null) {
            return null;
        }
        return ((SpinnerDateModel)this.getModel()).getDate();
    }

    public void setDate(Date date) {
        this.setDate(date, true);
    }

    public void setDate(Date date, boolean bl) {
        Date date2 = this.date;
        this.date = date;
        if (date == null) {
            ((JSpinner.DateEditor)this.getEditor()).getFormat().applyPattern("");
            ((JSpinner.DateEditor)this.getEditor()).getTextField().setText("");
        } else if (bl) {
            if (this.dateFormatString != null) {
                ((JSpinner.DateEditor)this.getEditor()).getFormat().applyPattern(this.dateFormatString);
            }
            ((SpinnerDateModel)this.getModel()).setValue(date);
        }
        this.firePropertyChange("date", date2, date);
    }

    public void setDateFormatString(String string) {
        try {
            this.dateFormatter.applyPattern(string);
        }
        catch (RuntimeException runtimeException) {
            this.dateFormatter = (SimpleDateFormat)DateFormat.getDateInstance(2);
            this.dateFormatter.setLenient(false);
        }
        this.dateFormatString = this.dateFormatter.toPattern();
        this.setToolTipText(this.dateFormatString);
        if (this.date != null) {
            ((JSpinner.DateEditor)this.getEditor()).getFormat().applyPattern(this.dateFormatString);
        } else {
            ((JSpinner.DateEditor)this.getEditor()).getFormat().applyPattern("");
        }
        if (this.date != null) {
            String string2 = this.dateFormatter.format(this.date);
            ((JSpinner.DateEditor)this.getEditor()).getTextField().setText(string2);
        }
    }

    public String getDateFormatString() {
        return this.dateFormatString;
    }

    public JComponent getUiComponent() {
        return this;
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.dateFormatter = (SimpleDateFormat)DateFormat.getDateInstance(2, locale);
        this.setDateFormatString(this.dateFormatter.toPattern());
    }

    public void focusLost(FocusEvent focusEvent) {
        String string = ((JSpinner.DateEditor)this.getEditor()).getTextField().getText();
        if (string.length() == 0) {
            this.setDate(null);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (!bl) {
            ((JSpinner.DateEditor)this.getEditor()).getTextField().setBackground(UIManager.getColor("TextField.inactiveBackground"));
        }
    }

    public Date getMaxSelectableDate() {
        return (Date)((SpinnerDateModel)this.getModel()).getEnd();
    }

    public Date getMinSelectableDate() {
        return (Date)((SpinnerDateModel)this.getModel()).getStart();
    }

    public void setMaxSelectableDate(Date date) {
        ((SpinnerDateModel)this.getModel()).setEnd(date);
    }

    public void setMinSelectableDate(Date date) {
        ((SpinnerDateModel)this.getModel()).setStart(date);
    }

    public void setSelectableDateRange(Date date, Date date2) {
        this.setMaxSelectableDate(date2);
        this.setMinSelectableDate(date);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.setDate(((SpinnerDateModel)this.getModel()).getDate(), false);
    }
}

