/*
 * Decompiled with CFR 0.152.
 */
package twaver.table.editor;

import twaver.TUIManager;
import twaver.TWaverUtil;
import twaver.table.editor.AbstractCellEditor;

public class ShortEditor
extends AbstractCellEditor {
    public ShortEditor() {
        this(TUIManager.getString("table.alignment.number"));
    }

    public ShortEditor(String alignment) {
        TWaverUtil.setHorizontalAlignment(this.getComponent(), alignment);
    }

    public Object getCellEditorValue() {
        Object value = super.getCellEditorValue();
        if (value == null || "".equals(value)) {
            return null;
        }
        if (value instanceof Short) {
            return value;
        }
        if (value instanceof Number) {
            return new Short(((Number)value).shortValue());
        }
        try {
            return new Short(Short.parseShort(value.toString()));
        }
        catch (Exception ex) {
            return value;
        }
    }

    public boolean validInputValue(Object inputValue) {
        return inputValue instanceof Short;
    }
}

