/*
 * Decompiled with CFR 0.152.
 */
package twaver.network.ui;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import twaver.Slot;
import twaver.TWaverConst;
import twaver.network.TNetwork;
import twaver.network.ui.BaseEquipmentUI;

public class SlotUI
extends BaseEquipmentUI {
    public SlotUI(TNetwork network, Slot slot) {
        super(network, slot);
    }

    public Slot getSlot() {
        return (Slot)this.element;
    }

    public void paintBody(Graphics2D g2d) {
        super.paintBody(g2d);
        Slot slot = this.getSlot();
        int slotCount = slot.getEquipCount();
        if (slotCount <= 0) {
            return;
        }
        Color elementBodyColor = this.getPaintBodyColor(this.color);
        if (elementBodyColor != null) {
            g2d.setStroke(TWaverConst.BASIC_STROKE);
            g2d.setColor(elementBodyColor);
            for (int i2 = 0; i2 < slotCount; ++i2) {
                Rectangle rect = slot.getEquipBoundsByIndex(i2);
                g2d.draw3DRect(rect.x - 1, rect.y - 1, rect.width + 1, rect.height + 1, false);
            }
        }
    }
}

