/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.cots.twaver.graph;

import com.nepxion.cots.twaver.graph.TGraph;
import com.nepxion.cots.twaver.graph.TLayoutType;
import com.nepxion.cots.twaver.graph.TLayouter;
import com.nepxion.cots.twaver.icon.TIconFactory;
import com.nepxion.cots.twaver.locale.TLocale;
import com.nepxion.swing.border.BorderManager;
import com.nepxion.swing.button.ButtonManager;
import com.nepxion.swing.button.JBasicButton;
import com.nepxion.swing.checkbox.JBasicCheckBox;
import com.nepxion.swing.combobox.JBasicComboBox;
import com.nepxion.swing.layout.table.TableLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TLayoutPanel
extends JPanel {
    private JLabel typeLabel;
    private JBasicComboBox typeComboBox;
    private JLabel forceSizeLabel;
    private JSlider forceSizeSlider;
    private JLabel stepSizeLabel;
    private JSlider stepSizeSlider;
    private JLabel updateDurationLabel;
    private JSlider updateDurationSlider;
    private JLabel elementLabel;
    private JBasicComboBox elementComboBox;
    private JLabel xOffsetLabel;
    private JSlider xOffsetSlider;
    private JLabel yOffsetLabel;
    private JSlider yOffsetSlider;
    private JLabel xGapLabel;
    private JSlider xGapSlider;
    private JLabel yGapLabel;
    private JSlider yGapSlider;
    private JLabel animationLabel;
    private JBasicCheckBox animationCheckBox;
    private JBasicButton runButton;
    private JBasicButton stopButton;
    private TLayouter layouter;

    public TLayoutPanel(TGraph graph) {
        this.layouter = new TLayouter(graph);
        double[][] size1 = new double[][]{{0.35, 0.65}, {22.0}};
        this.typeLabel = new JLabel(TLocale.getString("layout_type"));
        this.typeComboBox = new JBasicComboBox((Object[])new TLayoutType[]{TLayoutType.SPRING_LAYOUT_TYPE, TLayoutType.CIRCULAR_LAYOUT_TYPE, TLayoutType.HIERARCHIC_LAYOUT_TYPE, TLayoutType.SYMMETRIC_LAYOUT_TYPE, TLayoutType.TREE_LAYOUT_TYPE, TLayoutType.REVERSE_TREE_LAYOUT_TYPE, TLayoutType.RANDOM_LAYOUT_TYPE});
        this.typeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TLayoutPanel.this.doLayout(TLayoutPanel.this.stopButton.isEnabled());
            }
        });
        this.typeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (TLayoutPanel.this.typeComboBox.getSelectedItem() != e.getItem()) {
                    if (TLayoutPanel.this.typeComboBox.getSelectedItem().equals(TLayoutType.SPRING_LAYOUT_TYPE)) {
                        TLayoutPanel.this.forceSizeLabel.setVisible(true);
                        TLayoutPanel.this.forceSizeSlider.setVisible(true);
                        TLayoutPanel.this.stepSizeLabel.setVisible(true);
                        TLayoutPanel.this.stepSizeSlider.setVisible(true);
                        TLayoutPanel.this.updateDurationLabel.setVisible(true);
                        TLayoutPanel.this.updateDurationSlider.setVisible(true);
                        TLayoutPanel.this.elementLabel.setVisible(false);
                        TLayoutPanel.this.elementComboBox.setVisible(false);
                        TLayoutPanel.this.xOffsetLabel.setVisible(false);
                        TLayoutPanel.this.xOffsetSlider.setVisible(false);
                        TLayoutPanel.this.yOffsetLabel.setVisible(false);
                        TLayoutPanel.this.yOffsetSlider.setVisible(false);
                        TLayoutPanel.this.xGapLabel.setVisible(false);
                        TLayoutPanel.this.xGapSlider.setVisible(false);
                        TLayoutPanel.this.yGapLabel.setVisible(false);
                        TLayoutPanel.this.yGapSlider.setVisible(false);
                        TLayoutPanel.this.animationLabel.setVisible(false);
                        TLayoutPanel.this.animationCheckBox.setVisible(false);
                    } else {
                        TLayoutPanel.this.forceSizeLabel.setVisible(false);
                        TLayoutPanel.this.forceSizeSlider.setVisible(false);
                        TLayoutPanel.this.stepSizeLabel.setVisible(false);
                        TLayoutPanel.this.stepSizeSlider.setVisible(false);
                        TLayoutPanel.this.updateDurationLabel.setVisible(false);
                        TLayoutPanel.this.updateDurationSlider.setVisible(false);
                        TLayoutPanel.this.elementLabel.setVisible(true);
                        TLayoutPanel.this.elementComboBox.setVisible(true);
                        TLayoutPanel.this.xOffsetLabel.setVisible(true);
                        TLayoutPanel.this.xOffsetSlider.setVisible(true);
                        TLayoutPanel.this.yOffsetLabel.setVisible(true);
                        TLayoutPanel.this.yOffsetSlider.setVisible(true);
                        TLayoutPanel.this.xGapLabel.setVisible(true);
                        TLayoutPanel.this.xGapSlider.setVisible(true);
                        TLayoutPanel.this.yGapLabel.setVisible(true);
                        TLayoutPanel.this.yGapSlider.setVisible(true);
                        TLayoutPanel.this.animationLabel.setVisible(true);
                        TLayoutPanel.this.animationCheckBox.setVisible(true);
                    }
                }
            }
        });
        JPanel layoutTypePanel = new JPanel();
        layoutTypePanel.setBorder(BorderManager.createComplexTitledBorder((String)TLocale.getString("layout_type_setting")));
        layoutTypePanel.setLayout((LayoutManager)new TableLayout((double[][])size1));
        layoutTypePanel.add((Component)this.typeLabel, "0, 0");
        layoutTypePanel.add((Component)this.typeComboBox, "1, 0");
        this.forceSizeLabel = new JLabel(TLocale.getString("layout_force_size"));
        this.forceSizeSlider = new JSlider(10, 500, this.layouter.getForceSize());
        this.forceSizeSlider.setToolTipText(this.forceSizeSlider.getValue() + "");
        this.forceSizeSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TLayoutPanel.this.layouter.setForceSize(TLayoutPanel.this.forceSizeSlider.getValue());
                TLayoutPanel.this.forceSizeSlider.setToolTipText(TLayoutPanel.this.forceSizeSlider.getValue() + "");
            }
        });
        this.stepSizeLabel = new JLabel(TLocale.getString("layout_step_size"));
        this.stepSizeSlider = new JSlider(1, 1000, this.layouter.getStepSize());
        this.stepSizeSlider.setToolTipText(this.stepSizeSlider.getValue() + "");
        this.stepSizeSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TLayoutPanel.this.layouter.setStepSize(TLayoutPanel.this.stepSizeSlider.getValue());
                TLayoutPanel.this.stepSizeSlider.setToolTipText(TLayoutPanel.this.stepSizeSlider.getValue() + "");
            }
        });
        this.updateDurationLabel = new JLabel(TLocale.getString("layout_update_duration"));
        this.updateDurationSlider = new JSlider(1, 500, this.layouter.getUpdateDuration());
        this.updateDurationSlider.setToolTipText(this.updateDurationSlider.getValue() + "");
        this.updateDurationSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TLayoutPanel.this.layouter.setUpdateDuration(TLayoutPanel.this.updateDurationSlider.getValue());
                TLayoutPanel.this.updateDurationSlider.setToolTipText(TLayoutPanel.this.updateDurationSlider.getValue() + "");
            }
        });
        this.elementLabel = new JLabel(TLocale.getString("layout_range"));
        this.elementComboBox = new JBasicComboBox((Object[])new String[]{TLocale.getString("layout_range_all_elements"), TLocale.getString("layout_range_selected_elements")});
        this.elementComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TLayoutPanel.this.doLayout(TLayoutPanel.this.stopButton.isEnabled());
            }
        });
        this.xOffsetLabel = new JLabel(TLocale.getString("layout_x_offset"));
        this.xOffsetSlider = new JSlider(0, 2000, 150);
        this.xOffsetSlider.setToolTipText(this.xOffsetSlider.getValue() + "");
        this.xOffsetSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TLayoutPanel.this.xOffsetSlider.setToolTipText(TLayoutPanel.this.xOffsetSlider.getValue() + "");
                TLayoutPanel.this.doLayout(TLayoutPanel.this.stopButton.isEnabled());
            }
        });
        this.yOffsetLabel = new JLabel(TLocale.getString("layout_y_offset"));
        this.yOffsetSlider = new JSlider(0, 2000, 50);
        this.yOffsetSlider.setToolTipText(this.yOffsetSlider.getValue() + "");
        this.yOffsetSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TLayoutPanel.this.yOffsetSlider.setToolTipText(TLayoutPanel.this.yOffsetSlider.getValue() + "");
                TLayoutPanel.this.doLayout(TLayoutPanel.this.stopButton.isEnabled());
            }
        });
        this.xGapLabel = new JLabel(TLocale.getString("layout_x_gap"));
        this.xGapSlider = new JSlider(1, 500, 50);
        this.xGapSlider.setToolTipText(this.xGapSlider.getValue() + "");
        this.xGapSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TLayoutPanel.this.xGapSlider.setToolTipText(TLayoutPanel.this.xGapSlider.getValue() + "");
                TLayoutPanel.this.doLayout(TLayoutPanel.this.stopButton.isEnabled());
            }
        });
        this.yGapLabel = new JLabel(TLocale.getString("layout_y_gap"));
        this.yGapSlider = new JSlider(1, 500, 50);
        this.yGapSlider.setToolTipText(this.yGapSlider.getValue() + "");
        this.yGapSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TLayoutPanel.this.yGapSlider.setToolTipText(TLayoutPanel.this.yGapSlider.getValue() + "");
                TLayoutPanel.this.doLayout(TLayoutPanel.this.stopButton.isEnabled());
            }
        });
        this.animationLabel = new JLabel(TLocale.getString("layout_effect"));
        this.animationCheckBox = new JBasicCheckBox(TLocale.getString("layout_effect_animation"), true);
        double[][] size2 = new double[][]{{0.35, 0.65}, {22.0, 22.0, 22.0, 22.0, 22.0, 22.0}};
        JPanel layoutParamPanel = new JPanel();
        layoutParamPanel.setBorder(BorderManager.createComplexTitledBorder((String)TLocale.getString("layout_parameter_setting")));
        layoutParamPanel.setLayout((LayoutManager)new TableLayout((double[][])size2));
        layoutParamPanel.add((Component)this.forceSizeLabel, "0, 0");
        layoutParamPanel.add((Component)this.forceSizeSlider, "1, 0");
        layoutParamPanel.add((Component)this.elementLabel, "0, 0");
        layoutParamPanel.add((Component)this.elementComboBox, "1, 0");
        layoutParamPanel.add((Component)this.stepSizeLabel, "0, 1");
        layoutParamPanel.add((Component)this.stepSizeSlider, "1, 1");
        layoutParamPanel.add((Component)this.xOffsetLabel, "0, 1");
        layoutParamPanel.add((Component)this.xOffsetSlider, "1, 1");
        layoutParamPanel.add((Component)this.updateDurationLabel, "0, 2");
        layoutParamPanel.add((Component)this.updateDurationSlider, "1, 2");
        layoutParamPanel.add((Component)this.yOffsetLabel, "0, 2");
        layoutParamPanel.add((Component)this.yOffsetSlider, "1, 2");
        layoutParamPanel.add((Component)this.xGapLabel, "0, 3");
        layoutParamPanel.add((Component)this.xGapSlider, "1, 3");
        layoutParamPanel.add((Component)this.yGapLabel, "0, 4");
        layoutParamPanel.add((Component)this.yGapSlider, "1, 4");
        layoutParamPanel.add((Component)this.animationLabel, "0, 5");
        layoutParamPanel.add((Component)this.animationCheckBox, "1, 5");
        this.runButton = new JBasicButton(TLocale.getString("layout_run"), (Icon)TIconFactory.getContextIcon("run.png"), TLocale.getString("layout_run_description"));
        this.runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TLayoutPanel.this.doLayout(true);
                TLayoutPanel.this.runButton.setEnabled(false);
                TLayoutPanel.this.stopButton.setEnabled(true);
            }
        });
        this.stopButton = new JBasicButton(TLocale.getString("layout_stop"), (Icon)TIconFactory.getContextIcon("stop.png"), TLocale.getString("layout_stop_description"));
        this.stopButton.setEnabled(false);
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TLayoutPanel.this.layouter.stop();
                TLayoutPanel.this.runButton.setEnabled(true);
                TLayoutPanel.this.stopButton.setEnabled(false);
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        buttonPanel.add(Box.createGlue());
        buttonPanel.add((Component)this.runButton);
        buttonPanel.add((Component)this.stopButton);
        buttonPanel.add(Box.createGlue());
        ButtonManager.updateUI((Container)buttonPanel, (Dimension)new Dimension(55, 25));
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add(layoutTypePanel);
        this.add(layoutParamPanel);
        this.add(buttonPanel);
        this.typeComboBox.setSelectedIndex(1);
    }

    private void doLayout(boolean enabled) {
        if (enabled) {
            TLayoutType layoutType = (TLayoutType)this.typeComboBox.getSelectedItem();
            this.doLayout(layoutType);
        }
    }

    private void doLayout(TLayoutType layoutType) {
        boolean isAllElementsLayouted = this.elementComboBox.getSelectedIndex() == 0;
        boolean isAnimated = this.animationCheckBox.isSelected();
        int xOffset = this.xOffsetSlider.getValue();
        int yOffset = this.yOffsetSlider.getValue();
        int xGap = this.xGapSlider.getValue();
        int yGap = this.yGapSlider.getValue();
        this.layouter.doLayout(layoutType, isAllElementsLayouted, isAnimated, xOffset, yOffset, xGap, yGap);
    }
}

