/*
 * Decompiled with CFR 0.152.
 */
package y.layout.hierarchic;

import y.algo.AlgorithmAbortedException;
import y.base.DataProvider;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.ListCell;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.base.NodeMap;
import y.base.YCursor;
import y.base.YList;
import y.layout.LayoutGraph;
import y.layout.hierarchic.AbstractDrawer;
import y.util.Maps;
import y.util.Timer;

public class PendularDrawer
extends AbstractDrawer {
    static final boolean ai = false;
    private boolean aj = false;
    private double ak;
    private double ag;
    private double al = 10.0;
    private double am = 2.0;
    static final double aw = 1.0E-5;
    protected NodeMap right;
    protected NodeMap left;
    private int ar = 1;
    Timer as = new Timer(false);
    Timer au = new Timer(false);
    Timer an = new Timer(false);
    Timer at = new Timer(false);
    Timer ah = new Timer(false);
    Timer a0 = new Timer(false);
    Timer az = new Timer(false);
    Timer ap = new Timer(false);
    Timer ay = new Timer(false);
    Timer aq = new Timer(false);
    Timer ax = new Timer(false);
    Timer av = new Timer(false);
    private static String ao = "TOKEN";

    protected void initStructures() {
        this.as.toggle();
        this.ak = Math.max(this.getMinimalMultiEdgeDistance(), this.getMinimalEdgeDistance());
        if (this.ak < 1.0) {
            this.ak = 1.0;
        }
        this.ag = (double)((int)(this.getMinimalNodeDistance() / this.ak)) * this.ak;
        this.right = Maps.createIndexNodeMap(new Object[this.graph.nodeCount()]);
        this.left = Maps.createIndexNodeMap(new Object[this.graph.nodeCount()]);
        this.as.toggle();
    }

    protected void assignCoordinates(NodeList[] nodeListArray, DataProvider dataProvider) {
        this.au.toggle();
        this.initStructures();
        this.initializePositions(nodeListArray);
        double d2 = this.getZ();
        double d3 = Double.POSITIVE_INFINITY;
        int n = 0;
        while (n < this.ar && d2 < d3) {
            AlgorithmAbortedException.check();
            ++n;
            d3 = d2;
            int n2 = 1;
            while (n2 < nodeListArray.length) {
                YList yList = this.partitionLayer(nodeListArray[n2], -1);
                this.shakePartition(yList, -1);
                ++n2;
            }
            int n3 = nodeListArray.length - 2;
            while (n3 >= 0) {
                YList yList = this.partitionLayer(nodeListArray[n3], 1);
                this.shakePartition(yList, 1);
                --n3;
            }
            int n4 = 1;
            while (n4 < nodeListArray.length - 1) {
                YList yList = this.partitionLayer(nodeListArray[n4], 0);
                this.shakePartition(yList, 0);
                ++n4;
            }
            this.minNode();
            d2 = this.getZ();
        }
        AlgorithmAbortedException.check();
        YList yList = this.findChains();
        this.minPath(yList);
        this.au.toggle();
    }

    protected void disposeStructures() {
        this.graph.disposeNodeMap(this.left);
        this.graph.disposeNodeMap(this.right);
    }

    protected boolean minPath(YList yList) {
        boolean bl;
        this.an.toggle();
        boolean bl2 = false;
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[2];
        do {
            bl = false;
            YCursor yCursor = yList.cursor();
            while (yCursor.ok()) {
                NodeList nodeList = (NodeList)yCursor.current();
                Node node = nodeList.firstNode();
                dArray[0] = this.getMaximumExtent(node, true);
                dArray[1] = this.getMaximumExtent(node, false);
                ListCell listCell = nodeList.firstCell();
                ListCell listCell2 = nodeList.firstCell().succ();
                while (listCell2 != null) {
                    node = (Node)listCell2.getInfo();
                    dArray2[0] = this.getMaximumExtent(node, true);
                    dArray2[1] = this.getMaximumExtent(node, false);
                    dArray3[0] = Math.max(dArray[0], dArray2[0]);
                    dArray3[1] = Math.min(dArray[1], dArray2[1]);
                    if (dArray3[1] < dArray3[0]) {
                        ListCell listCell3 = listCell2.pred();
                        if (listCell3 != null && listCell3 != listCell) {
                            bl2 |= (bl |= this.straightenPath(listCell, listCell3, dArray));
                        }
                        listCell = listCell2;
                        dArray[0] = dArray2[0];
                        dArray[1] = dArray2[1];
                    } else {
                        dArray[0] = dArray3[0];
                        dArray[1] = dArray3[1];
                    }
                    listCell2 = listCell2.succ();
                }
                bl2 |= (bl |= this.straightenPath(listCell, nodeList.lastCell(), dArray));
                yCursor.next();
            }
        } while (bl);
        this.an.toggle();
        return bl2;
    }

    protected YList findChains() {
        this.at.toggle();
        NodeMap nodeMap = Maps.createIndexNodeMap(new Object[this.graph.nodeCount()]);
        YList yList = new YList();
        NodeCursor nodeCursor = this.graph.nodes();
        while (nodeCursor.ok()) {
            Node node = nodeCursor.node();
            if (nodeMap.get(node) == null && this.isSegmentNode(node)) {
                while (node.inDegree() == 1 && this.isSegmentNode(node.predecessors().node())) {
                    node = node.predecessors().node();
                }
                NodeList nodeList = new NodeList();
                nodeList.add(node);
                nodeMap.set(node, nodeList);
                while (node.outDegree() == 1) {
                    if (!this.isSegmentNode(node = node.successors().node())) break;
                    nodeList.add(node);
                    nodeMap.set(node, nodeList);
                }
                if (nodeList.size() > 1) {
                    yList.add(nodeList);
                }
            }
            nodeCursor.next();
        }
        this.at.toggle();
        return yList;
    }

    protected boolean straightenPath(ListCell listCell, ListCell listCell2, double[] dArray) {
        double d2;
        this.ah.toggle();
        boolean bl = false;
        if (listCell == listCell2) {
            this.ah.toggle();
            return false;
        }
        Node node = (Node)listCell.getInfo();
        Node node2 = (Node)listCell2.getInfo();
        double d3 = (dArray[0] + dArray[1]) / 2.0;
        if (dArray[0] <= -1.7976931348623157E308) {
            dArray[0] = Math.min(this.graph.getCenterX(node), this.graph.getCenterX(node2));
            d2 = dArray[0];
            if (node.inDegree() == 1) {
                d2 = Math.min(d2, this.graph.getCenterX(node.predecessors().node()));
            }
            if (node2.outDegree() == 1) {
                d2 = Math.min(d2, this.graph.getCenterX(node2.successors().node()));
            }
            dArray[0] = d2;
            if (dArray[0] > dArray[1]) {
                dArray[0] = dArray[1];
            }
            d3 = dArray[0];
        }
        if (dArray[1] >= Double.MAX_VALUE) {
            dArray[1] = Math.max(this.graph.getCenterX(node), this.graph.getCenterX(node2));
            d2 = dArray[1];
            if (node.inDegree() == 1) {
                d2 = Math.max(d2, this.graph.getCenterX(node.predecessors().node()));
            }
            if (node2.outDegree() == 1) {
                d2 = Math.max(d2, this.graph.getCenterX(node2.successors().node()));
            }
            dArray[1] = d2;
            if (dArray[1] < dArray[0]) {
                dArray[1] = dArray[0];
            }
            d3 = dArray[1];
        }
        do {
            Node node3 = (Node)listCell.getInfo();
            if (!bl && Math.abs(this.graph.getCenterX(node3) - d3) > 5.0) {
                bl = true;
            }
            this.graph.setCenter(node3, d3, this.graph.getCenterY(node3));
        } while ((listCell = listCell.succ()) != listCell2.succ());
        this.ah.toggle();
        return bl;
    }

    protected boolean isSegmentNode(Node node) {
        if (node.inDegree() == 1) {
            return node.outDegree() < 2;
        }
        if (node.outDegree() == 1) {
            return node.inDegree() < 2;
        }
        return false;
    }

    protected void minNode() {
        this.a0.toggle();
        NodeList nodeList = new NodeList(this.graph.nodes());
        boolean[] blArray = new boolean[this.graph.nodeCount()];
        int n = 0;
        while (!nodeList.isEmpty() && n < this.graph.nodeCount() * this.graph.nodeCount()) {
            ++n;
            Node node = nodeList.popNode();
            blArray[node.index()] = true;
            double d2 = this.getPendulumForce(node, node.edges());
            if (!(Math.abs(d2 = this.verifyMovement(node, d2)) > 1.0E-5)) continue;
            this.move(node, d2);
            NodeCursor nodeCursor = node.neighbors();
            while (nodeCursor.ok()) {
                if (blArray[nodeCursor.node().index()]) {
                    blArray[nodeCursor.node().index()] = false;
                    nodeList.addLast(nodeCursor.node());
                }
                nodeCursor.next();
            }
        }
        this.a0.toggle();
    }

    protected void shakePartition(YList yList, int n) {
        this.az.toggle();
        YCursor yCursor = yList.cursor();
        while (yCursor.ok()) {
            NodeList nodeList = (NodeList)yCursor.current();
            double d2 = this.getPendulumForce(nodeList.cursor(), n);
            if (d2 < 0.0) {
                d2 = this.verifyMovement(nodeList.firstNode(), d2);
                this.move(nodeList.cursor(), d2);
            } else {
                d2 = this.verifyMovement((Node)nodeList.last(), d2);
                this.move(nodeList.cursor(), d2);
            }
            yCursor.next();
        }
        this.az.toggle();
    }

    protected YList partitionLayer(NodeList nodeList, int n) {
        this.ap.toggle();
        YList yList = new YList();
        NodeCursor nodeCursor = nodeList.nodes();
        while (nodeCursor.ok()) {
            NodeList nodeList2 = new NodeList();
            nodeList2.add(nodeCursor.node());
            yList.add(nodeList2);
            nodeCursor.next();
        }
        boolean bl = false;
        do {
            bl = false;
            ListCell listCell = yList.firstCell();
            while (listCell != null) {
                double d2;
                double d3;
                NodeList nodeList3 = (NodeList)listCell.getInfo();
                if ((listCell = listCell.succ()) == null) continue;
                NodeList nodeList4 = (NodeList)listCell.getInfo();
                if (!this.touches((Node)nodeList3.last(), nodeList4.firstNode()) || !((d3 = this.getPendulumForce(nodeList3.cursor(), n)) >= (d2 = this.getPendulumForce(nodeList4.cursor(), n)))) continue;
                bl = true;
                nodeList3.addAll(nodeList4.cursor());
                ListCell listCell2 = listCell;
                yList.removeCell(listCell2);
                listCell = listCell.succ();
            }
        } while (bl);
        this.ap.toggle();
        return yList;
    }

    protected void setLayoutGraph(LayoutGraph layoutGraph) {
        this.graph = layoutGraph;
    }

    protected double getPendulumForce(Node node, EdgeCursor edgeCursor) {
        double d2 = 0.0;
        double d3 = 0.0;
        edgeCursor.toFirst();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            double d4 = this.getEdgeWeight(edge);
            d3 += d4;
            d2 += d4 * (this.graph.getCenterX(edge.opposite(node)) - this.graph.getCenterX(node));
            edgeCursor.next();
        }
        if (d2 == 0.0) {
            return 0.0;
        }
        return d2 / d3;
    }

    protected boolean touches(Node node, Node node2) {
        if (this.right.get(node) == node2) {
            return this.getLeftX(node2) - this.getRightX(node) - 1.0E-5 < this.getMinimalLayerDistance(node, false);
        }
        if (this.left.get(node) == node2) {
            return this.getLeftX(node) - this.getRightX(node2) - 1.0E-5 < this.getMinimalLayerDistance(node, true);
        }
        return false;
    }

    protected double verifyMovement(Node node, double d2) {
        this.aq.toggle();
        if (d2 != 0.0) {
            if (d2 < 0.0) {
                Node node2 = (Node)this.left.get(node);
                if (node2 != null) {
                    d2 = Math.max(d2, this.getRightX(node2) - this.getLeftX(node) + this.getMinimalLayerDistance(node, true));
                }
            } else {
                Node node3 = (Node)this.right.get(node);
                if (node3 != null) {
                    d2 = Math.min(d2, this.getLeftX(node3) - this.getRightX(node) - this.getMinimalLayerDistance(node, false));
                }
            }
        }
        this.aq.toggle();
        return d2;
    }

    protected double getPendulumForce(YCursor yCursor, int n) {
        this.ay.toggle();
        int n2 = 0;
        double d2 = 0.0;
        yCursor.toFirst();
        while (yCursor.ok()) {
            ++n2;
            Node node = (Node)yCursor.current();
            d2 = n == -1 ? (d2 += this.getPendulumForce(node, node.inEdges())) : (n == 0 ? (d2 += this.getPendulumForce(node, node.edges())) : (d2 += this.getPendulumForce(node, node.outEdges())));
            yCursor.next();
        }
        this.ay.toggle();
        return d2 / (double)n2;
    }

    protected void move(Node node, double d2) {
        double d3 = this.graph.getCenterX(node) + d2;
        if (this.aj) {
            d3 = this.dummyMap.get(node) == null ? (double)((int)((d3 + this.ag / 2.0) / this.ag)) * this.ag : (double)((int)((d3 + this.ak / 2.0) / this.ak)) * this.ak;
        }
        this.graph.setCenter(node, d3, this.graph.getCenterY(node));
    }

    protected void move(YCursor yCursor, double d2) {
        yCursor.toFirst();
        while (yCursor.ok()) {
            Node node = (Node)yCursor.current();
            this.move(node, d2);
            yCursor.next();
        }
    }

    protected double getZ() {
        this.ax.toggle();
        double d2 = 0.0;
        NodeCursor nodeCursor = this.graph.nodes();
        while (nodeCursor.ok()) {
            EdgeCursor edgeCursor = nodeCursor.node().edges();
            while (edgeCursor.ok()) {
                Edge edge = edgeCursor.edge();
                d2 += this.getEdgeWeight(edge) * Math.abs(this.graph.getCenterX(edge.source()) - this.graph.getCenterX(edge.target()));
                edgeCursor.next();
            }
            nodeCursor.next();
        }
        this.ax.toggle();
        return d2;
    }

    protected double getEdgeWeight(Edge edge) {
        if (this.dummyMap.get(edge.source()) == null) {
            if (this.dummyMap.get(edge.target()) == null) {
                return 1.0;
            }
            return this.am * 1.0;
        }
        if (this.dummyMap.get(edge.target()) == null) {
            return this.am * 1.0;
        }
        return this.al * 1.0;
    }

    protected double getMaximumExtent(Node node, boolean bl) {
        if (bl) {
            Node node2 = (Node)this.left.get(node);
            if (node2 == null) {
                return -1.7976931348623157E308;
            }
            return this.getRightX(node2) + this.getMinimalLayerDistance(node, true) + this.getLeftHalf(node);
        }
        Node node3 = (Node)this.right.get(node);
        if (node3 == null) {
            return Double.MAX_VALUE;
        }
        return this.getLeftX(node3) - this.getMinimalLayerDistance(node, false) - this.getRightHalf(node);
    }

    protected double getMinimalLayerDistance(Node node, boolean bl) {
        Node node2;
        if (bl) {
            if (this.left.get(node) == null) {
                return 0.0;
            }
            node2 = (Node)this.left.get(node);
        } else {
            if (this.right.get(node) == null) {
                return 0.0;
            }
            node2 = (Node)this.right.get(node);
        }
        Edge edge = (Edge)this.dummyMap.get(node);
        Edge edge2 = (Edge)this.dummyMap.get(node2);
        if (edge == null || edge2 == null) {
            return this.getMinimalNodeDistance();
        }
        if (edge.target() == edge2.source() || edge.target() == edge2.target()) {
            return this.getMinimalMultiEdgeDistance();
        }
        return this.getMinimalEdgeDistance();
    }

    protected void initializePositions(NodeList[] nodeListArray) {
        this.av.toggle();
        this.assignYCoords(this.graph, nodeListArray);
        int n = 0;
        while (n < nodeListArray.length) {
            double d2 = 0.0;
            Node node = null;
            NodeCursor nodeCursor = nodeListArray[n].nodes();
            while (nodeCursor.ok()) {
                Node node2 = nodeCursor.node();
                if (node != null) {
                    this.right.set(node, node2);
                    this.left.set(node2, node);
                }
                node = node2;
                d2 += this.graph.getNodeLayout(node2).getWidth() / 2.0 + this.getLeftBorder(node2) + this.getMinimalLayerDistance(node2, true);
                if (this.aj) {
                    d2 = this.dummyMap.get(node2) == null ? (double)((int)((d2 + this.ag / 2.0) / this.ag)) * this.ag : (double)((int)((d2 + this.ak / 2.0) / this.ak)) * this.ak;
                }
                this.graph.setCenter(node2, d2, this.graph.getCenterY(node2));
                d2 += this.graph.getNodeLayout(node2).getWidth() / 2.0 + this.getRightBorder(node2);
                nodeCursor.next();
            }
            ++n;
        }
        this.av.toggle();
    }
}

