/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.chart.bar;

import com.nepxion.swing.chart.bar.RectangleBarRenderer3D;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleEdge;

public class CylinderBarRenderer3D
extends RectangleBarRenderer3D {
    public CylinderBarRenderer3D() {
    }

    public CylinderBarRenderer3D(double xOffset, double yOffset) {
        super(xOffset, yOffset);
    }

    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int i, int j, int k) {
        EntityCollection entityCollection;
        CategoryItemLabelGenerator categoryItemLabelGenerator;
        Number number = categoryDataset.getValue(i, j);
        if (number == null) {
            return;
        }
        double d = number.doubleValue();
        Rectangle2D.Double double1 = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + this.getYOffset(), rectangle2D.getWidth() - this.getXOffset(), rectangle2D.getHeight() - this.getYOffset());
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        double d1 = this.calculateBarW0(categoryPlot, plotOrientation, double1, categoryAxis, categoryItemRendererState, i, j);
        double[] ad = this.calculateBarL0L1(d);
        if (ad == null) {
            return;
        }
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        float f = (float)valueAxis.valueToJava2D(ad[0], (Rectangle2D)double1, rectangleEdge);
        float f1 = (float)valueAxis.valueToJava2D(ad[1], (Rectangle2D)double1, rectangleEdge);
        float f2 = Math.min(f, f1);
        float f3 = Math.abs(f1 - f);
        GeneralPath generalPath = new GeneralPath();
        Ellipse2D.Double double2 = null;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            generalPath.moveTo((float)((double)f2 + this.getXOffset() / 2.0), (float)d1);
            generalPath.lineTo((float)((double)(f2 + f3) + this.getXOffset() / 2.0), (float)d1);
            Arc2D.Double double3 = new Arc2D.Double(f2 + f3, d1, this.getXOffset(), categoryItemRendererState.getBarWidth(), 90.0, 180.0, 0);
            generalPath.append(double3, true);
            generalPath.lineTo((float)((double)f2 + this.getXOffset() / 2.0), (float)(d1 + categoryItemRendererState.getBarWidth()));
            double3 = new Arc2D.Double(f2, d1, this.getXOffset(), categoryItemRendererState.getBarWidth(), 270.0, -180.0, 0);
            generalPath.append(double3, true);
            generalPath.closePath();
            double2 = new Ellipse2D.Double(f2 + f3, d1, this.getXOffset(), categoryItemRendererState.getBarWidth());
        } else {
            generalPath.moveTo((float)d1, (float)((double)f2 - this.getYOffset() / 2.0));
            generalPath.lineTo((float)d1, (float)((double)(f2 + f3) - this.getYOffset() / 2.0));
            Arc2D.Double double4 = new Arc2D.Double(d1, (double)(f2 + f3) - this.getYOffset(), categoryItemRendererState.getBarWidth(), this.getYOffset(), 180.0, 180.0, 0);
            generalPath.append(double4, true);
            generalPath.lineTo((float)(d1 + categoryItemRendererState.getBarWidth()), (float)((double)f2 - this.getYOffset() / 2.0));
            double4 = new Arc2D.Double(d1, (double)f2 - this.getYOffset(), categoryItemRendererState.getBarWidth(), this.getYOffset(), 0.0, -180.0, 0);
            generalPath.append(double4, true);
            generalPath.closePath();
            double2 = new Ellipse2D.Double(d1, (double)f2 - this.getYOffset(), categoryItemRendererState.getBarWidth(), this.getYOffset());
        }
        Paint itemPaint = this.getItemPaint(i, j);
        if (this.getGradientPaintTransformer() != null && itemPaint instanceof GradientPaint) {
            GradientPaint gradientpaint = (GradientPaint)itemPaint;
            itemPaint = this.getGradientPaintTransformer().transform(gradientpaint, (Shape)generalPath);
        }
        graphics2D.setPaint(itemPaint);
        graphics2D.fill(generalPath);
        if (itemPaint instanceof GradientPaint) {
            graphics2D.setPaint(((GradientPaint)itemPaint).getColor2());
        }
        if (double2 != null) {
            graphics2D.fill(double2);
        }
        if (this.isDrawBarOutline() && categoryItemRendererState.getBarWidth() > 3.0) {
            graphics2D.setStroke(this.getItemOutlineStroke(i, j));
            graphics2D.setPaint(this.getItemOutlinePaint(i, j));
            graphics2D.draw(generalPath);
            if (double2 != null) {
                graphics2D.draw(double2);
            }
        }
        if ((categoryItemLabelGenerator = this.getItemLabelGenerator(i, j)) != null && this.isItemLabelVisible(i, j)) {
            this.drawItemLabel(graphics2D, categoryDataset, i, j, categoryPlot, categoryItemLabelGenerator, generalPath.getBounds2D(), d < 0.0);
        }
        if (categoryItemRendererState.getInfo() != null && (entityCollection = categoryItemRendererState.getEntityCollection()) != null) {
            String toolTip = null;
            CategoryToolTipGenerator categoryToolTipGenerator = this.getToolTipGenerator(i, j);
            if (categoryToolTipGenerator != null) {
                toolTip = categoryToolTipGenerator.generateToolTip(categoryDataset, i, j);
            }
            String url = null;
            if (this.getItemURLGenerator(i, j) != null) {
                url = this.getItemURLGenerator(i, j).generateURL(categoryDataset, i, j);
            }
            CategoryItemEntity categoryItemEntity = new CategoryItemEntity((Shape)generalPath.getBounds2D(), toolTip, url, categoryDataset, categoryDataset.getRowKey(i), categoryDataset.getColumnKey(j));
            entityCollection.add((ChartEntity)categoryItemEntity);
        }
    }
}

