/*
 * Decompiled with CFR 0.152.
 */
package y.geom;

import java.text.DecimalFormat;

public final class YPoint
implements Comparable {
    public final double x;
    public final double y;
    private static DecimalFormat a = new DecimalFormat("#.###");
    public static final YPoint ORIGIN = new YPoint(0.0, 0.0);

    public YPoint() {
        this.x = 0.0;
        this.y = 0.0;
    }

    public YPoint(double d2, double d3) {
        this.x = d2;
        this.y = d3;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public static double distance(YPoint yPoint, YPoint yPoint2) {
        return Math.sqrt((yPoint.x - yPoint2.x) * (yPoint.x - yPoint2.x) + (yPoint.y - yPoint2.y) * (yPoint.y - yPoint2.y));
    }

    public static double distance(double d2, double d3, double d4, double d5) {
        return Math.sqrt((d2 -= d4) * d2 + (d3 -= d5) * d3);
    }

    public static YPoint add(YPoint yPoint, YPoint yPoint2) {
        return new YPoint(yPoint.x + yPoint2.x, yPoint.y + yPoint2.y);
    }

    public static YPoint midPoint(YPoint yPoint, YPoint yPoint2) {
        return new YPoint((yPoint.x + yPoint2.x) / 2.0, (yPoint.y + yPoint2.y) / 2.0);
    }

    public static YPoint swap(YPoint yPoint) {
        return new YPoint(yPoint.y, yPoint.x);
    }

    public YPoint moveBy(double d2, double d3) {
        return new YPoint(this.x + d2, this.y + d3);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof YPoint)) {
            return false;
        }
        YPoint yPoint = (YPoint)object;
        return yPoint.x == this.x && yPoint.y == this.y;
    }

    public int hashCode() {
        long l = Double.doubleToRawLongBits(this.x) << 1 ^ Double.doubleToRawLongBits(this.y);
        return (int)(l >> 32 ^ l);
    }

    public String toString() {
        return "X: " + a.format(this.x) + " Y: " + a.format(this.y);
    }

    public int compareTo(Object object) {
        if (this == object) {
            return 0;
        }
        YPoint yPoint = (YPoint)object;
        if (this.x < yPoint.x) {
            return -1;
        }
        if (this.x > yPoint.x) {
            return 1;
        }
        if (this.y < yPoint.y) {
            return -1;
        }
        if (this.y > yPoint.y) {
            return 1;
        }
        return 0;
    }
}

