/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.icon.paint;

import com.nepxion.swing.icon.paint.ArrowIcon;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.SwingConstants;

public class ArrowDoubleIcon
implements Icon,
SwingConstants {
    private ArrowIcon arrowIcon1;
    private ArrowIcon arrowIcon2;
    private int size;
    private int direction;

    public ArrowDoubleIcon(int size, int direction) {
        this.size = size;
        this.arrowIcon1 = new ArrowIcon(size / 2, direction);
        this.arrowIcon2 = new ArrowIcon(size / 2, direction);
    }

    @Override
    public int getIconWidth() {
        if (this.direction == 1 || this.direction == 5) {
            return this.size / 2;
        }
        return this.size;
    }

    @Override
    public int getIconHeight() {
        if (this.direction == 1 || this.direction == 5) {
            return this.size;
        }
        return this.size / 2;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.arrowIcon1 != null) {
            this.arrowIcon1.paintIcon(c, g, x, y);
        }
        if (this.arrowIcon2 != null) {
            if (this.direction == 1 || this.direction == 5) {
                this.arrowIcon2.paintIcon(c, g, x, y + this.size / 2);
            } else {
                this.arrowIcon2.paintIcon(c, g, x + this.size / 2, y);
            }
        }
    }
}

