/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.searcher.ip.sina;

import com.nepxion.swing.action.JSecurityAction;
import com.nepxion.swing.handle.HandleManager;
import com.nepxion.swing.icon.IconFactory;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.optionpane.JBasicOptionPane;
import com.nepxion.swing.searcher.ip.sina.JSinaIPPanel;
import com.nepxion.swing.searcher.ip.sina.JSinaIPTable;
import com.nepxion.swing.searcher.ip.sina.SinaIPTableModel;
import com.nepxion.swing.thread.dialog.JThreadDialog;
import com.nepxion.util.searcher.ip.sina.SinaIPEntity;
import com.nepxion.util.searcher.ip.sina.SinaIPSearcher;
import java.awt.event.ActionEvent;

public class SinaIPController {
    public static JSecurityAction getSearchAction(final JSinaIPPanel panel) {
        JSecurityAction action = new JSecurityAction(SwingLocale.getString("query"), IconFactory.getSwingIcon("stereo_search.png"), SwingLocale.getString("ip_to_address")){

            @Override
            public void execute(ActionEvent e) {
                JThreadDialog dialog = new JThreadDialog(HandleManager.getFrame(panel), SwingLocale.getString("ip_to_address"), SwingLocale.getString("query_and_wait")){

                    @Override
                    protected void loadForeground(Object data) throws Exception {
                        SinaIPEntity entity = (SinaIPEntity)data;
                        if (entity == null) {
                            JBasicOptionPane.showMessageDialog(HandleManager.getFrame(panel), SwingLocale.getString("no_records"), SwingLocale.getString("warning"), 2);
                            return;
                        }
                        SinaIPTableModel tableModel = (SinaIPTableModel)panel.getIPTable().getModel();
                        tableModel.addRow(entity);
                    }

                    @Override
                    protected Object loadBackground() throws Exception {
                        String ip = panel.getIP();
                        SinaIPSearcher searcher = new SinaIPSearcher();
                        SinaIPEntity entity = null;
                        entity = ip.equals("") ? searcher.search() : searcher.search(ip);
                        return entity;
                    }
                };
                dialog.execute();
            }
        };
        return action;
    }

    public static JSecurityAction getClearAction(final JSinaIPTable table) {
        JSecurityAction action = new JSecurityAction(SwingLocale.getString("clear"), IconFactory.getSwingIcon("stereo/delete_16.png"), SwingLocale.getString("clear_query_result")){

            @Override
            public void execute(ActionEvent e) {
                int selectedValue = JBasicOptionPane.showConfirmDialog(HandleManager.getFrame(table), SwingLocale.getString("confirm_to_clear_query_result"), SwingLocale.getString("confirm"), 0);
                if (selectedValue != 0) {
                    return;
                }
                SinaIPTableModel tableModel = (SinaIPTableModel)table.getModel();
                tableModel.clearRows();
            }
        };
        return action;
    }
}

