/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;

public class RaisedHeaderBorder
extends AbstractBorder {
    private Insets insets = new Insets(1, 1, 1, 0);
    private Color highlightColor;
    private Color shadowColor;

    public RaisedHeaderBorder() {
        this(null);
    }

    public RaisedHeaderBorder(Color highlightColor) {
        this(highlightColor, null);
    }

    public RaisedHeaderBorder(Color highlightColor, Color shadowColor) {
        this.highlightColor = highlightColor;
        this.shadowColor = shadowColor;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.insets;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        if (this.highlightColor == null) {
            this.highlightColor = UIManager.getColor("controlLtHighlight");
        }
        if (this.shadowColor == null) {
            this.shadowColor = UIManager.getColor("controlShadow");
        }
        g.translate(x, y);
        g.setColor(this.highlightColor);
        g.fillRect(0, 0, w, 1);
        g.fillRect(0, 1, 1, h - 1);
        g.setColor(this.shadowColor);
        g.fillRect(0, h - 1, w, 1);
        g.translate(-x, -y);
    }
}

