/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.util.net.http;

import com.nepxion.util.net.http.HttpConfig;
import com.nepxion.util.net.http.HttpConstants;
import com.nepxion.util.net.http.HttpLogger;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpContext
implements HttpConstants {
    private static Log log = LogFactory.getLog(HttpContext.class);
    private static LinkedHashMap httpConfigMap;

    public static void register() throws Exception {
        HttpContext.register("conf/http.properties");
    }

    public static void register(String filePath) throws Exception {
        log.info((Object)"----- Http Context Initialization Start -----");
        httpConfigMap = new LinkedHashMap();
        Properties properties = new Properties();
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(filePath);
            properties.load(inputStream);
            HttpContext.parseConfig(properties);
        }
        catch (Exception e) {
            log.fatal((Object)e);
            throw e;
        }
        finally {
            if (inputStream != null) {
                ((InputStream)inputStream).close();
            }
        }
        log.info((Object)"------ Http Context Initialization End ------");
    }

    public static void register(Properties properties) throws Exception {
        log.info((Object)"----- Http Context Initialization Start -----");
        try {
            HttpContext.parseConfig(properties);
        }
        catch (Exception e) {
            log.fatal((Object)e);
            throw e;
        }
        log.info((Object)"------ Http Context Initialization End ------");
    }

    public static void register(URL codeBase) throws Exception {
        log.info((Object)"----- Http Context Initialization Start -----");
        httpConfigMap = new LinkedHashMap();
        Properties properties = new Properties();
        try {
            URL url = new URL(codeBase + "conf/http.properties");
            properties.load(url.openStream());
            HttpContext.parseConfig(properties, url);
        }
        catch (Exception e) {
            log.fatal((Object)e);
            throw e;
        }
        log.info((Object)"------ Http Context Initialization End ------");
    }

    public static HttpConfig getDefaultConfig() {
        return HttpContext.getConfig("DefaultHttp");
    }

    public static HttpConfig getConfig(String alias) {
        HttpConfig httpConfig = (HttpConfig)httpConfigMap.get(alias);
        if (httpConfig == null) {
            throw new IllegalArgumentException("Http Config for " + alias + " hasn't been found");
        }
        return httpConfig;
    }

    private static void parseConfig(Properties properties) throws Exception {
        HttpContext.parseConfig(properties, null);
    }

    private static void parseConfig(Properties properties, URL url) throws Exception {
        HashMap<String, Properties> propertiesMap = new HashMap<String, Properties>();
        for (String string : properties.keySet()) {
            String value = properties.getProperty(string);
            if (!string.startsWith("http")) continue;
            int index = string.indexOf(".");
            if (index == -1) {
                throw new Exception("Property " + string + " must be of the format " + "http" + "*" + "." + "*");
            }
            String prefix = string.substring(0, index);
            String name = string.substring(index + 1);
            Properties configProperties = (Properties)propertiesMap.get(prefix);
            if (configProperties == null) {
                configProperties = new Properties();
                propertiesMap.put(prefix, configProperties);
            }
            configProperties.put(name, value);
        }
        for (String string : propertiesMap.keySet()) {
            Properties configProperties = (Properties)propertiesMap.get(string);
            HttpConfig config = HttpContext.createConfig(configProperties, url);
            httpConfigMap.put(config.getAlias(), config);
        }
        HttpLogger.info(httpConfigMap);
    }

    private static HttpConfig createConfig(Properties properties, URL url) {
        HttpConfig httpConfig = new HttpConfig();
        httpConfig.setAlias(properties.getProperty("alias"));
        if (!properties.getProperty("host").equals("")) {
            httpConfig.setHost(properties.getProperty("host"));
        } else if (url != null) {
            httpConfig.setHost(url.getHost());
        }
        if (!properties.getProperty("port").equals("")) {
            httpConfig.setPort(Integer.parseInt(properties.getProperty("port")));
        } else if (url != null) {
            httpConfig.setPort(url.getPort());
        }
        httpConfig.setPath(properties.getProperty("path"));
        httpConfig.setConnectionTimeOut(Integer.parseInt(properties.getProperty("connection-timeout")));
        httpConfig.setResponseTimeOut(Integer.parseInt(properties.getProperty("response-timeout")));
        httpConfig.setBufferSize(Integer.parseInt(properties.getProperty("buffer-size")));
        return httpConfig;
    }
}

