/*
 * Decompiled with CFR 0.152.
 */
package twaver.gis.gadget;

import twaver.GeoCoordinate;

public class GridBbox {
    private double B;
    private double A;
    private double D;
    private double C;

    public GridBbox() {
    }

    public GridBbox(double minx, double miny, double maxx, double maxy) {
        this.B = minx;
        this.A = miny;
        this.D = maxx;
        this.C = maxy;
    }

    public GridBbox(double[] bounds) {
        this.B = bounds[0];
        this.A = bounds[1];
        this.D = bounds[2];
        this.C = bounds[3];
    }

    public double getMaxx() {
        return this.D;
    }

    public double getMaxy() {
        return this.C;
    }

    public double getMinx() {
        return this.B;
    }

    public double getMiny() {
        return this.A;
    }

    public double getWidth() {
        return this.D - this.B;
    }

    public double getHeight() {
        return this.C - this.A;
    }

    public String toString() {
        return " bbox is " + this.B + "," + this.A + "," + this.D + "," + this.C;
    }

    public boolean contain(GeoCoordinate coordinate) {
        double longitude = coordinate.getLongitude();
        double latitude = coordinate.getLatitude();
        return longitude >= this.B && longitude <= this.D && latitude >= this.A && latitude <= this.C;
    }

    public boolean contain(GridBbox bbox) {
        if (bbox == null) {
            return false;
        }
        return this.D > bbox.getMaxx() && this.B < bbox.getMinx() && this.A < bbox.getMiny() && this.C > bbox.getMaxy();
    }

    public void setMaxx(double maxx) {
        this.D = maxx;
    }

    public void setMaxy(double maxy) {
        this.C = maxy;
    }

    public void setMinx(double minx) {
        this.B = minx;
    }

    public void setMiny(double miny) {
        this.A = miny;
    }

    public boolean equals(Object target) {
        GridBbox tb;
        return target instanceof GridBbox && this.B == (tb = (GridBbox)target).getMinx() && this.A == tb.getMiny() && this.D == tb.getMaxx() && this.C == tb.getMaxy();
    }
}

