/*
 * Decompiled with CFR 0.152.
 */
package twaver.web.svg.network.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import twaver.Link;
import twaver.LinkStyleFactory;
import twaver.Node;
import twaver.ShapeNode;
import twaver.TUIManager;
import twaver.TWaverConst;
import twaver.TWaverUtil;
import twaver.base.A.D.B;
import twaver.base.A.E.D;
import twaver.base.A.E.K;
import twaver.base.A.E.L;
import twaver.base.A.E.S;
import twaver.base.A.E.T;
import twaver.base.A.E.Y;
import twaver.base.A.E.b;
import twaver.base.A.E.d;
import twaver.base.A.H.G;
import twaver.base.A.H.I;
import twaver.base.OrthogonalLinkDirectionType;
import twaver.web.svg.network.SVGContext;
import twaver.web.svg.network.SVGStruct;
import twaver.web.svg.network.TSVGNetwork;
import twaver.web.svg.network.ui.AbstractElementSVGUI;

public class LinkSVGUI
extends AbstractElementSVGUI {
    private static final String B = "/resource/image/twaver/groupClose.png";
    private static final Image C = TWaverUtil.getImage("/resource/image/twaver/groupClose.png");
    private static final int D = C.getHeight(null);
    private static final int A = C.getWidth(null);
    private static final String E = "Link";
    protected Link link = null;
    protected Point fromPoint;
    protected Point toPoint;
    protected Rectangle fromBounds;
    protected Rectangle toBounds;

    public LinkSVGUI(TSVGNetwork network, Link link) {
        super(network, link);
        this.link = link;
    }

    public SVGStruct toSVG(SVGContext context) {
        Node to;
        Node from = this.link.getFromAgent();
        if (from != null) {
            this.network.getElementSVGUI(from).toSVG(context);
        }
        if ((to = this.link.getToAgent()) != null) {
            this.network.getElementSVGUI(to).toSVG(context);
        }
        this.fromBounds = null;
        this.toBounds = null;
        return super.toSVG(context);
    }

    protected void prepareElementSVGHeader(SVGContext context, StringBuffer head) {
        super.prepareElementSVGHeader(context, head);
        this.appendClassName(head);
        if (this.link.getLinkBundleSize() <= 1 || this.link.isLinkBundleExpand()) {
            head.append(" link-expand='t'");
        }
    }

    protected void appendClassName(StringBuffer head) {
        I.B(head, E);
    }

    public Point getHotspot(SVGContext context) {
        return L.A(context.getLinkPath(this.link));
    }

    protected SVGStruct toBodySVG(SVGContext context) {
        StringBuffer sb = new StringBuffer();
        GeneralPath path = this.createLinkPath(context);
        if (path == null) {
            return SVGStruct.EMPTY;
        }
        context.registerLinkPath(this.link, path);
        String id = I.A(context, (Shape)path);
        Color bodyColor = this.getPaintBodyColor(this.link.getLinkColor());
        this.toLinkPathSVG(context, sb, id, bodyColor);
        this.toLinkFlowingSVG(context, sb, id);
        this.toArrowSVG(context, sb, path);
        return new SVGStruct(sb.toString(), path.getBounds());
    }

    protected void toLinkFlowingSVG(SVGContext context, StringBuffer sb, String id) {
        String to;
        String from;
        if (!this.link.isLinkFlowing()) {
            return;
        }
        int width = this.link.getLinkWidth();
        if (width == 0) {
            width = 1;
        }
        Color color = this.link.getLinkFlowingColor();
        BasicStroke stroke = new BasicStroke(this.link.getLinkFlowingWidth(), 0, 1, width, new float[]{width * 2}, 0.0f);
        I.A(sb, id);
        I.A(context, sb, null, (Object)color, stroke, this.getRenderAlpha()).append(">");
        if (this.link.isLinkFlowingConverse()) {
            from = "0";
            to = String.valueOf(width * 20);
        } else {
            from = String.valueOf(width * 20);
            to = "0";
        }
        int speed = b.J(this.link, "link.flowing.speed");
        I.A(sb, "stroke-dashoffset", null, "indefinite", speed, from, to, null);
        sb.append("</use>\n");
    }

    protected void toLinkPathSVG(SVGContext context, StringBuffer sb, String id, Color bodyColor) {
        Stroke stroke;
        boolean is3D;
        int linkWidth = this.link.getLinkWidth();
        LinkStyleFactory styleFactory = K.A(this.link.getLinkStyle());
        Stroke bodyStroke = styleFactory.createStroke(linkWidth);
        if (!(bodyStroke instanceof BasicStroke)) {
            bodyStroke = TWaverConst.DOUBLE_WIDTH_STROKE;
        }
        int outline = (is3D = this.link.isLink3D()) ? 2 : this.link.getLinkOutlineWidth();
        int outlineWidth = linkWidth + outline;
        Color outlineColor = this.link.getLinkOutlineColor();
        int stateWidth = outlineWidth;
        Color stateColor = this.getStateOutlineColor();
        if (stateColor != null) {
            stateWidth += 2;
        }
        float alpha = this.getRenderAlpha();
        if (this.network.isSelectable(this.link)) {
            I.A(sb, id);
            I.B(sb);
            I.C(sb);
            stroke = d.A(stateWidth + 2, bodyStroke);
            I.A(context, sb, null, (Object)this.network.getElementSelectColor(this.link), stroke, alpha).append("/>\n");
        }
        if (stateColor != null) {
            I.A(sb, id);
            stroke = d.A(stateWidth, bodyStroke);
            I.A(context, sb, null, (Object)stateColor, stroke, 0.0f).append("/>\n");
        }
        if (outline > 0) {
            I.A(sb, id);
            stroke = d.A(outlineWidth, bodyStroke);
            I.A(context, sb, null, (Object)outlineColor, stroke, alpha).append("/>\n");
        }
        if (is3D) {
            I.A(sb, id);
            Color color = bodyColor.brighter().brighter();
            I.A(context, sb, null, (Object)color, bodyStroke, alpha);
            I.A(sb, -1, -1).append("/>\n");
            I.A(sb, id);
            color = bodyColor.darker().darker();
            I.A(context, sb, null, (Object)color, bodyStroke, alpha);
            I.A(sb, 1, 1).append("/>\n");
        }
        I.A(sb, id);
        I.A(context, sb, null, (Object)bodyColor, bodyStroke, alpha).append("/>\n");
    }

    protected void toArrowSVG(SVGContext context, StringBuffer sb, GeneralPath path) {
        Color outlineObject;
        Color fillObject;
        Shape shape;
        boolean fromArrow = this.link.isLinkFromArrow();
        boolean toArrow = this.link.isLinkToArrow();
        if (fromArrow) {
            Node fromAgent = this.link.getFromAgent();
            this.fromBounds = this.getFromBounds(context, fromAgent);
            shape = S.B(this.link, path, this.fromBounds);
            fillObject = this.link.getLinkFromArrowColor();
            outlineObject = null;
            if (this.link.isLinkFromArrowOutline()) {
                outlineObject = this.link.getLinkFromArrowOutlineColor();
            }
            I.A(context, sb, shape, (Object)fillObject, (Object)outlineObject, (Object)"1", 1.0f, 0.0, null);
        }
        if (toArrow) {
            Node toAgent = this.link.getToAgent();
            this.toBounds = this.getToBounds(context, toAgent);
            shape = S.A(this.link, path, this.toBounds);
            fillObject = this.link.getLinkToArrowColor();
            outlineObject = null;
            if (this.link.isLinkToArrowOutline()) {
                outlineObject = this.link.getLinkToArrowOutlineColor();
            }
            I.A(context, sb, shape, (Object)fillObject, (Object)outlineObject, (Object)"1", 1.0f, 0.0, null);
        }
    }

    public Rectangle getFromBounds(SVGContext context, Node fromAgent) {
        if (this.fromBounds == null) {
            this.fromBounds = context.getBounds(fromAgent);
        }
        return this.fromBounds;
    }

    public Rectangle getToBounds(SVGContext context, Node toAgent) {
        if (this.toBounds == null) {
            this.toBounds = context.getBounds(toAgent);
        }
        return this.toBounds;
    }

    protected GeneralPath createLinkPath(SVGContext context) {
        Shape shape;
        Point result;
        int shapeType;
        ShapeNode node;
        int type = this.link.getLinkType();
        int bundleIndex = this.link.getLinkBundleIndex();
        int bundleSize = this.link.getLinkBundleSize();
        boolean bundleAgent = this.link.isBundleAgent();
        double proportion = this.link.getLinkProportion();
        int extend = this.link.getLinkExtend();
        int fromPosition = this.link.getLinkFromPosition();
        int fromXOffset = this.link.getLinkFromXOffset();
        int fromYOffset = this.link.getLinkFromYOffset();
        int toPosition = this.link.getLinkToPosition();
        int toXOffset = this.link.getLinkToXOffset();
        int toYOffset = this.link.getLinkToYOffset();
        Node fromAgent = this.link.getFromAgent();
        Node toAgent = this.link.getToAgent();
        this.fromBounds = this.getFromBounds(context, fromAgent);
        this.toBounds = this.getToBounds(context, toAgent);
        if (this.link.isLoop()) {
            return T.A(bundleIndex, this.network.getParallelLinkGap(), this.fromBounds);
        }
        B struct = null;
        if (type == 2 || type == 4) {
            struct = new B(this.link, context, this.network, this.fromBounds, this.toBounds);
        }
        Point fromPoint = null;
        fromPoint = this.link.getLinkType() == 2 ? struct.F : I.A(this.network, context, fromAgent, TWaverConst.EMPTY_DIMENSION, fromPosition, fromXOffset, fromYOffset);
        Point toPoint = null;
        toPoint = this.link.getLinkType() == 2 ? struct.E : I.A(this.network, context, toAgent, TWaverConst.EMPTY_DIMENSION, toPosition, toXOffset, toYOffset);
        if (toAgent instanceof ShapeNode) {
            node = (ShapeNode)toAgent;
            shapeType = node.getShapeNodeType();
            result = null;
            if (shapeType == 7) {
                result = Y.A(node, fromPoint, node.getShapeNodeJointPoint());
            } else if ((shapeType == 9 || shapeType == 8) && (shape = node.getShape()) instanceof Ellipse2D) {
                result = twaver.base.A.E.D.A((Ellipse2D)shape, fromPoint);
            }
            if (result != null) {
                result.x += toXOffset;
                result.y += toYOffset;
                toPoint = result;
            }
        }
        if (fromAgent instanceof ShapeNode) {
            node = (ShapeNode)fromAgent;
            shapeType = node.getShapeNodeType();
            result = null;
            if (shapeType == 7) {
                result = Y.A(node, toPoint, node.getShapeNodeJointPoint());
            } else if ((shapeType == 9 || shapeType == 8) && (shape = node.getShape()) instanceof Ellipse2D) {
                result = twaver.base.A.E.D.A((Ellipse2D)shape, toPoint);
            }
            if (result != null) {
                result.x += fromXOffset;
                result.y += fromYOffset;
                fromPoint = result;
            }
        }
        context.registerFromPoint(this.link, fromPoint);
        context.registerToPoint(this.link, toPoint);
        Point orthogonalPoint = null;
        if (type == 3) {
            orthogonalPoint = OrthogonalLinkDirectionType.X_TO_Y.equals(this.link.getLinkOrthogonalDirection()) ? new Point(fromPoint.x, toPoint.y) : new Point(toPoint.x, fromPoint.y);
        }
        this.fromPoint = fromPoint;
        this.toPoint = toPoint;
        return T.A(type, bundleIndex, bundleSize, bundleAgent, proportion, extend, fromPoint, toPoint, this.fromBounds, this.toBounds, struct, orthogonalPoint, this.network, this.link);
    }

    protected SVGStruct toAttachmentSVG(SVGContext context) {
        SVGStruct struct = super.toAttachmentSVG(context);
        int count = this.link.getLinkBundleSize();
        if (this.network.isShowLinkBundleHandler() && count > 1 && this.link.isBundleAgent()) {
            StringBuffer sb = new StringBuffer(struct.getSvg() == null ? "" : struct.getSvg());
            Point location = this.getHotspot(context);
            I.A(context, sb, " type = 'handler' ", B, null, location.x, location.y, 1.0f);
            String text = "(" + count + ")";
            location.x += A;
            location.y += D;
            sb.append(I.A(context, text, Color.BLACK, TUIManager.getDefaultFont(), location, false, null));
            struct.setSvg(sb.toString());
        }
        return struct;
    }

    public double getAngle(SVGContext context) {
        if (this.link.getLinkType() == 2) {
            Point fromPoint = this.getFromInflexion(context);
            Point toPoint = this.getToInflexion(context);
            return twaver.base.A.E.D.B(fromPoint, toPoint);
        }
        if (this.link.getLinkType() == 3) {
            double multiple = twaver.base.A.E.D.B(this.fromPoint, this.toPoint) / 1.5707963267948966;
            return (double)Math.round(multiple) * 1.5707963267948966;
        }
        return twaver.base.A.E.D.B(this.fromPoint, this.toPoint);
    }

    public Point getFromInflexion(SVGContext context) {
        return (Point)this.getFlexionStruct((SVGContext)context).B.clone();
    }

    public Point getToInflexion(SVGContext context) {
        return (Point)this.getFlexionStruct((SVGContext)context).D.clone();
    }

    public G getFlexionStruct(SVGContext context) {
        return new G(context, this);
    }
}

