/*
 * Decompiled with CFR 0.152.
 */
package twaver.table.renderer;

import java.awt.Insets;
import java.text.NumberFormat;
import javax.swing.table.DefaultTableCellRenderer;
import twaver.FloatInsets;
import twaver.TUIManager;
import twaver.TWaverUtil;

public class InsetsRenderer
extends DefaultTableCellRenderer {
    public static final NumberFormat FORMATER = NumberFormat.getInstance();

    public InsetsRenderer() {
        this(TUIManager.getString("table.alignment.number"));
    }

    public InsetsRenderer(String alignment) {
        TWaverUtil.setHorizontalAlignment(this, alignment);
    }

    public void setValue(Object value) {
        Cloneable insets;
        String text = null;
        if (value instanceof Insets) {
            insets = (Insets)value;
            text = "top=" + insets.top + ",left=" + insets.left + ",bottom=" + insets.bottom + ",right=" + insets.right;
        }
        if (value instanceof FloatInsets) {
            insets = (FloatInsets)value;
            text = "top=" + FORMATER.format(((FloatInsets)insets).top) + ",left=" + FORMATER.format(((FloatInsets)insets).left) + ",bottom=" + FORMATER.format(((FloatInsets)insets).bottom) + ",right=" + FORMATER.format(((FloatInsets)insets).right);
        }
        this.setText(text);
        this.setToolTipText(text);
    }

    static {
        FORMATER.setMaximumFractionDigits(2);
        FORMATER.setMinimumFractionDigits(1);
    }
}

