/*
 * Decompiled with CFR 0.152.
 */
package twaver.table;

import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.BeanInfo;
import java.beans.PropertyChangeEvent;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import twaver.AlarmSeverity;
import twaver.AlarmSeverityChangeListener;
import twaver.DataBoxSelectionAdapter;
import twaver.DataBoxSelectionEvent;
import twaver.DataBoxSelectionListener;
import twaver.Element;
import twaver.ElementAttribute;
import twaver.ElementAttributeVisibleFilter;
import twaver.TDataBox;
import twaver.TPropertyDescriptor;
import twaver.TUIManager;
import twaver.TWaverConst;
import twaver.TWaverUtil;
import twaver.base.A.F.B.F;
import twaver.base.A.I.D;
import twaver.base.A.J.A;
import twaver.base.A.J.A.H;
import twaver.base.A.J.I;
import twaver.table.Category;
import twaver.table.CellEditorManager;
import twaver.table.CellRendererManager;
import twaver.table.PropertySheetEvent;
import twaver.table.PropertySheetListener;
import twaver.table.PropertyValueSettingListener;
import twaver.table.ResizableTable;
import twaver.table.renderer.PropertyNameRenderer;
import twaver.table.renderer.StringRenderer;

public class TPropertySheet
extends ResizableTable
implements D {
    private int \u027a = TUIManager.getInt("sheet.mode");
    private boolean \u0271 = TUIManager.getBoolean("sheet.enable.category.interaction");
    private boolean \u0267 = TUIManager.getBoolean("sheet.sorting.ascending");
    private boolean \u0276 = TUIManager.getBoolean("sheet.editable");
    private boolean \u0285 = TUIManager.getBoolean("sheet.restore.category.state");
    private boolean \u026b = TUIManager.getBoolean("sheet.property.extra.indent");
    private boolean \u0286 = TUIManager.getBoolean("sheet.single.root.category.visible");
    private boolean \u0275 = TUIManager.getBoolean("sheet.category.font.bold");
    private boolean \u0282 = TUIManager.getBoolean("sheet.indent.opaque");
    private int \u0281 = TUIManager.getInt("sheet.property.distinct.level");
    private boolean \u026f = TUIManager.getBoolean("sheet.sorting.categories");
    private boolean \u0284 = TUIManager.getBoolean("sheet.sorting.properties");
    private Comparator \u027f = TUIManager.getComparator("sheet.category.sorting.comparator");
    private Comparator \u027c = TUIManager.getComparator("sheet.property.sorting.comparator");
    private boolean \u0269 = TUIManager.getBoolean("sheet.fill.indent");
    private boolean \u026e = false;
    private A \u026c = null;
    private TableCellRenderer \u0270 = new PropertyNameRenderer();
    private TableCellRenderer \u0279 = new DefaultTableCellRenderer();
    private CellRendererManager \u0280 = new CellRendererManager();
    private CellEditorManager \u027d = new CellEditorManager();
    private ElementAttributeVisibleFilter \u0268 = null;
    private List \u0283 = new LinkedList();
    private List \u0277 = new LinkedList();
    private Map \u026a = new HashMap();
    private Icon \u0273 = null;
    private Icon \u027e = null;
    private AlarmSeverityChangeListener \u027b = new AlarmSeverityChangeListener(){

        public boolean alarmSeverityChange() {
            TPropertySheet.this.repaint();
            return false;
        }
    };
    private TDataBox \u0274 = null;
    private List \u0272 = null;
    private List \u0278 = null;
    private DataBoxSelectionListener \u026d = new DataBoxSelectionAdapter(){

        public void selectionChanged(DataBoxSelectionEvent e2) {
            TPropertySheet.this.\u0274 = e2.getBoxSelectionModel().getDataBox();
            TPropertySheet.this.\u026c.D();
        }
    };

    public Iterator getSelection() {
        if (this.\u0278 != null) {
            return this.\u0278.iterator();
        }
        if (this.\u0274 != null) {
            return this.\u0274.selection();
        }
        return null;
    }

    public Element getLastSelectedElement() {
        if (this.\u0278 != null) {
            if (this.\u0278.size() > 0) {
                return (Element)this.\u0278.get(this.\u0278.size() - 1);
            }
            return null;
        }
        if (this.\u0274 != null) {
            return this.\u0274.getLastSelectedElement();
        }
        return null;
    }

    public void addPropertySheetListener(PropertySheetListener l2) {
        if (l2 != null && !this.\u0277.contains(l2)) {
            this.\u0277.add(l2);
        }
    }

    public void removePropertySheetListener(PropertySheetListener l2) {
        this.\u0277.remove(l2);
    }

    public void firePropertySheetChanged(PropertyChangeEvent e2, int rowIndex) {
        if (this.\u0277.size() > 0) {
            this.firePropertySheetChanged(new PropertySheetEvent(this, 1, e2, rowIndex));
        }
    }

    public void firePropertySheetChanged(Category category) {
        if (this.\u0277.size() > 0) {
            int type = category.isExpand() ? 3 : 4;
            this.firePropertySheetChanged(new PropertySheetEvent(this, type, category));
        }
    }

    public void firePropertySheetChanged(PropertySheetEvent event) {
        if (this.\u0277.size() > 0) {
            Iterator it = this.\u0277.iterator();
            while (it.hasNext()) {
                PropertySheetListener l2 = (PropertySheetListener)it.next();
                l2.propertySheetChanged(event);
            }
        }
    }

    public TPropertySheet() {
        this(new TDataBox());
    }

    public TPropertySheet(TDataBox box) {
        this.init(new A(this));
        this.setDataBox(box);
    }

    public TDataBox getDataBox() {
        return this.\u0274;
    }

    public List getDataBoxs() {
        return this.\u0272;
    }

    public List getElements() {
        return this.\u0278;
    }

    public void setDataBox(TDataBox box) {
        if (box == null) {
            this.setDataBoxs(null);
        } else {
            ArrayList<TDataBox> list = new ArrayList<TDataBox>(1);
            list.add(box);
            this.setDataBoxs(list);
        }
    }

    public void setDataBoxs(List boxs) {
        TDataBox box;
        int i2;
        int count;
        if (this.\u0272 != null) {
            count = this.\u0272.size();
            for (i2 = 0; i2 < count; ++i2) {
                box = (TDataBox)this.\u0272.get(i2);
                box.getSelectionModel().removeDataBoxSelectionListener(this.\u026d);
            }
        }
        this.\u0272 = boxs;
        this.\u0278 = null;
        this.\u0274 = null;
        if (this.\u0272 != null) {
            count = this.\u0272.size();
            for (i2 = 0; i2 < count; ++i2) {
                box = (TDataBox)this.\u0272.get(i2);
                if (box.getSelectionModel().size() > 0) {
                    this.\u0274 = box;
                }
                box.getSelectionModel().addDataBoxSelectionListener(this.\u026d);
            }
        }
        if (this.\u0274 == null && this.\u0272 != null && this.\u0272.size() > 0) {
            this.\u0274 = (TDataBox)this.\u0272.get(0);
        }
        this.\u026c.D();
    }

    public void setElement(Element element) {
        if (element == null) {
            this.setElements(null);
        } else {
            ArrayList<Element> list = new ArrayList<Element>(1);
            list.add(element);
            this.setElements(list);
        }
    }

    public void setElements(List elements) {
        this.\u0278 = elements;
        this.\u026c.D();
    }

    public boolean isEditable() {
        return this.\u0276;
    }

    public void setEditable(boolean isEditable) {
        this.\u0276 = isEditable;
        this.repaint();
    }

    public Color getGridColor() {
        return TUIManager.getPanelBackground();
    }

    protected void initInputHandler() {
        super.initInputHandler();
        new H(this);
    }

    protected void init(A model) {
        this.\u026c = model;
        this.setModel(model);
        JTableHeader header = this.getTableHeader();
        if (header != null) {
            header.setReorderingAllowed(false);
            header.setDefaultRenderer(new I(this));
            header.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e2) {
                    int index;
                    if (SwingUtilities.isLeftMouseButton(e2) && (index = TPropertySheet.this.getColumnModel().getColumnIndexAtX(e2.getX())) == 0) {
                        if (TPropertySheet.this.isSortingProperties()) {
                            TPropertySheet.this.setSortingAscending(!TPropertySheet.this.isSortingAscending());
                            if (TPropertySheet.this.isSortingAscending()) {
                                TPropertySheet.this.setSortingProperties(false);
                            }
                        } else {
                            TPropertySheet.this.setSortingProperties(true);
                        }
                    }
                }
            });
        }
        this.setDefaultRenderer(Object.class, new StringRenderer());
        this.getSelectionModel().setSelectionMode(0);
        AlarmSeverity.addAlarmSeverityChangeListener(this.\u027b);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e2) {
                int rowIndex;
                if (TPropertySheet.this.\u0277.size() > 0 && SwingUtilities.isLeftMouseButton(e2) && (rowIndex = TPropertySheet.this.rowAtPoint(e2.getPoint())) >= 0) {
                    PropertySheetEvent event = null;
                    event = e2.getClickCount() == 1 ? new PropertySheetEvent(TPropertySheet.this, 5, rowIndex) : new PropertySheetEvent(TPropertySheet.this, 6, rowIndex);
                    if (event != null) {
                        TPropertySheet.this.firePropertySheetChanged(event);
                    }
                }
            }
        });
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        ElementAttribute attribute;
        TableCellRenderer renderer;
        Object value = this.getValueAt(row, column);
        if (!(value instanceof Category)) {
            if (column == 0) {
                return this.\u0270;
            }
            if (column == 2) {
                return this.\u0279;
            }
        }
        if ((renderer = this.\u0280.findRenderer(attribute = this.\u026c.B(row), value)) == null) {
            renderer = super.getCellRenderer(row, column);
        }
        return renderer;
    }

    public TableCellEditor getCellEditor(int row, int column) {
        Object value = this.getValueAt(row, column);
        ElementAttribute attribute = this.\u026c.B(row);
        TableCellEditor editor = this.\u027d.findEditor(attribute, value);
        if (editor == null) {
            editor = super.getCellEditor(row, column);
        }
        return editor;
    }

    public CellRendererManager getCellRendererManager() {
        return this.\u0280;
    }

    public CellEditorManager getCellEditorManager() {
        return this.\u027d;
    }

    public A getPropertySheetModel() {
        return this.\u026c;
    }

    public void registerElementClassXML(Class elementClass, String url) {
        this.\u026a.put(elementClass, url);
        this.\u026c.D();
    }

    public void registerElementClassXML(Class elementClass, InputStream inputStream) {
        List attributes = TWaverUtil.createElementAttributes(elementClass, inputStream);
        if (attributes != null) {
            this.registerElementClassAttributes(elementClass, attributes);
        }
    }

    public void registerElementClassAttributes(Class elementClass, List attributes) {
        BeanInfo beanInfo = twaver.base.A.E.H.A(elementClass, attributes);
        ArrayList<BeanInfo> list = new ArrayList<BeanInfo>();
        list.add(beanInfo);
        this.\u026a.put(elementClass, list);
        this.\u026c.D();
    }

    public List getAllBeanInfo(Element element) {
        if (element == null) {
            return TWaverConst.EMPTY_LIST;
        }
        Class<?> elementClass = element.getClass();
        Object value = this.\u026a.get(elementClass);
        if (value instanceof String) {
            String url = value.toString();
            BeanInfo beanInfo = F.A().A(elementClass, url, false);
            if (beanInfo == null) {
                throw new NullPointerException("can not find xml '" + url + "'");
            }
            ArrayList<BeanInfo> list = new ArrayList<BeanInfo>();
            list.add(beanInfo);
            this.\u026a.put(elementClass, list);
            return list;
        }
        if (value instanceof List) {
            return (List)value;
        }
        return F.A().E(elementClass);
    }

    public ElementAttributeVisibleFilter getElementAttributeVisibleFilter() {
        return this.\u0268;
    }

    public void setElementAttributeVisibleFilter(ElementAttributeVisibleFilter elementAttributeVisibleFilter) {
        this.\u0268 = elementAttributeVisibleFilter;
        this.\u026c.D();
    }

    void A(ElementAttributeVisibleFilter filter) {
        if (!this.\u0283.contains(filter)) {
            this.\u0283.add(filter);
            this.\u026c.D();
        }
    }

    void B(ElementAttributeVisibleFilter filter) {
        if (this.\u0283.contains(filter)) {
            this.\u0283.remove(filter);
            this.\u026c.D();
        }
    }

    public boolean isVisible(ElementAttribute attribute) {
        if (attribute == null || !attribute.isVisible()) {
            return false;
        }
        int count = 0;
        if (this.\u0278 != null) {
            count = this.\u0278.size();
        } else if (this.\u0274 != null) {
            count = this.\u0274.getSelectionModel().size();
        }
        if (count > 1 && !attribute.isEnableBatch()) {
            return false;
        }
        if (this.\u0268 != null && !this.\u0268.isVisible(attribute)) {
            return false;
        }
        Iterator it = this.\u0283.iterator();
        while (it.hasNext()) {
            ElementAttributeVisibleFilter filter = (ElementAttributeVisibleFilter)it.next();
            if (filter.isVisible(attribute)) continue;
            return false;
        }
        return true;
    }

    public TPropertyDescriptor getPropertyDescriptorByPropertyName(String propertyName) {
        return this.\u026c.B(propertyName);
    }

    public TPropertyDescriptor getPropertyDescriptorByRowIndex(int rowIndex) {
        return this.\u026c.A(rowIndex);
    }

    public Category getCategoryByRowIndex(int rowIndex) {
        return this.\u026c.C(rowIndex);
    }

    public ElementAttribute getElementAttribute(int rowIndex) {
        return this.\u026c.B(rowIndex);
    }

    public List getAllPropertyDescriptors() {
        return this.\u026c.J();
    }

    public List getPropertyDescriptorsByCategoryName(String categoryName) {
        return this.\u026c.C(categoryName);
    }

    public TableCellRenderer getPropertyNameRenderer() {
        return this.\u0270;
    }

    public void setPropertyNameRenderer(TableCellRenderer propertyNameRenderer) {
        if (propertyNameRenderer == null) {
            throw new NullPointerException("Property name renderer can not be none.");
        }
        this.\u0270 = propertyNameRenderer;
        this.repaint();
    }

    public Object getElementPropertyValue(TPropertyDescriptor property) {
        return this.\u026c.A(property);
    }

    public void selectRow(ElementAttribute attribute) {
        int rowIndex;
        if (attribute == null) {
            return;
        }
        Category category = this.\u026c.D(attribute.getCategoryName());
        if (category == null) {
            return;
        }
        if (!category.isExpand()) {
            this.\u026c.A(category.getName(), true);
        }
        if ((rowIndex = this.\u026c.A(attribute)) >= 0) {
            this.getSelectionModel().setSelectionInterval(rowIndex, rowIndex);
        }
    }

    public int getRowIndexByElementAttribute(ElementAttribute attribute) {
        return this.\u026c.A(attribute);
    }

    public int getRowIndexByKey(String key) {
        return this.\u026c.A(key);
    }

    public void updateTViewUI() {
        if (this.\u0280 != null) {
            this.\u0280.clearCache();
        }
        if (this.\u027d != null) {
            this.\u027d.clearCache();
        }
        this.\u026c.D();
    }

    public void updateUI() {
        if (this.\u0280 != null) {
            this.\u0280.clearCache();
        }
        if (this.\u027d != null) {
            this.\u027d.clearCache();
        }
        super.updateUI();
    }

    public Comparator getCategorySortingComparator() {
        return this.\u027f;
    }

    public void setCategorySortingComparator(Comparator categorySortingComparator) {
        Comparator oldValue = this.\u027f;
        this.\u027f = categorySortingComparator;
        this.firePropertyChange("sheet.category.sorting.comparator", oldValue, categorySortingComparator);
    }

    public Comparator getPropertySortingComparator() {
        return this.\u027c;
    }

    public void setPropertySortingComparator(Comparator propertySortingComparator) {
        Comparator oldValue = this.\u027c;
        this.\u027c = propertySortingComparator;
        this.firePropertyChange("sheet.property.sorting.comparator", oldValue, propertySortingComparator);
    }

    public void setMode(int mode) {
        if (this.\u027a == mode) {
            return;
        }
        int oldValue = this.\u027a;
        this.\u027a = mode;
        this.firePropertyChange("sheet.mode", oldValue, this.\u027a);
    }

    public int getMode() {
        return this.\u027a;
    }

    public boolean isSortingCategories() {
        return this.\u026f;
    }

    public void setSortingCategories(boolean sortingCategories) {
        if (this.\u026f == sortingCategories) {
            return;
        }
        boolean oldValue = this.\u026f;
        this.\u026f = sortingCategories;
        this.firePropertyChange("sheet.sorting.categories", oldValue, this.\u026f);
    }

    public boolean isSortingProperties() {
        return this.\u0284;
    }

    public void setSortingProperties(boolean sortingProperties) {
        if (this.\u0284 == sortingProperties) {
            return;
        }
        boolean oldValue = this.\u0284;
        this.\u0284 = sortingProperties;
        this.firePropertyChange("sheet.sorting.properties", oldValue, this.\u0284);
    }

    public void collapseAllCategories() {
        this.\u026c.F();
    }

    public void expandAllCategories() {
        this.\u026c.I();
    }

    public boolean isPropertyExtraIndent() {
        return this.\u026b;
    }

    public void setPropertyExtraIndent(boolean isPropertyExtraIndent) {
        if (this.\u026b == isPropertyExtraIndent) {
            return;
        }
        boolean oldValue = this.\u026b;
        this.\u026b = isPropertyExtraIndent;
        this.firePropertyChange("sheet.property.extra.indent", oldValue, isPropertyExtraIndent);
    }

    public boolean isSingleRootCategoryVisible() {
        return this.\u0286;
    }

    public void setSingleRootCategoryVisible(boolean isSingleRootCategoryVisible) {
        if (this.\u0286 == isSingleRootCategoryVisible) {
            return;
        }
        boolean oldValue = this.\u0286;
        this.\u0286 = isSingleRootCategoryVisible;
        this.firePropertyChange("sheet.single.root.category.visible", oldValue, isSingleRootCategoryVisible);
    }

    public void addPropertyValueSettingListener(PropertyValueSettingListener l2) {
        this.\u026c.B(l2);
    }

    public void removePropertyValueSettingListener(PropertyValueSettingListener l2) {
        this.\u026c.A(l2);
    }

    public void ensureSelectedRowVisible() {
        int rowIndex = this.getSelectionModel().getLeadSelectionIndex();
        if (rowIndex >= 0) {
            this.scrollRectToVisible(this.getCellRect(rowIndex, 0, true));
        }
    }

    public int getPropertyDistinctLevel() {
        return this.\u0281;
    }

    public void setPropertyDistinctLevel(int distinctLevel) {
        if (distinctLevel == 1 || distinctLevel == 0) {
            this.\u0281 = distinctLevel;
        }
    }

    public void resetModel() {
        this.\u026c.D();
    }

    public boolean isCategoryFontBold() {
        return this.\u0275;
    }

    public void setCategoryFontBold(boolean enableCategoryBoldFont) {
        this.\u0275 = enableCategoryBoldFont;
        this.repaint();
    }

    public boolean isIndentOpaque() {
        return this.\u0282;
    }

    public void setIndentOpaque(boolean indentOqaque) {
        this.\u0282 = indentOqaque;
        this.repaint();
    }

    public Icon getCollapsedIcon() {
        return this.\u027e;
    }

    public void setCollapsedIcon(Icon collapsedIcon) {
        this.\u027e = collapsedIcon;
        this.repaint();
    }

    public Icon getExpandedIcon() {
        return this.\u0273;
    }

    public void setExpandedIcon(Icon expandedIcon) {
        this.\u0273 = expandedIcon;
        this.repaint();
    }

    public boolean isSortingAscending() {
        return this.\u0267;
    }

    public void setSortingAscending(boolean sortingAscending) {
        boolean oldValue = this.\u0267;
        this.\u0267 = sortingAscending;
        this.firePropertyChange("sheet.sorting.ascending", oldValue, this.\u0267);
    }

    public boolean isRestoreCategoryState() {
        return this.\u0285;
    }

    public void setRestoreCategoryState(boolean isRestoreCategoryState) {
        this.\u0285 = isRestoreCategoryState;
    }

    public void publish() {
        this.\u026c.B();
    }

    public boolean isEnableCategoryInteraction() {
        return this.\u0271;
    }

    public void setEnableCategoryInteraction(boolean enableCategoryInteraction) {
        boolean oldValue = this.\u0271;
        this.\u0271 = enableCategoryInteraction;
        this.firePropertyChange("sheet.enable.category.interaction", oldValue, this.\u0271);
    }

    public boolean isShowDescriptionColumn() {
        return this.\u026e;
    }

    public void setShowDescriptionColumn(boolean showDescriptionColumn) {
        if (this.\u026e == showDescriptionColumn) {
            return;
        }
        this.\u026e = showDescriptionColumn;
        this.tableChanged(new TableModelEvent(this.\u026c, -1));
    }

    public Object getDescription(Element element, TPropertyDescriptor propertyDescriptor) {
        return propertyDescriptor.getElementAttribute().getDescription();
    }

    public TableCellRenderer getDescriptionRenderer() {
        return this.\u0279;
    }

    public void setDescriptionRenderer(TableCellRenderer descriptionRenderer) {
        this.\u0279 = descriptionRenderer;
        this.repaint();
    }

    public boolean isFillIndent() {
        return this.\u0269;
    }

    public void setFillIndent(boolean fillIndent) {
        this.\u0269 = fillIndent;
        this.repaint();
    }
}

