/*
 * Decompiled with CFR 0.152.
 */
package twaver.list;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import twaver.BatchAdapter;
import twaver.BatchEvent;
import twaver.BatchListener;
import twaver.CheckableFilter;
import twaver.DataBoxEvent;
import twaver.DataBoxListener;
import twaver.DataBoxSelectionEvent;
import twaver.DataBoxSelectionListener;
import twaver.DataBoxSequenceAdapter;
import twaver.DataBoxSequenceListener;
import twaver.Element;
import twaver.Generator;
import twaver.MouseActionEvent;
import twaver.PopupMenuGenerator;
import twaver.TDataBox;
import twaver.TUIManager;
import twaver.TView;
import twaver.TWaverUtil;
import twaver.VisibleFilter;
import twaver.base.A.F.D;
import twaver.list.TListCellRenderer;

public class TList
extends JList
implements TView {
    public static final int DEFAULT_SELECTION = 0;
    public static final int CHECK_SELECTION = 1;
    private TDataBox \u03de;
    private _A \u03d2 = new _A();
    private boolean \u0402 = false;
    private int \u03ea = 0;
    private Map \u03d6 = new HashMap();
    private Map \u03ed = new HashMap();
    private List \u03d3 = new ArrayList();
    private Comparator \u03eb = null;
    private CheckableFilter \u0406 = null;
    private PopupMenuGenerator \u03e8 = null;
    private List \u03f0 = new ArrayList();
    private List \u03f1 = new ArrayList();
    private TListCellRenderer \u03d1 = null;
    private Generator \u0405 = null;
    private Generator \u03da = null;
    private Generator \u03e5 = null;
    private boolean \u03d5 = TUIManager.getBoolean("list.enable.right.click.event");
    private boolean \u03e9 = TUIManager.getBoolean("list.ensure.visible.on.selected");
    private int \u03ec = TUIManager.getInt("list.uncheckable.style");
    private int \u0404 = TUIManager.getInt("list.selection.mode");
    private boolean \u03e2 = TUIManager.getBoolean("list.icon.visible");
    private boolean \u03dc = TUIManager.getBoolean("list.paint.selected.state.when.checked");
    private boolean \u0403 = TUIManager.getBoolean("list.selectable.on.right.click");
    private boolean \u03d4 = TUIManager.getBoolean("list.clear.selection.on.margin.clicked");
    private boolean \u0401 = true;
    private boolean \u03e4 = true;
    private boolean \u03e0 = TUIManager.getBoolean("list.lazy.publish.mode");
    private boolean \u03e7 = false;
    private boolean \u03ee = false;
    protected boolean locked = false;
    private BatchListener \u03f3 = new BatchAdapter(){

        public void batchEnded(BatchEvent e2) {
            TList.this.publishData();
        }
    };
    private DataBoxSequenceListener \u03ef = new DataBoxSequenceAdapter(){

        public void hiberarchyChanged(Element element) {
            TList.this.publishData();
        }
    };
    private DataBoxListener \u03f2 = new DataBoxListener(){

        public void elementAdded(DataBoxEvent e2) {
            TList.this.publishData();
        }

        public void elementRemoved(DataBoxEvent e2) {
            TList.this.publishData();
        }

        public void elementsCleared(DataBoxEvent e2) {
            TList.this.publishData();
        }
    };
    private PropertyChangeListener \u03e6 = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if ("visible".equals(evt.getPropertyName()) && TList.this.\u03d3.size() == 1 && TList.this.\u03d3.get(0) == D.C) {
                TList.this.publishData();
            } else if (TList.this.\u03eb == null && TList.this.\u03d3.size() == 0) {
                Element element = (Element)evt.getSource();
                int index = TList.this.getRowIndexByElement(element);
                TList.this.\u03d2.A(index);
            } else {
                TList.this.publishData();
            }
        }
    };
    private DataBoxSelectionListener \u03e3 = new DataBoxSelectionListener(){

        public void selectionChanged(DataBoxSelectionEvent e2) {
            TList.this.A(true);
        }
    };

    public void lock() {
        if (!this.locked) {
            this.locked = true;
            this.firePropertyChange("locked", false, true);
        }
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void unlock() {
        if (this.locked) {
            this.locked = false;
            this.publishData();
            this.firePropertyChange("locked", true, false);
        }
    }

    public TList() {
        this(new TDataBox());
    }

    public TList(TDataBox box) {
        this.\u03d3.add(D.C);
        this.setDataBox(box);
        this.setModel(this.\u03d2);
        this.setSelectionModel(new _B());
        this.setCellRenderer((ListCellRenderer)new TListCellRenderer(this));
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e2) {
                TList.this.h();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e2) {
                Element element;
                if (!TList.this.isEnabled()) {
                    return;
                }
                if (TList.this.\u0404 == 0) {
                    if (TList.this.isClearSelectionOnMarginClicked() && TList.this.getElementByPoint(e2.getPoint()) == null) {
                        TList.this.getDataBox().getSelectionModel().clearSelection();
                        return;
                    }
                    if (TList.this.isSelectableOnRightClick() && SwingUtilities.isRightMouseButton(e2) && (element = TList.this.getElementByPoint(e2.getPoint())) != null && !element.isSelected()) {
                        TList.this.getDataBox().getSelectionModel().setSelection(element);
                        return;
                    }
                }
                if (!SwingUtilities.isLeftMouseButton(e2) || TList.this.\u0404 == 0) {
                    return;
                }
                element = TList.this.getElementByPoint(e2.getPoint());
                if (element != null && TList.this.isCheckable(element)) {
                    element.setSelected(!element.isSelected());
                }
            }

            public void mouseClicked(MouseEvent e2) {
                Element element;
                JPopupMenu popMenu;
                PopupMenuGenerator generator;
                if (!TList.this.isEnabled()) {
                    return;
                }
                if (SwingUtilities.isRightMouseButton(e2) && (generator = TList.this.getPopupMenuGenerator()) != null && (popMenu = generator.generate(TList.this, e2)) != null) {
                    popMenu.show(TList.this, e2.getPoint().x, e2.getPoint().y);
                    return;
                }
                if ((SwingUtilities.isLeftMouseButton(e2) || TList.this.isEnableRightClickEvent()) && (element = TList.this.getElementByPoint(e2.getPoint())) != null) {
                    MouseActionEvent event = new MouseActionEvent((Object)element, e2, TList.this);
                    if (e2.getClickCount() == 2) {
                        TList.this.fireElementDoubleClicked(event);
                    }
                    TList.this.fireElementClicked(event);
                }
            }
        });
        this.publishData();
    }

    public List getElementDoubleClickedActionListeners() {
        return this.\u03f0;
    }

    public List getElementClickedActionListeners() {
        return this.\u03f1;
    }

    public void setCellRenderer(ListCellRenderer cellRenderer) {
        if (cellRenderer instanceof TListCellRenderer) {
            this.\u03d1 = (TListCellRenderer)cellRenderer;
        } else if (this.\u03d1 != null) {
            throw new IllegalArgumentException("cellRenderer of TList should be an instance of TListCellRenderer");
        }
        super.setCellRenderer(cellRenderer);
    }

    public TListCellRenderer getRenderer() {
        return this.\u03d1;
    }

    public boolean isCenterAlignment() {
        return this.\u03d1.isCenterAlignment();
    }

    public void setCenterAlignment(boolean isCenterAlignment) {
        this.\u03d1.setCenterAlignment(isCenterAlignment);
    }

    public Element getElementByPoint(Point point) {
        int index = this.locationToIndex(point);
        if (index >= 0) {
            return this.getElementByRowIndex(index);
        }
        return null;
    }

    public int locationToIndex(Point location) {
        Rectangle rect;
        int index = super.locationToIndex(location);
        if (!(index != this.\u03ea - 1 || (rect = this.getCellBounds(index, index)) != null && rect.contains(location))) {
            index = -1;
        }
        return index;
    }

    public TDataBox getDataBox() {
        return this.\u03de;
    }

    public void setDataBox(TDataBox box) {
        if (box == null) {
            throw new IllegalArgumentException("DataBox must be non null");
        }
        if (this.\u03de != null) {
            this.g();
        }
        TDataBox oldValue = this.\u03de;
        this.\u03de = box;
        this.i();
        this.publishData();
        this.firePropertyChange("databox", oldValue, this.\u03de);
    }

    private void i() {
        this.\u03de.addBatchListener(this.\u03f3);
        this.\u03de.addDataBoxListener(this.\u03f2);
        this.\u03de.addDataBoxSequenceListener(this.\u03ef);
        this.\u03de.getSelectionModel().addDataBoxSelectionListener(this.\u03e3);
        this.\u03de.addElementPropertyChangeListener(this.\u03e6);
    }

    private void g() {
        this.\u03de.removeBatchListener(this.\u03f3);
        this.\u03de.removeDataBoxSequenceListener(this.\u03ef);
        this.\u03de.removeElementPropertyChangeListener(this.\u03e6);
        this.\u03de.getSelectionModel().removeDataBoxSelectionListener(this.\u03e3);
        this.\u03de.removeDataBoxListener(this.\u03f2);
    }

    private void h() {
        if (this.\u0404 != 0 || !this.isAutoSyncSelectionFromViewToDataBox()) {
            return;
        }
        if (this.\u0402) {
            return;
        }
        this.\u0402 = true;
        Object[] elements = this.getSelectedValues();
        LinkedHashMap<Object, Element> map = new LinkedHashMap<Object, Element>();
        for (int i2 = 0; i2 < elements.length; ++i2) {
            Element element = (Element)elements[i2];
            map.put(element.getID(), element);
        }
        LinkedList<Element> list = new LinkedList<Element>();
        Iterator it = this.\u03de.selection();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            if (!map.containsKey(element.getID())) continue;
            list.add(element);
            map.remove(element.getID());
        }
        list.addAll(map.values());
        this.\u03de.getSelectionModel().setSelection(list);
        if (this.isEnsureVisibleOnSelected()) {
            this.ensureVisible(this.\u03de.getLastSelectedElement());
        }
        this.\u0402 = false;
    }

    private void A(boolean ensureVisible) {
        if (this.\u0402 || !this.isAutoSyncSelectionFromDataBoxToView()) {
            return;
        }
        this.\u0402 = true;
        this.clearSelection();
        Iterator it = this.\u03de.selection();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            int row = this.getRowIndexByElement(element);
            this.addSelectionInterval(row, row);
        }
        if (ensureVisible && this.isEnsureVisibleOnSelected()) {
            this.ensureVisible(this.\u03de.getLastSelectedElement());
        }
        this.\u0402 = false;
    }

    public void addSelectionInterval(int anchor, int lead) {
        ListSelectionModel model = this.getSelectionModel();
        if (model instanceof _B) {
            ((_B)model).A(anchor, lead);
        } else {
            model.addSelectionInterval(anchor, lead);
        }
    }

    public void setEnsureVisibleOnSelected(boolean isEnsureVisibleOnSelected) {
        this.\u03e9 = isEnsureVisibleOnSelected;
    }

    public boolean isEnsureVisibleOnSelected() {
        return this.\u03e9;
    }

    public void ensureVisible(Element element) {
        Rectangle rect;
        if (element == null) {
            return;
        }
        int row = this.getRowIndexByElement(element);
        if (row >= 0 && (rect = this.getCellBounds(row, row)) != null) {
            this.scrollRectToVisible(rect);
        }
    }

    public void updateTViewUI() {
        this.publishData();
    }

    public boolean isVisible(Element element) {
        if (!this.\u03de.contains(element)) {
            return false;
        }
        Iterator it = this.\u03d3.iterator();
        while (it.hasNext()) {
            VisibleFilter filter = (VisibleFilter)it.next();
            if (filter.isVisible(element)) continue;
            return false;
        }
        return true;
    }

    public List getVisibleFilters() {
        return new ArrayList(this.\u03d3);
    }

    public void addVisibleFilter(VisibleFilter visibleFilter) {
        if (visibleFilter != null && !this.\u03d3.contains(visibleFilter)) {
            this.\u03d3.add(visibleFilter);
            this.publishData();
        }
    }

    public void removeVisibleFilter(VisibleFilter visibleFilter) {
        if (visibleFilter != null) {
            this.\u03d3.remove(visibleFilter);
            this.publishData();
        }
    }

    public int getRowIndexByElement(Element element) {
        Integer row = (Integer)this.\u03ed.get(element);
        if (row == null) {
            return -1;
        }
        return row;
    }

    public Element getElementByRowIndex(int rowIndex) {
        return (Element)this.\u03d6.get(TWaverUtil.valueOf(rowIndex));
    }

    public int getTListSelectionMode() {
        return this.\u0404;
    }

    public void setTListSelectionMode(int selectionMode) {
        if (selectionMode == 0 || selectionMode == 1) {
            int oldValue = this.\u0404;
            this.\u0404 = selectionMode;
            this.firePropertyChange("selectionMode", oldValue, this.\u0404);
            this.publishData();
        }
    }

    public CheckableFilter getCheckableFilter() {
        return this.\u0406;
    }

    public void setCheckableFilter(CheckableFilter checkableFilter) {
        this.\u0406 = checkableFilter;
        this.repaint();
    }

    public boolean isCheckable(Element element) {
        if (this.\u0406 == null) {
            return true;
        }
        return this.\u0406.isCheckable(element);
    }

    public Comparator getSortComparator() {
        return this.\u03eb;
    }

    public void setSortComparator(Comparator sortComparator) {
        this.\u03eb = sortComparator;
        this.publishData();
    }

    public boolean isIconVisible() {
        return this.\u03e2;
    }

    public void setIconVisible(boolean isIconVisible) {
        this.\u03e2 = isIconVisible;
        this.updateUI();
    }

    public PopupMenuGenerator getPopupMenuGenerator() {
        return this.\u03e8;
    }

    public void setPopupMenuGenerator(PopupMenuGenerator popupMenuGenerator) {
        this.\u03e8 = popupMenuGenerator;
    }

    public void addElementDoubleClickedActionListener(ActionListener l2) {
        if (!this.\u03f0.contains(l2)) {
            this.\u03f0.add(l2);
        }
    }

    public void removeElementDoubleClickedActionListener(ActionListener l2) {
        this.\u03f0.remove(l2);
    }

    public void fireElementDoubleClicked(MouseActionEvent event) {
        for (int i2 = 0; i2 < this.\u03f0.size(); ++i2) {
            ActionListener l2 = (ActionListener)this.\u03f0.get(i2);
            l2.actionPerformed(event);
        }
    }

    public void addElementClickedActionListener(ActionListener l2) {
        if (!this.\u03f1.contains(l2)) {
            this.\u03f1.add(l2);
        }
    }

    public void removeElementClickedActionListener(ActionListener l2) {
        this.\u03f1.remove(l2);
    }

    public void fireElementClicked(MouseActionEvent event) {
        for (int i2 = 0; i2 < this.\u03f1.size(); ++i2) {
            ActionListener l2 = (ActionListener)this.\u03f1.get(i2);
            l2.actionPerformed(event);
        }
    }

    public void cleanDirtyState() {
        if (this.\u03e7) {
            this.\u03ee = true;
            this.publishData();
            this.\u03ee = false;
            this.\u03e7 = false;
        }
    }

    public void paint(Graphics g2) {
        this.cleanDirtyState();
        super.paint(g2);
    }

    public void updateUI() {
        super.updateUI();
        ListCellRenderer renderer = this.getCellRenderer();
        if (renderer instanceof TListCellRenderer) {
            ((TListCellRenderer)renderer).updateUI();
        }
    }

    public void publishData() {
        if (this.isLocked()) {
            return;
        }
        if (this.\u03de.isBatching()) {
            return;
        }
        if (!this.\u03ee && this.isLazyPublishMode()) {
            this.\u03e7 = true;
            this.repaint();
            return;
        }
        this.\u03ea = 0;
        this.\u03d6.clear();
        this.\u03ed.clear();
        if (this.\u03eb == null) {
            Enumeration e2 = this.\u03de.breadthFirstEnumeration();
            while (e2.hasMoreElements()) {
                Element element = (Element)e2.nextElement();
                if (!this.isVisible(element)) continue;
                Integer row = TWaverUtil.valueOf(this.\u03ea);
                this.\u03d6.put(row, element);
                this.\u03ed.put(element, row);
                ++this.\u03ea;
            }
        } else {
            LinkedList<Element> publishElements = new LinkedList<Element>();
            Enumeration e3 = this.\u03de.breadthFirstEnumeration();
            while (e3.hasMoreElements()) {
                Element element = (Element)e3.nextElement();
                if (!this.isVisible(element)) continue;
                publishElements.add(element);
            }
            Collections.sort(publishElements, this.\u03eb);
            this.\u03ea = publishElements.size();
            for (int i2 = 0; i2 < this.\u03ea; ++i2) {
                Element element = (Element)publishElements.get(i2);
                Integer row = TWaverUtil.valueOf(i2);
                this.\u03d6.put(row, element);
                this.\u03ed.put(element, row);
            }
        }
        this.\u03d2.A();
        this.A(false);
    }

    public boolean isPaintSelectedStateWhenChecked() {
        return this.\u03dc;
    }

    public void setPaintSelectedStateWhenChecked(boolean paintSelectedStateWhenChecked) {
        this.\u03dc = paintSelectedStateWhenChecked;
        this.repaint();
    }

    public Generator getElementIconGenerator() {
        return this.\u03e5;
    }

    public void setElementIconGenerator(Generator elementIconGenerator) {
        this.\u03e5 = elementIconGenerator;
        this.repaint();
    }

    public Generator getElementLabelGenerator() {
        return this.\u0405;
    }

    public void setElementLabelGenerator(Generator elementLabelGenerator) {
        this.\u0405 = elementLabelGenerator;
        this.repaint();
    }

    public Generator getElementToolTipTextGenerator() {
        return this.\u03da;
    }

    public void setElementToolTipTextGenerator(Generator elementToolTipTextGenerator) {
        this.\u03da = elementToolTipTextGenerator;
        this.repaint();
    }

    public int getUncheckableStyle(Element element) {
        return this.\u03ec;
    }

    public int getUncheckableStyle() {
        return this.\u03ec;
    }

    public void setUncheckableStyle(int uncheckableStyle) {
        this.\u03ec = uncheckableStyle;
        this.updateUI();
    }

    public boolean isAutoSyncSelectionFromDataBoxToView() {
        return this.\u03e4;
    }

    public void setAutoSyncSelectionFromDataBoxToView(boolean autoSyncSelectionFromDataBoxToList) {
        this.\u03e4 = autoSyncSelectionFromDataBoxToList;
    }

    public boolean isAutoSyncSelectionFromViewToDataBox() {
        return this.\u0401;
    }

    public void setAutoSyncSelectionFromViewToDataBox(boolean autoSyncSelectionFromListToDataBox) {
        this.\u0401 = autoSyncSelectionFromListToDataBox;
    }

    public boolean isLazyPublishMode() {
        return this.\u03e0;
    }

    public void setLazyPublishMode(boolean lazyPublishMode) {
        this.\u03e0 = lazyPublishMode;
    }

    public boolean isSelectableOnRightClick() {
        return this.\u0403;
    }

    public void setSelectableOnRightClick(boolean isSelectableOnRightClick) {
        this.\u0403 = isSelectableOnRightClick;
    }

    public boolean isClearSelectionOnMarginClicked() {
        return this.\u03d4;
    }

    public void setClearSelectionOnMarginClicked(boolean isClearSelectionOnMarginClicked) {
        this.\u03d4 = isClearSelectionOnMarginClicked;
    }

    public boolean isEnableRightClickEvent() {
        return this.\u03d5;
    }

    public void setEnableRightClickEvent(boolean isEnableRightClickEvent) {
        this.\u03d5 = isEnableRightClickEvent;
    }

    class _A
    extends AbstractListModel {
        _A() {
        }

        public int getSize() {
            return TList.this.\u03ea;
        }

        public Object getElementAt(int i2) {
            return TList.this.getElementByRowIndex(i2);
        }

        public void A() {
            this.fireContentsChanged(this, 0, TList.this.\u03ea);
        }

        public void A(int index) {
            this.fireContentsChanged(this, index, index);
        }
    }

    class _B
    extends DefaultListSelectionModel {
        _B() {
        }

        public void setSelectionInterval(int index0, int index1) {
            if (TList.this.\u0404 == 0) {
                super.setSelectionInterval(index0, index1);
            }
        }

        public void addSelectionInterval(int index0, int index1) {
            if (TList.this.\u0404 == 0) {
                super.addSelectionInterval(index0, index1);
            }
        }

        public void A(int index0, int index1) {
            super.addSelectionInterval(index0, index1);
        }
    }
}

