/*
 * Decompiled with CFR 0.152.
 */
package y.view;

import java.awt.Rectangle;
import y.base.EdgeCursor;
import y.view.AbstractSelectionBoxMode;
import y.view.Graph2D;
import y.view.ViewContainer;

public class SelectionBoxMode
extends AbstractSelectionBoxMode {
    public SelectionBoxMode(ViewContainer viewContainer) {
        super(viewContainer);
    }

    public SelectionBoxMode() {
    }

    protected void selectionBoxAction(Rectangle rectangle, boolean bl) {
        Graph2D graph2D = this.getGraph2D();
        graph2D.firePreEvent();
        if (!bl) {
            graph2D.unselectAll();
            graph2D.selectBoxContent(rectangle);
        } else if (graph2D.selectedEdges().ok()) {
            EdgeCursor edgeCursor = graph2D.edges();
            while (edgeCursor.ok()) {
                if (graph2D.getRealizer(edgeCursor.edge()).intersects(rectangle)) {
                    graph2D.setSelected(edgeCursor.edge(), true);
                }
                edgeCursor.next();
            }
        } else {
            graph2D.selectBoxContent(rectangle);
        }
        graph2D.firePostEvent();
        graph2D.updateViews();
    }
}

