/*
 * Decompiled with CFR 0.152.
 */
package y.layout;

import y.base.YList;
import y.geom.YDimension;
import y.geom.YPoint;
import y.geom.YRectangle;
import y.layout.NodeLabelCandidate;
import y.layout.NodeLabelLayout;
import y.layout.NodeLabelModel;
import y.layout.NodeLayout;

public class DiscreteNodeLabelModel
implements NodeLabelModel {
    public static final int NORTH = 1;
    public static final int NORTH_WEST = 2;
    public static final int NORTH_EAST = 4;
    public static final int EAST = 8;
    public static final int WEST = 16;
    public static final int SOUTH = 32;
    public static final int SOUTH_WEST = 64;
    public static final int SOUTH_EAST = 128;
    public static final int CENTER = 256;
    public static final int BOTTOM = 512;
    public static final int TOP = 1024;
    public static final int LEFT = 2048;
    public static final int RIGHT = 4096;
    public static final int TOP_LEFT = 8192;
    public static final int TOP_RIGHT = 16384;
    public static final int BOTTOM_LEFT = 32768;
    public static final int BOTTOM_RIGHT = 65536;
    public static final int SANDWICH_MASK = 33;
    public static final int INTERNAL_MASK = 130816;
    public static final int SIDES_MASK = 57;
    public static final int CORNER_MASK = 198;
    public static final int EIGHT_POS_MASK = 255;
    static final Integer[] d = new Integer[]{new Integer(1), new Integer(2), new Integer(4), new Integer(8), new Integer(16), new Integer(32), new Integer(64), new Integer(128), new Integer(256), new Integer(512), new Integer(1024), new Integer(2048), new Integer(4096), new Integer(8192), new Integer(16384), new Integer(32768), new Integer(65536)};
    private double e;
    private int c = 130816;

    public DiscreteNodeLabelModel() {
        this(130816, 4.0);
    }

    public DiscreteNodeLabelModel(int n) {
        this(n, 4.0);
    }

    public DiscreteNodeLabelModel(int n, double d2) {
        this.e = d2;
        this.c = n;
    }

    public void setDistance(double d2) {
        this.e = (int)d2;
    }

    public Object getDefaultParameter() {
        if ((this.c & 0x100) != 0) {
            return new Integer(256);
        }
        if ((this.c & 4) != 0) {
            return new Integer(4);
        }
        if ((this.c & 1) != 0) {
            return new Integer(1);
        }
        if ((this.c & 8) != 0) {
            return new Integer(8);
        }
        return new Integer(256);
    }

    public boolean isParameterValid(Object object) {
        int n = (Integer)object;
        return (this.c & n) != 0;
    }

    public YPoint getLabelPlacement(YDimension yDimension, NodeLayout nodeLayout, Object object) {
        return this.getLabelPlacement(yDimension, nodeLayout, (Integer)object);
    }

    public YList getLabelCandidates(NodeLabelLayout nodeLabelLayout, NodeLayout nodeLayout) {
        YList yList = new YList();
        YRectangle yRectangle = nodeLabelLayout.getBox();
        int n = 0;
        while (n < d.length) {
            int n2 = d[n];
            if ((this.c & n2) != 0) {
                boolean bl = false;
                switch (n2) {
                    case 256: 
                    case 512: 
                    case 2048: 
                    case 4096: 
                    case 8192: 
                    case 16384: 
                    case 32768: 
                    case 65536: {
                        bl = true;
                    }
                }
                YPoint yPoint = this.getLabelPlacement((YDimension)yRectangle, nodeLayout, n2);
                yList.add(new NodeLabelCandidate(yPoint, (YDimension)yRectangle, (Object)d[n], nodeLabelLayout, bl));
            }
            ++n;
        }
        return yList;
    }

    protected YPoint getLabelPlacement(YDimension yDimension, NodeLayout nodeLayout, int n) {
        double d2 = Double.NaN;
        double d3 = Double.NaN;
        switch (n) {
            case 256: {
                d2 = nodeLayout.getX() + (nodeLayout.getWidth() - yDimension.getWidth()) / 2.0;
                d3 = nodeLayout.getY() + (nodeLayout.getHeight() - yDimension.getHeight()) / 2.0;
                break;
            }
            case 512: {
                d2 = nodeLayout.getX() + (nodeLayout.getWidth() - yDimension.getWidth()) / 2.0;
                d3 = nodeLayout.getY() + (nodeLayout.getHeight() - yDimension.getHeight()) - this.e;
                break;
            }
            case 1024: {
                d2 = nodeLayout.getX() + (nodeLayout.getWidth() - yDimension.getWidth()) / 2.0;
                d3 = nodeLayout.getY() + this.e;
                break;
            }
            case 2048: {
                d2 = nodeLayout.getX() + this.e;
                d3 = nodeLayout.getY() + (nodeLayout.getHeight() - yDimension.getHeight()) / 2.0;
                break;
            }
            case 4096: {
                d2 = nodeLayout.getX() + (nodeLayout.getWidth() - yDimension.getWidth()) - this.e;
                d3 = nodeLayout.getY() + (nodeLayout.getHeight() - yDimension.getHeight()) / 2.0;
                break;
            }
            case 8192: {
                d2 = nodeLayout.getX() + this.e;
                d3 = nodeLayout.getY() + this.e;
                break;
            }
            case 16384: {
                d2 = nodeLayout.getX() + (nodeLayout.getWidth() - yDimension.getWidth()) - this.e;
                d3 = nodeLayout.getY() + this.e;
                break;
            }
            case 32768: {
                d2 = nodeLayout.getX() + this.e;
                d3 = nodeLayout.getY() + (nodeLayout.getHeight() - yDimension.getHeight()) - this.e;
                break;
            }
            case 65536: {
                d2 = nodeLayout.getX() + (nodeLayout.getWidth() - yDimension.getWidth()) - this.e;
                d3 = nodeLayout.getY() + (nodeLayout.getHeight() - yDimension.getHeight()) - this.e;
                break;
            }
            case 1: {
                d2 = nodeLayout.getX() + (nodeLayout.getWidth() - yDimension.getWidth()) / 2.0;
                d3 = nodeLayout.getY() - yDimension.getHeight() - this.e;
                break;
            }
            case 2: {
                d2 = nodeLayout.getX() - yDimension.getWidth() - this.e;
                d3 = nodeLayout.getY() - yDimension.getHeight();
                break;
            }
            case 4: {
                d2 = nodeLayout.getX() + nodeLayout.getWidth() + this.e;
                d3 = nodeLayout.getY() - yDimension.getHeight();
                break;
            }
            case 8: {
                d2 = nodeLayout.getX() + nodeLayout.getWidth() + this.e;
                d3 = nodeLayout.getY() + (nodeLayout.getHeight() - yDimension.getHeight()) / 2.0;
                break;
            }
            case 16: {
                d2 = nodeLayout.getX() - yDimension.getWidth() - this.e;
                d3 = nodeLayout.getY() + (nodeLayout.getHeight() - yDimension.getHeight()) / 2.0;
                break;
            }
            case 32: {
                d2 = nodeLayout.getX() + (nodeLayout.getWidth() - yDimension.getWidth()) / 2.0;
                d3 = nodeLayout.getY() + nodeLayout.getHeight() + this.e;
                break;
            }
            case 64: {
                d2 = nodeLayout.getX() - yDimension.getWidth() - this.e;
                d3 = nodeLayout.getY() + nodeLayout.getHeight();
                break;
            }
            case 128: {
                d2 = nodeLayout.getX() + nodeLayout.getWidth() + this.e;
                d3 = nodeLayout.getY() + nodeLayout.getHeight();
            }
        }
        return new YPoint(d2, d3);
    }
}

