/*
 * Decompiled with CFR 0.152.
 */
package y.layout;

import y.base.YList;
import y.geom.LineSegment;
import y.geom.YDimension;
import y.geom.YLineSegmentCursor;
import y.geom.YPoint;
import y.geom.YPointPath;
import y.geom.YRectangle;
import y.geom.YVector;
import y.layout.EdgeLabelCandidate;
import y.layout.EdgeLabelLayout;
import y.layout.EdgeLabelLayoutImpl;
import y.layout.EdgeLabelModel;
import y.layout.EdgeLayout;
import y.layout.LayoutTool;
import y.layout.NodeLayout;
import y.layout.SliderEdgeLabelModel;
import y.layout.a;

public class DiscreteEdgeLabelModel
implements EdgeLabelModel {
    public static final int SHEAD = 1;
    public static final int HEAD = 2;
    public static final int THEAD = 4;
    public static final int STAIL = 8;
    public static final int TAIL = 16;
    public static final int TTAIL = 32;
    public static final int SCENTER = 64;
    public static final int CENTER = 128;
    public static final int TCENTER = 256;
    public static final int TWO_POS = 18;
    public static final int CENTERED = 128;
    public static final int SIX_POS = 63;
    public static final int THREE_CENTER = 448;
    private static final double f = 0.0;
    private static final double j = 1.0;
    private static final double h = 0.5;
    static final Integer[] g = new Integer[]{new Integer(1), new Integer(2), new Integer(4), new Integer(8), new Integer(16), new Integer(32), new Integer(64), new Integer(128), new Integer(256)};
    private int d = 63;
    private SliderEdgeLabelModel i;
    private double e = 2.0;

    public DiscreteEdgeLabelModel() {
        this(63);
    }

    public DiscreteEdgeLabelModel(int n) {
        this.d = n;
        this.i = n == 128 || n == 448 ? new SliderEdgeLabelModel(0) : new SliderEdgeLabelModel(1);
    }

    public void setDistance(double d2) {
        this.e = d2;
    }

    public Object getDefaultParameter() {
        if ((this.d & 0x80) != 0) {
            return new Integer(128);
        }
        if ((this.d & 0x40) != 0) {
            return new Integer(64);
        }
        if ((this.d & 0x10) != 0) {
            return new Integer(16);
        }
        if ((this.d & 8) != 0) {
            return new Integer(8);
        }
        return new Integer(128);
    }

    public Object createModelParameter(YRectangle yRectangle, EdgeLayout edgeLayout, NodeLayout nodeLayout, NodeLayout nodeLayout2) {
        EdgeLabelLayoutImpl edgeLabelLayoutImpl = new EdgeLabelLayoutImpl();
        edgeLabelLayoutImpl.setBox(yRectangle);
        YList yList = this.getLabelCandidates(edgeLabelLayoutImpl, edgeLayout, nodeLayout, nodeLayout2);
        if (yList.isEmpty()) {
            return this.getDefaultParameter();
        }
        return a.a(yList, yRectangle.getLocation()).getModelParameter();
    }

    public boolean isParameterValid(Object object) {
        int n = (Integer)object;
        return (this.d & n) != 0;
    }

    public YPoint getLabelPlacement(YDimension yDimension, EdgeLayout edgeLayout, NodeLayout nodeLayout, NodeLayout nodeLayout2, Object object) {
        return this.getLabelPlacement(yDimension, edgeLayout, nodeLayout, nodeLayout2, (Integer)object);
    }

    public YList getLabelCandidates(EdgeLabelLayout edgeLabelLayout, EdgeLayout edgeLayout, NodeLayout nodeLayout, NodeLayout nodeLayout2) {
        YList yList = new YList();
        YRectangle yRectangle = edgeLabelLayout.getBox();
        int n = 0;
        while (n < g.length) {
            int n2 = g[n];
            if ((this.d & n2) != 0) {
                boolean bl = false;
                if (n2 == 128) {
                    bl = true;
                } else if (n2 == 64) {
                    bl = true;
                } else if (n2 == 256) {
                    bl = true;
                }
                YPoint yPoint = this.getLabelPlacement((YDimension)yRectangle, edgeLayout, nodeLayout, nodeLayout2, n2);
                yList.add(new EdgeLabelCandidate(yPoint, (YDimension)yRectangle, (Object)g[n], edgeLabelLayout, bl));
            }
            ++n;
        }
        return yList;
    }

    protected YPoint getLabelPlacement(YDimension yDimension, EdgeLayout edgeLayout, NodeLayout nodeLayout, NodeLayout nodeLayout2, int n) {
        YPointPath yPointPath = LayoutTool.getEdgeClippedOnBB(edgeLayout, nodeLayout, nodeLayout2, 10.0);
        boolean bl = false;
        int n2 = 0;
        double d2 = 0.0;
        int n3 = -1;
        YLineSegmentCursor yLineSegmentCursor = yPointPath.lineSegments();
        while (yLineSegmentCursor.ok()) {
            ++n3;
            LineSegment lineSegment = yLineSegmentCursor.lineSegment();
            double d3 = lineSegment.length();
            if (d3 > d2) {
                d2 = d3;
                n2 = n3;
            }
            yLineSegmentCursor.next();
        }
        int n4 = 0;
        byte by = 3;
        double d4 = 0.0;
        switch (n) {
            case 1: {
                by = 2;
                n4 = 0;
                d4 = 0.0;
                break;
            }
            case 2: {
                by = 2;
                n4 = n2;
                d4 = 0.5;
                break;
            }
            case 4: {
                by = 2;
                n4 = n3;
                d4 = 1.0;
                break;
            }
            case 64: {
                by = 0;
                n4 = 0;
                d4 = 0.0;
                break;
            }
            case 128: {
                by = 0;
                n4 = n2;
                d4 = 0.5;
                break;
            }
            case 256: {
                by = 0;
                n4 = n3;
                d4 = 1.0;
                break;
            }
            case 8: {
                by = 1;
                n4 = 0;
                d4 = 0.0;
                break;
            }
            case 16: {
                by = 1;
                n4 = n2;
                d4 = 0.5;
                break;
            }
            case 32: {
                by = 1;
                n4 = n3;
                d4 = 1.0;
            }
        }
        LineSegment lineSegment = yPointPath.getLineSegment(n4);
        if (lineSegment == null) {
            return new YPoint(nodeLayout.getX(), nodeLayout.getY() - yDimension.getHeight());
        }
        YPoint yPoint = lineSegment.getFirstEndPoint();
        YPoint yPoint2 = lineSegment.getSecondEndPoint();
        double d5 = yPoint2.getX() - yPoint.getX();
        double d6 = yPoint2.getY() - yPoint.getY();
        if (d5 == 0.0 && d6 == 0.0) {
            d5 = nodeLayout.getX() + nodeLayout.getWidth() * 0.5 + edgeLayout.getSourcePoint().x - (nodeLayout2.getX() + nodeLayout2.getWidth() * 0.5 + edgeLayout.getTargetPoint().x);
            d6 = nodeLayout.getY() + nodeLayout.getHeight() * 0.5 + edgeLayout.getSourcePoint().y - (nodeLayout2.getY() + nodeLayout2.getHeight() * 0.5 + edgeLayout.getTargetPoint().y);
            if (d5 == 0.0 && d6 == 0.0) {
                d5 = 1.0E-6;
            }
        }
        YVector yVector = this.i.getOffsetVec(d5, d6, yDimension.getWidth(), yDimension.getHeight(), by);
        yVector.norm();
        yVector.scale(this.e);
        SliderEdgeLabelModel.ModelParameter modelParameter = new SliderEdgeLabelModel.ModelParameter(n4, d4, yVector, by, d4);
        return this.i.getLabelPlacement(yDimension, edgeLayout, nodeLayout, nodeLayout2, modelParameter);
    }
}

