/*
 * Decompiled with CFR 0.152.
 */
package y.io;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import y.base.EdgeCursor;
import y.base.NodeCursor;
import y.io.IOHandler;
import y.io.LinkInfo;
import y.io.LinkMap;
import y.view.EdgeLabel;
import y.view.EdgeRealizer;
import y.view.Graph2D;
import y.view.Graph2DView;
import y.view.NodeLabel;
import y.view.NodeRealizer;

public class ImageMapOutputHandler
extends IOHandler {
    private LinkMap m;
    private int o;
    private final StringBuffer k;
    private boolean n;
    private String l;
    private final StringBuffer p = new StringBuffer();

    public ImageMapOutputHandler() {
        this.k = new StringBuffer();
        this.setIndentDepth(2);
        this.setUseNewlines(true);
    }

    public void read(Graph2D graph2D, InputStream inputStream) {
        throw new UnsupportedOperationException("read operation not supported");
    }

    public void write(Graph2D graph2D, OutputStream outputStream) throws IOException {
        this.createHTMLString(graph2D);
        this.a(this.p, outputStream);
    }

    public String createHTMLString(Graph2D graph2D) {
        this.p.delete(0, this.p.length());
        if (this.m != null) {
            LinkInfo linkInfo;
            Graph2DView graph2DView = (Graph2DView)graph2D.getCurrentView();
            Graph2DView graph2DView2 = graph2DView != null ? graph2DView : this.createDefaultGraph2DView(graph2D);
            double d2 = graph2DView2.getVisibleRect().getX();
            double d3 = graph2DView2.getVisibleRect().getY();
            double d4 = graph2DView2.getZoom();
            this.p.append("<map");
            this.p.append(" name=\"");
            this.p.append(this.m.getMapName());
            this.p.append("\">");
            this.p.append(this.l);
            NodeCursor nodeCursor = graph2D.nodes();
            while (nodeCursor.ok()) {
                NodeRealizer nodeRealizer = graph2D.getRealizer(nodeCursor.node());
                linkInfo = this.m.get(nodeCursor.node());
                if (linkInfo != null) {
                    double d5 = nodeRealizer.getX() - d2;
                    double d6 = nodeRealizer.getY() - d3;
                    this.a(d5, d6, d5 + nodeRealizer.getWidth(), d6 + nodeRealizer.getHeight(), d4, linkInfo);
                }
                int n = 0;
                while (n < nodeRealizer.labelCount()) {
                    NodeLabel nodeLabel = nodeRealizer.getLabel(n);
                    linkInfo = this.m.get(nodeLabel);
                    if (linkInfo != null) {
                        double d7 = nodeLabel.getBox().getX() - d2;
                        double d8 = nodeLabel.getBox().getY() - d3;
                        this.a(d7, d8, d7 + nodeLabel.getWidth(), d8 + nodeLabel.getHeight(), d4, linkInfo);
                    }
                    ++n;
                }
                nodeCursor.next();
            }
            EdgeCursor edgeCursor = graph2D.edges();
            while (edgeCursor.ok()) {
                EdgeRealizer edgeRealizer = graph2D.getRealizer(edgeCursor.edge());
                int n = 0;
                while (n < edgeRealizer.labelCount()) {
                    EdgeLabel edgeLabel = edgeRealizer.getLabel(n);
                    linkInfo = this.m.get(edgeLabel);
                    if (linkInfo != null) {
                        double d9 = edgeLabel.getBox().getX() - d2;
                        double d10 = edgeLabel.getBox().getY() - d3;
                        this.a(d9, d10, d9 + edgeLabel.getWidth(), d10 + edgeLabel.getHeight(), d4, linkInfo);
                    }
                    ++n;
                }
                edgeCursor.next();
            }
            this.p.append("</map>");
            if (graph2DView == null) {
                graph2D.removeView(graph2DView2);
            }
        }
        return this.p.toString();
    }

    public boolean isUseNewlines() {
        return this.n;
    }

    public void setUseNewlines(boolean bl) {
        this.n = bl;
        this.l = bl ? System.getProperty("line.separator") : "";
    }

    public int getIndentDepth() {
        return this.o;
    }

    public void setIndentDepth(int n) {
        this.o = n;
        this.k.delete(0, this.k.length());
        int n2 = 0;
        while (n2 < n) {
            this.k.append(" ");
            ++n2;
        }
    }

    public Graph2DView createDefaultGraph2DView(Graph2D graph2D) {
        Graph2DView graph2DView = new Graph2DView(graph2D);
        Rectangle rectangle = graph2D.getBoundingBox();
        Dimension dimension = new Dimension(rectangle.width, rectangle.height);
        graph2DView.setSize(dimension);
        graph2DView.setPreferredSize(dimension);
        graph2DView.zoomToArea(rectangle.x - 10, rectangle.y - 10, rectangle.width + 20, rectangle.height + 20);
        return graph2DView;
    }

    public LinkMap getReferences() {
        return this.m;
    }

    public void setReferences(LinkMap linkMap) {
        this.m = linkMap;
    }

    public boolean canRead() {
        return false;
    }

    public String getFileFormatString() {
        return "HTML ImageMap";
    }

    public String getFileNameExtension() {
        return "html";
    }

    private void a(StringBuffer stringBuffer, OutputStream outputStream) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
        bufferedWriter.write(stringBuffer.toString());
        bufferedWriter.flush();
    }

    private void a(double d2, double d3, double d4, double d5, double d6, LinkInfo linkInfo) {
        this.p.append(this.k);
        this.p.append("<area");
        this.p.append(" shape=\"rect\"");
        this.p.append(" coords=\"");
        this.p.append((int)(d2 * d6));
        this.p.append(",");
        this.p.append((int)(d3 * d6));
        this.p.append(",");
        this.p.append((int)(d4 * d6));
        this.p.append(",");
        this.p.append((int)(d5 * d6));
        this.p.append("\"");
        if (linkInfo.hasAttribute("href")) {
            this.p.append(" href=\"");
            this.p.append(linkInfo.getAttribute("href"));
            this.p.append("\"");
        } else {
            this.p.append(" nohref");
        }
        Iterator iterator = linkInfo.attributes();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if ("shape".equals(string) || "coords".equals(string) || "href".equals(string)) continue;
            this.p.append(" ");
            this.p.append(string);
            this.p.append("=\"");
            this.p.append(linkInfo.getAttribute(string));
            this.p.append("\"");
        }
        this.p.append(">");
        this.p.append(this.l);
    }
}

