/*
 * Decompiled with CFR 0.152.
 */
package twaver.network;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import twaver.Generator;
import twaver.TWaverConst;
import twaver.network.TNetwork;
import twaver.network.toolbar.NetworkCreateFlexionLinkButton;
import twaver.network.toolbar.NetworkCreateLinkButton;
import twaver.network.toolbar.NetworkCreateLinkSubNetworkButton;
import twaver.network.toolbar.NetworkCreateNodeButton;
import twaver.network.toolbar.NetworkCreateOrthogonalLinkButton;
import twaver.network.toolbar.NetworkCreatePolyButton;
import twaver.network.toolbar.NetworkCreateShapeLinkButton;
import twaver.network.toolbar.NetworkCreateShapeNodeButton;
import twaver.network.toolbar.NetworkCreateShapeSubNetworkButton;
import twaver.network.toolbar.NetworkCreateTextButton;
import twaver.network.toolbar.NetworkExportImageButton;
import twaver.network.toolbar.NetworkExportSVGButton;
import twaver.network.toolbar.NetworkFullScreenButton;
import twaver.network.toolbar.NetworkLazyMoveButton;
import twaver.network.toolbar.NetworkMagnifierButton;
import twaver.network.toolbar.NetworkOpenDataFileButton;
import twaver.network.toolbar.NetworkOverviewButton;
import twaver.network.toolbar.NetworkPanButton;
import twaver.network.toolbar.NetworkPrintButton;
import twaver.network.toolbar.NetworkPrintPreviewButton;
import twaver.network.toolbar.NetworkRedoButton;
import twaver.network.toolbar.NetworkSaveDataFileButton;
import twaver.network.toolbar.NetworkSelectButton;
import twaver.network.toolbar.NetworkUndoButton;
import twaver.network.toolbar.NetworkUpButton;
import twaver.network.toolbar.NetworkZoomBackButton;
import twaver.network.toolbar.NetworkZoomInButton;
import twaver.network.toolbar.NetworkZoomOutButton;
import twaver.network.toolbar.NetworkZoomResetButton;
import twaver.network.toolbar.NetworkZoomToOverviewButton;
import twaver.network.toolbar.NetworkZoomToRectangleButton;

public class NetworkToolBarFactory {
    private static Map A = new LinkedHashMap();
    private static Map B = new LinkedHashMap();
    static /* synthetic */ Class class$twaver$network$TNetwork;

    public static JToolBar getDefaultToolBar(TNetwork network) {
        return NetworkToolBarFactory.getToolBar("default", network);
    }

    public static JToolBar getSimpleToolBar(TNetwork network) {
        return NetworkToolBarFactory.getToolBar("simple", network);
    }

    public static JToolBar getToolBar(String toolbarName, Generator buttonGenerator) {
        if (buttonGenerator == null) {
            throw new NullPointerException("buttonGenerator can not be null");
        }
        List list = (List)A.get(toolbarName);
        if (list == null) {
            throw new NullPointerException("can't find toolbar with name '" + toolbarName + "'.");
        }
        JToolBar toolbar = new JToolBar();
        toolbar.setRollover(true);
        toolbar.setMinimumSize(TWaverConst.EMPTY_DIMENSION);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String buttonGroupName;
            String buttonID = (String)list.get(i2);
            if ("$SEPARATOR".equals(buttonID)) {
                toolbar.addSeparator();
                continue;
            }
            Class clazz = (Class)B.get(buttonID);
            if (clazz == null) {
                throw new NullPointerException("can't find button with id '" + buttonID + "'.");
            }
            JComponent button = (JComponent)buttonGenerator.generate(clazz);
            if (button instanceof AbstractButton && (buttonGroupName = (String)button.getClientProperty("buttonGroupName")) != null) {
                String key = "buttonGroup:" + buttonGroupName;
                ButtonGroup group = (ButtonGroup)toolbar.getClientProperty(key);
                if (group == null) {
                    group = new ButtonGroup();
                    toolbar.putClientProperty(key, group);
                }
                group.add((AbstractButton)button);
            }
            if (button.getName() == null) {
                button.setName(buttonID);
            }
            toolbar.add(button);
        }
        return toolbar;
    }

    public static JToolBar getToolBar(String[] buttonIDs, TNetwork network) {
        if (buttonIDs == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i2 = 0; i2 < buttonIDs.length; ++i2) {
            list.add(buttonIDs[i2]);
        }
        return NetworkToolBarFactory.A(list, network);
    }

    private static JToolBar A(List buttonIDs, TNetwork network) {
        if (buttonIDs == null) {
            return null;
        }
        JToolBar toolbar = new JToolBar();
        toolbar.setRollover(true);
        toolbar.setMinimumSize(TWaverConst.EMPTY_DIMENSION);
        for (int i2 = 0; i2 < buttonIDs.size(); ++i2) {
            String buttonGroupName;
            String buttonID = (String)buttonIDs.get(i2);
            if ("$SEPARATOR".equals(buttonID)) {
                toolbar.addSeparator();
                continue;
            }
            Class clazz = (Class)B.get(buttonID);
            if (clazz == null) {
                throw new NullPointerException("can't find button with id '" + buttonID + "'.");
            }
            AbstractButton button = null;
            try {
                Constructor constructor = clazz.getConstructor(class$twaver$network$TNetwork == null ? NetworkToolBarFactory.class$("twaver.network.TNetwork") : class$twaver$network$TNetwork);
                button = (AbstractButton)constructor.newInstance(network);
            }
            catch (Exception e2) {
                // empty catch block
            }
            if (button == null) {
                try {
                    button = (AbstractButton)clazz.newInstance();
                }
                catch (Exception e3) {
                    // empty catch block
                }
            }
            if (button == null) {
                throw new NullPointerException("can't create instance for Class '" + clazz.getName() + "'.");
            }
            if (button instanceof AbstractButton && (buttonGroupName = (String)button.getClientProperty("buttonGroupName")) != null) {
                String key = "buttonGroup:" + buttonGroupName;
                ButtonGroup group = (ButtonGroup)toolbar.getClientProperty(key);
                if (group == null) {
                    group = new ButtonGroup();
                    toolbar.putClientProperty(key, group);
                }
                group.add(button);
            }
            if (button.getName() == null) {
                button.setName(buttonID);
            }
            toolbar.add(button);
        }
        return toolbar;
    }

    public static JToolBar getToolBar(String toolbarName, TNetwork network) {
        List list = (List)A.get(toolbarName);
        return NetworkToolBarFactory.A(list, network);
    }

    public static void registerButton(String id, Class clazz) {
        if (id == null) {
            throw new NullPointerException("button id can not be null.");
        }
        B.put(id, clazz);
    }

    public static void registerToolbar(String toolbarName, String[] buttonIDS) {
        A.put(toolbarName, Arrays.asList(buttonIDS));
    }

    public static void registerToolbar(String toolbarName, List buttonIDList) {
        A.put(toolbarName, buttonIDList);
    }

    public static Iterator getRegisteredToolbarNames() {
        return A.keySet().iterator();
    }

    public static List getToolbarButtonIDs(String toolbarName) {
        return (List)A.get(toolbarName);
    }

    public static Class getButtonClass(String id) {
        return (Class)B.get(id);
    }

    public static Map getButtons() {
        return B;
    }

    static {
        NetworkToolBarFactory.registerButton("GroupSelection", NetworkLazyMoveButton.class);
        NetworkToolBarFactory.registerButton("OverView", NetworkOverviewButton.class);
        NetworkToolBarFactory.registerButton("Selection", NetworkSelectButton.class);
        NetworkToolBarFactory.registerButton("LazyMove", NetworkLazyMoveButton.class);
        NetworkToolBarFactory.registerButton("Undo", NetworkUndoButton.class);
        NetworkToolBarFactory.registerButton("Redo", NetworkRedoButton.class);
        NetworkToolBarFactory.registerButton("Pan", NetworkPanButton.class);
        NetworkToolBarFactory.registerButton("Magnifier", NetworkMagnifierButton.class);
        NetworkToolBarFactory.registerButton("Up", NetworkUpButton.class);
        NetworkToolBarFactory.registerButton("ZoomIn", NetworkZoomInButton.class);
        NetworkToolBarFactory.registerButton("ZoomOut", NetworkZoomOutButton.class);
        NetworkToolBarFactory.registerButton("ZoomBack", NetworkZoomBackButton.class);
        NetworkToolBarFactory.registerButton("ZoomReset", NetworkZoomResetButton.class);
        NetworkToolBarFactory.registerButton("ZoomToOverview", NetworkZoomToOverviewButton.class);
        NetworkToolBarFactory.registerButton("ZoomToRectangle", NetworkZoomToRectangleButton.class);
        NetworkToolBarFactory.registerButton("Overview", NetworkOverviewButton.class);
        NetworkToolBarFactory.registerButton("FullScreen", NetworkFullScreenButton.class);
        NetworkToolBarFactory.registerButton("OpenDataFile", NetworkOpenDataFileButton.class);
        NetworkToolBarFactory.registerButton("SaveDataFile", NetworkSaveDataFileButton.class);
        NetworkToolBarFactory.registerButton("ExportImage", NetworkExportImageButton.class);
        NetworkToolBarFactory.registerButton("ExportSVG", NetworkExportSVGButton.class);
        NetworkToolBarFactory.registerButton("Print", NetworkPrintButton.class);
        NetworkToolBarFactory.registerButton("PrintPreview", NetworkPrintPreviewButton.class);
        NetworkToolBarFactory.registerButton("CreateNode", NetworkCreateNodeButton.class);
        NetworkToolBarFactory.registerButton("CreateText", NetworkCreateTextButton.class);
        NetworkToolBarFactory.registerButton("CreateLink", NetworkCreateLinkButton.class);
        NetworkToolBarFactory.registerButton("CreateFlexionLink", NetworkCreateFlexionLinkButton.class);
        NetworkToolBarFactory.registerButton("CreateOrthogonalLink", NetworkCreateOrthogonalLinkButton.class);
        NetworkToolBarFactory.registerButton("CreateShapeLink", NetworkCreateShapeLinkButton.class);
        NetworkToolBarFactory.registerButton("CreateLinkSubNetwork", NetworkCreateLinkSubNetworkButton.class);
        NetworkToolBarFactory.registerButton("CreatePoly", NetworkCreatePolyButton.class);
        NetworkToolBarFactory.registerButton("CreateShapeNode", NetworkCreateShapeNodeButton.class);
        NetworkToolBarFactory.registerButton("CreateShapeSubNetwork", NetworkCreateShapeSubNetworkButton.class);
        ArrayList<String> list = new ArrayList<String>();
        list.add("Selection");
        list.add("LazyMove");
        list.add("Magnifier");
        list.add("Pan");
        list.add("Up");
        list.add("ZoomIn");
        list.add("ZoomOut");
        list.add("ZoomBack");
        list.add("ZoomToOverview");
        list.add("ZoomToRectangle");
        list.add("ZoomReset");
        list.add("Overview");
        list.add("FullScreen");
        list.add("ExportImage");
        list.add("ExportSVG");
        NetworkToolBarFactory.registerToolbar("simple", list);
        list = new ArrayList(list);
        list.add("Print");
        list.add("PrintPreview");
        list.add("OpenDataFile");
        list.add("SaveDataFile");
        NetworkToolBarFactory.registerToolbar("default", list);
        list = new ArrayList(list);
        list.add("Undo");
        list.add("Redo");
        list.add("CreateNode");
        list.add("CreateLink");
        list.add("CreateText");
        list.add("CreateShapeLink");
        list.add("CreateShapeNode");
        list.add("CreateShapeSubNetwork");
        list.add("CreateLinkSubNetwork");
        NetworkToolBarFactory.registerToolbar("editor", list);
    }
}

