/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import twaver.BaseEquipment;
import twaver.Node;
import twaver.TWaverUtil;
import twaver.base.A.E.E;
import twaver.base.A.E.b;
import twaver.base.Direction;

public class Shelf
extends BaseEquipment {
    private int z = -1;
    private int y = -1;

    public Shelf() {
        this.T();
    }

    public Shelf(Object id) {
        super(id);
        this.T();
    }

    public boolean isAdjustToBottom() {
        return E.A(this);
    }

    protected void hostPropertyChange(PropertyChangeEvent evt) {
        String propertyName = b.A(evt);
        if (propertyName.equals("equip.direction") || propertyName.equals("equipCount") || propertyName.equals("size") || propertyName.equals("location") || propertyName.equals("shelf.border") || propertyName.equals("shelf.inner.border")) {
            this.adjustBounds();
        }
    }

    private void T() {
        this.setSize(100, 80);
        this.getClientProperties().put("border.insets", TWaverUtil.valueOf(-2));
    }

    public int getEquipCount() {
        return this.z;
    }

    public void setEquipCount(int equipCount) {
        int oldValue = this.z;
        this.z = equipCount;
        this.firePropertyChange("equipCount", oldValue, equipCount);
    }

    public int getEquipIndex() {
        return this.y;
    }

    public void setEquipIndex(int equipIndex) {
        int oldValue = this.y;
        this.y = equipIndex;
        this.firePropertyChange("equipIndex", oldValue, equipIndex);
        this.adjustBounds();
    }

    public Rectangle getEquipBoundsByIndex(int equipIndex) {
        if (this.z <= 0 || equipIndex < 0 || equipIndex >= this.z) {
            return null;
        }
        int shelfBorder = b.J(this, "shelf.border");
        int shelfInnerBorder = b.J(this, "shelf.inner.border");
        Point location = this.getLocation();
        int x = location.x + shelfBorder;
        int y = location.y + shelfBorder;
        int w = this.getWidth() - shelfBorder * 2;
        int h2 = this.getHeight() - shelfBorder * 2;
        if (Direction.VERTICAL.equals(this.getEquipDirection())) {
            double span = (double)w / (double)this.z;
            x = (int)((double)x + span * (double)equipIndex);
            return new Rectangle(x + shelfInnerBorder, y + shelfInnerBorder, (int)span - shelfInnerBorder * 2, h2 - shelfInnerBorder * 2);
        }
        double span = (double)h2 / (double)this.z;
        y = (int)((double)y + span * (double)equipIndex);
        return new Rectangle(x + shelfInnerBorder, y + shelfInnerBorder, w - shelfInnerBorder * 2, (int)span - shelfInnerBorder * 2);
    }

    public void adjustBounds() {
        Node host = this.getHost();
        if (host instanceof Shelf) {
            Rectangle bounds;
            Shelf shelf = (Shelf)host;
            if (this.y >= 0 && this.y < shelf.getEquipCount() && (bounds = shelf.getEquipBoundsByIndex(this.y)) != null) {
                this.setLocation(bounds.x, bounds.y);
                this.setSize(bounds.width, bounds.height);
            }
        }
    }

    public String getUIClassID() {
        return "ShelfUI";
    }

    public String getSVGUIClassID() {
        return "ShelfSVGUI";
    }

    public void putEquipDirection(Direction equipDirection) {
        this.putClientProperty((Object)"equip.direction", equipDirection);
    }

    public Direction getEquipDirection() {
        return b.E(this, "equip.direction");
    }

    public void putShelfBorder(int shelfBorder) {
        this.putClientProperty((Object)"shelf.border", shelfBorder);
    }

    public int getShelfBorder() {
        return b.J(this, "shelf.border");
    }

    public void putShelfInnerBorder(int shelfInnerBorder) {
        this.putClientProperty((Object)"shelf.inner.border", shelfInnerBorder);
    }

    public int getShelfInnerBorder() {
        return b.J(this, "shelf.inner.border");
    }
}

