/*
 * Decompiled with CFR 0.152.
 */
package y.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import y.base.DataProvider;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeList;
import y.base.Node;
import y.base.NodeList;
import y.util.GraphHider;
import y.view.Graph2D;

public abstract class IOHandler {
    public abstract void write(Graph2D var1, OutputStream var2) throws IOException;

    public void writeSubset(Graph2D graph2D, DataProvider dataProvider, OutputStream outputStream) throws IOException {
        GraphHider graphHider = new GraphHider(graph2D);
        this.hide(graphHider, dataProvider);
        this.write(graph2D, outputStream);
        graphHider.unhideAll();
    }

    public abstract void read(Graph2D var1, InputStream var2) throws IOException;

    public abstract String getFileFormatString();

    public abstract String getFileNameExtension();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(Graph2D graph2D, String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        try {
            this.write(graph2D, fileOutputStream);
            Object var5_4 = null;
            if (fileOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (fileOutputStream == null) throw throwable;
            fileOutputStream.flush();
            ((OutputStream)fileOutputStream).close();
            throw throwable;
        }
        fileOutputStream.flush();
        ((OutputStream)fileOutputStream).close();
    }

    public void writeSubset(Graph2D graph2D, DataProvider dataProvider, String string) throws IOException {
        GraphHider graphHider = new GraphHider(graph2D);
        this.hide(graphHider, dataProvider);
        this.write(graph2D, string);
        graphHider.unhideAll();
    }

    public void read(Graph2D graph2D, String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        URL uRL = graph2D.getURL();
        graph2D.setURL(new File(string).toURL());
        try {
            try {
                this.read(graph2D, fileInputStream);
            }
            catch (IOException iOException) {
                graph2D.setURL(uRL);
                throw iOException;
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            ((InputStream)fileInputStream).close();
            throw throwable;
        }
        ((InputStream)fileInputStream).close();
    }

    public void read(Graph2D graph2D, URL uRL) throws IOException {
        InputStream inputStream = uRL.openStream();
        URL uRL2 = graph2D.getURL();
        graph2D.setURL(uRL);
        try {
            try {
                this.read(graph2D, inputStream);
            }
            catch (IOException iOException) {
                graph2D.setURL(uRL2);
                throw iOException;
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
    }

    public static ObjectInputStream createObjectInputStream(String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        return new ObjectInputStream(bufferedInputStream);
    }

    public static ObjectOutputStream createObjectOutputStream(String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        return new ObjectOutputStream(fileOutputStream);
    }

    public boolean canRead() {
        return true;
    }

    public boolean canWrite() {
        return true;
    }

    public boolean canWriteSubset() {
        return true;
    }

    protected void hide(GraphHider graphHider, DataProvider dataProvider) {
        Object object;
        EdgeList edgeList = new EdgeList();
        NodeList nodeList = new NodeList();
        EdgeCursor edgeCursor = graphHider.getGraph().edges();
        while (edgeCursor.ok()) {
            object = edgeCursor.edge();
            if (!this.shouldSerialize((Edge)object, dataProvider)) {
                edgeList.add(object);
            }
            edgeCursor.next();
        }
        object = graphHider.getGraph().nodes();
        while (object.ok()) {
            Node node = object.node();
            if (!this.shouldSerialize(node, dataProvider)) {
                nodeList.add(node);
            }
            object.next();
        }
        graphHider.hide(edgeList);
        graphHider.hide(nodeList);
    }

    protected boolean shouldSerialize(Node node, DataProvider dataProvider) {
        if (dataProvider == null || dataProvider.getBool(node)) {
            return true;
        }
        EdgeCursor edgeCursor = node.edges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            if (this.shouldSerialize(edge, dataProvider)) {
                return true;
            }
            edgeCursor.next();
        }
        return false;
    }

    protected boolean shouldSerialize(Edge edge, DataProvider dataProvider) {
        return dataProvider == null || dataProvider.getBool(edge) || dataProvider.getBool(edge.source()) && dataProvider.getBool(edge.target());
    }
}

