/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.util.net.url;

import com.nepxion.util.net.url.URLConfig;
import com.nepxion.util.net.url.URLConstants;
import com.nepxion.util.net.url.URLLogger;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class URLContext
implements URLConstants {
    private static Log log = LogFactory.getLog(URLContext.class);
    private static LinkedHashMap urlConfigMap;

    public static void register() throws Exception {
        URLContext.register("conf/url.properties");
    }

    public static void register(String filePath) throws Exception {
        log.info((Object)"----- URL Context Initialization Start -----");
        urlConfigMap = new LinkedHashMap();
        Properties properties = new Properties();
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(filePath);
            properties.load(inputStream);
            URLContext.parseConfig(properties);
        }
        catch (Exception e) {
            log.fatal((Object)e);
            throw e;
        }
        finally {
            if (inputStream != null) {
                ((InputStream)inputStream).close();
            }
        }
        log.info((Object)"------ URL Context Initialization End ------");
    }

    public static void register(Properties properties) throws Exception {
        log.info((Object)"----- URL Context Initialization Start -----");
        try {
            URLContext.parseConfig(properties);
        }
        catch (Exception e) {
            log.fatal((Object)e);
            throw e;
        }
        log.info((Object)"------ URL Context Initialization End ------");
    }

    public static void register(URL codeBase) throws Exception {
        log.info((Object)"----- URL Context Initialization Start -----");
        urlConfigMap = new LinkedHashMap();
        Properties properties = new Properties();
        try {
            URL url = new URL(codeBase + "conf/url.properties");
            properties.load(url.openStream());
            URLContext.parseConfig(properties, url);
        }
        catch (Exception e) {
            log.fatal((Object)e);
            throw e;
        }
        log.info((Object)"------ URL Context Initialization End ------");
    }

    public static URLConfig getConfig(String alias) {
        URLConfig urlConfig = (URLConfig)urlConfigMap.get(alias);
        if (urlConfig == null) {
            throw new IllegalArgumentException("URL Config for " + alias + " hasn't been found");
        }
        return urlConfig;
    }

    private static void parseConfig(Properties properties) throws Exception {
        URLContext.parseConfig(properties, null);
    }

    private static void parseConfig(Properties properties, URL url) throws Exception {
        HashMap<String, Properties> propertiesMap = new HashMap<String, Properties>();
        for (String string : properties.keySet()) {
            String value = properties.getProperty(string);
            if (!string.startsWith("url")) continue;
            int index = string.indexOf(".");
            if (index == -1) {
                throw new Exception("Property " + string + " must be of the format " + "url" + "*" + "." + "*");
            }
            String prefix = string.substring(0, index);
            String name = string.substring(index + 1);
            Properties configProperties = (Properties)propertiesMap.get(prefix);
            if (configProperties == null) {
                configProperties = new Properties();
                propertiesMap.put(prefix, configProperties);
            }
            configProperties.put(name, value);
        }
        for (String string : propertiesMap.keySet()) {
            Properties configProperties = (Properties)propertiesMap.get(string);
            URLConfig config = URLContext.createConfig(configProperties, url);
            urlConfigMap.put(config.getAlias(), config);
        }
        URLLogger.info(urlConfigMap);
    }

    private static URLConfig createConfig(Properties properties, URL url) {
        URLConfig urlConfig = new URLConfig();
        urlConfig.setAlias(properties.getProperty("alias"));
        if (!properties.getProperty("host").equals("")) {
            urlConfig.setHost(properties.getProperty("host"));
        } else if (url != null) {
            urlConfig.setHost(url.getHost());
        }
        if (!properties.getProperty("port").equals("")) {
            urlConfig.setPort(Integer.parseInt(properties.getProperty("port")));
        } else if (url != null) {
            urlConfig.setPort(url.getPort());
        }
        urlConfig.setPath(properties.getProperty("path"));
        return urlConfig;
    }
}

