/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.cots.twaver.graph;

import com.nepxion.cots.twaver.element.TGroupType;
import com.nepxion.cots.twaver.graph.TGraph;
import com.nepxion.cots.twaver.graph.TGraphController;
import com.nepxion.cots.twaver.icon.TIconFactory;
import com.nepxion.cots.twaver.locale.TLocale;
import com.nepxion.swing.action.JSecurityAction;
import com.nepxion.swing.button.ButtonManager;
import com.nepxion.swing.button.JBasicButton;
import com.nepxion.swing.button.JBasicMenuButton;
import com.nepxion.swing.button.JBasicToggleButton;
import com.nepxion.swing.layout.table.TableLayout;
import com.nepxion.swing.menuitem.JBasicMenuItem;
import com.nepxion.swing.menuitem.JBasicRadioButtonMenuItem;
import com.nepxion.swing.outlookbar.JFlatOutlook;
import com.nepxion.swing.outlookbar.JFlatOutlookBar;
import com.nepxion.swing.popupmenu.JBasicPopupMenu;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class TGraphControlBar
extends JFlatOutlookBar {
    private TGraph graph;
    private ViewToolBar viewToolBar;
    private NodeToolBar nodeToolBar;
    private IOToolBar ioToolBar;
    private JBasicButton importButton;

    public TGraphControlBar(TGraph graph) {
        this.graph = graph;
        this.viewToolBar = new ViewToolBar();
        this.nodeToolBar = new NodeToolBar();
        this.ioToolBar = new IOToolBar();
        this.addTab(TLocale.getString("operation_view"), null, this.makeScrollPane(this.viewToolBar), TLocale.getString("operation_view"));
        this.addTab(TLocale.getString("operation_node"), null, this.makeScrollPane(this.nodeToolBar), TLocale.getString("operation_view"));
        this.addTab(TLocale.getString("operation_io"), null, this.makeScrollPane(this.ioToolBar), TLocale.getString("operation_view"));
        this.setEnableImport(false);
    }

    public TGraph getGraph() {
        return this.graph;
    }

    public ViewToolBar getViewToolBar() {
        return this.viewToolBar;
    }

    public NodeToolBar getNodeToolBar() {
        return this.nodeToolBar;
    }

    public IOToolBar getIOToolBar() {
        return this.ioToolBar;
    }

    public void setEnableImport(boolean enabled) {
        ((JSecurityAction)this.importButton.getAction()).setPermitted(enabled);
    }

    public class IOToolBar
    extends JPanel {
        private JFlatOutlook ioOutlook;

        public IOToolBar() {
            double[][] size = new double[][]{{30.0, 30.0}, {-1.0, -1.0}};
            this.ioOutlook = new JFlatOutlook();
            this.ioOutlook.setLayout((LayoutManager)new TableLayout((double[][])size));
            TGraphControlBar.this.importButton = new JBasicButton((Action)TGraphController.getImportAction(TGraphControlBar.this.graph));
            TGraphControlBar.this.importButton.setText("");
            this.ioOutlook.add((Component)TGraphControlBar.this.importButton, (Object)"0, 0");
            JBasicPopupMenu exportPopupMenu = new JBasicPopupMenu();
            JBasicMenuItem exportXMLMenuItem = new JBasicMenuItem((Action)TGraphController.getExportXMLAction(TGraphControlBar.this.graph));
            exportPopupMenu.add((JMenuItem)exportXMLMenuItem);
            exportPopupMenu.addSeparator();
            JBasicMenuItem exportSVGMenuItem = new JBasicMenuItem((Action)TGraphController.getExportSVGAction(TGraphControlBar.this.graph));
            exportPopupMenu.add((JMenuItem)exportSVGMenuItem);
            JBasicMenuItem exportImageMenuItem = new JBasicMenuItem((Action)TGraphController.getExportImageAction(TGraphControlBar.this.graph));
            exportPopupMenu.add((JMenuItem)exportImageMenuItem);
            JBasicMenuButton exportButton = new JBasicMenuButton((Icon)TIconFactory.getContextIcon("export.png"), TLocale.getString("export"));
            exportButton.setPopupMenu((JPopupMenu)exportPopupMenu);
            this.ioOutlook.add((Component)exportButton, (Object)"1, 0");
            JBasicButton printButton = new JBasicButton((Action)TGraphController.getPrintAction(TGraphControlBar.this.graph));
            printButton.setText("");
            this.ioOutlook.add((Component)printButton, (Object)"0, 1");
            ButtonManager.updateUI((Container)this.ioOutlook, (Dimension)new Dimension(25, 25));
            this.add((Component)this.ioOutlook);
        }

        public JFlatOutlook getIOOutlook() {
            return this.ioOutlook;
        }
    }

    public class NodeToolBar
    extends JPanel {
        private JFlatOutlook nodeOutlook;

        public NodeToolBar() {
            double[][] size = new double[][]{{30.0, 30.0}, {-1.0, -1.0, -1.0, -1.0}};
            this.nodeOutlook = new JFlatOutlook();
            this.nodeOutlook.setLayout((LayoutManager)new TableLayout((double[][])size));
            JBasicPopupMenu lockPopupMenu = new JBasicPopupMenu();
            JBasicMenuItem lockAllMenuItem = new JBasicMenuItem((Action)TGraphController.getLockAllAction(TGraphControlBar.this.graph));
            lockPopupMenu.add((JMenuItem)lockAllMenuItem);
            JBasicMenuItem unLockAllMenuItem = new JBasicMenuItem((Action)TGraphController.getUnLockAllAction(TGraphControlBar.this.graph));
            lockPopupMenu.add((JMenuItem)unLockAllMenuItem);
            lockPopupMenu.addSeparator();
            JBasicMenuItem lockSelectionMenuItem = new JBasicMenuItem((Action)TGraphController.getLockSelectionAction(TGraphControlBar.this.graph));
            lockPopupMenu.add((JMenuItem)lockSelectionMenuItem);
            JBasicMenuItem unLockSelectionMenuItem = new JBasicMenuItem((Action)TGraphController.getUnLockSelectionAction(TGraphControlBar.this.graph));
            lockPopupMenu.add((JMenuItem)unLockSelectionMenuItem);
            JBasicMenuButton lockButton = new JBasicMenuButton((Icon)TIconFactory.getContextIcon("lock.png"), TLocale.getString("element_lock_and_unlock"));
            lockButton.setPopupMenu((JPopupMenu)lockPopupMenu);
            this.nodeOutlook.add((Component)lockButton, (Object)"0, 0");
            JBasicButton hideChildrenButton = new JBasicButton((Action)TGraphController.getHideChildrenAction(TGraphControlBar.this.graph));
            hideChildrenButton.setText("");
            this.nodeOutlook.add((Component)hideChildrenButton, (Object)"1, 0");
            JBasicPopupMenu alignPopupMenu = new JBasicPopupMenu();
            JBasicMenuItem alignLeftMenuItem = new JBasicMenuItem((Action)TGraphController.getAlignLeftAction(TGraphControlBar.this.graph));
            alignPopupMenu.add((JMenuItem)alignLeftMenuItem);
            JBasicMenuItem alignVerticalCenterMenuItem = new JBasicMenuItem((Action)TGraphController.getAlignVerticalCenterAction(TGraphControlBar.this.graph));
            alignPopupMenu.add((JMenuItem)alignVerticalCenterMenuItem);
            JBasicMenuItem alignRightMenuItem = new JBasicMenuItem((Action)TGraphController.getAlignRightAction(TGraphControlBar.this.graph));
            alignPopupMenu.add((JMenuItem)alignRightMenuItem);
            alignPopupMenu.addSeparator();
            JBasicMenuItem alignTopMenuItem = new JBasicMenuItem((Action)TGraphController.getAlignTopAction(TGraphControlBar.this.graph));
            alignPopupMenu.add((JMenuItem)alignTopMenuItem);
            JBasicMenuItem alignHorizontalCenterMenuItem = new JBasicMenuItem((Action)TGraphController.getAlignHorizontalCenterAction(TGraphControlBar.this.graph));
            alignPopupMenu.add((JMenuItem)alignHorizontalCenterMenuItem);
            JBasicMenuItem alignBottomMenuItem = new JBasicMenuItem((Action)TGraphController.getAlignBottomAction(TGraphControlBar.this.graph));
            alignPopupMenu.add((JMenuItem)alignBottomMenuItem);
            JBasicMenuButton alignButton = new JBasicMenuButton((Icon)TIconFactory.getContextIcon("align_vertical_center.png"), TLocale.getString("element_align"));
            alignButton.setPopupMenu((JPopupMenu)alignPopupMenu);
            this.nodeOutlook.add((Component)alignButton, (Object)"0, 1");
            JBasicPopupMenu pilePopupMenu = new JBasicPopupMenu();
            JBasicMenuItem pileToLeftMenuItem = new JBasicMenuItem((Action)TGraphController.getPileToLeftAction(TGraphControlBar.this.graph));
            pilePopupMenu.add((JMenuItem)pileToLeftMenuItem);
            JBasicMenuItem pileToRightMenuItem = new JBasicMenuItem((Action)TGraphController.getPileToRightAction(TGraphControlBar.this.graph));
            pilePopupMenu.add((JMenuItem)pileToRightMenuItem);
            pilePopupMenu.addSeparator();
            JBasicMenuItem pileToTopMenuItem = new JBasicMenuItem((Action)TGraphController.getPileToTopAction(TGraphControlBar.this.graph));
            pilePopupMenu.add((JMenuItem)pileToTopMenuItem);
            JBasicMenuItem pileToBottomMenuItem = new JBasicMenuItem((Action)TGraphController.getPileToBottomAction(TGraphControlBar.this.graph));
            pilePopupMenu.add((JMenuItem)pileToBottomMenuItem);
            JBasicMenuButton pileButton = new JBasicMenuButton((Icon)TIconFactory.getContextIcon("pile_to_top.png"), TLocale.getString("element_pile"));
            pileButton.setPopupMenu((JPopupMenu)pilePopupMenu);
            this.nodeOutlook.add((Component)pileButton, (Object)"1, 1");
            JBasicPopupMenu sameSizePopupMenu = new JBasicPopupMenu();
            JBasicMenuItem sameWidthMenuItem = new JBasicMenuItem((Action)TGraphController.getSameWidthAction(TGraphControlBar.this.graph));
            sameSizePopupMenu.add((JMenuItem)sameWidthMenuItem);
            JBasicMenuItem sameHeightMenuItem = new JBasicMenuItem((Action)TGraphController.getSameHeightAction(TGraphControlBar.this.graph));
            sameSizePopupMenu.add((JMenuItem)sameHeightMenuItem);
            sameSizePopupMenu.addSeparator();
            JBasicMenuItem evenHorizontalSpaceMenuItem = new JBasicMenuItem((Action)TGraphController.getSameHorizontalSpaceAction(TGraphControlBar.this.graph));
            sameSizePopupMenu.add((JMenuItem)evenHorizontalSpaceMenuItem);
            JBasicMenuItem evenVerticalSpaceMenuItem = new JBasicMenuItem((Action)TGraphController.getSameVerticalSpaceAction(TGraphControlBar.this.graph));
            sameSizePopupMenu.add((JMenuItem)evenVerticalSpaceMenuItem);
            JBasicMenuButton sameSizeButton = new JBasicMenuButton((Icon)TIconFactory.getContextIcon("same_horizontal_space.png"), TLocale.getString("element_size_and_distance_adjust"));
            sameSizeButton.setPopupMenu((JPopupMenu)sameSizePopupMenu);
            this.nodeOutlook.add((Component)sameSizeButton, (Object)"0, 2");
            JBasicPopupMenu layerPopupMenu = new JBasicPopupMenu();
            JBasicMenuItem moveToUpMenuItem = new JBasicMenuItem((Action)TGraphController.getMoveToUpAction(TGraphControlBar.this.graph));
            layerPopupMenu.add((JMenuItem)moveToUpMenuItem);
            JBasicMenuItem moveToDownMenuItem = new JBasicMenuItem((Action)TGraphController.getMoveToDownAction(TGraphControlBar.this.graph));
            layerPopupMenu.add((JMenuItem)moveToDownMenuItem);
            layerPopupMenu.addSeparator();
            JBasicMenuItem moveToTopMenuItem = new JBasicMenuItem((Action)TGraphController.getMoveToTopAction(TGraphControlBar.this.graph));
            layerPopupMenu.add((JMenuItem)moveToTopMenuItem);
            JBasicMenuItem moveToBottomMenuItem = new JBasicMenuItem((Action)TGraphController.getMoveToBottomAction(TGraphControlBar.this.graph));
            layerPopupMenu.add((JMenuItem)moveToBottomMenuItem);
            JBasicMenuButton layerButton = new JBasicMenuButton((Icon)TIconFactory.getContextIcon("move_to_up.png"), TLocale.getString("element_layer_adjust"));
            layerButton.setPopupMenu((JPopupMenu)layerPopupMenu);
            this.nodeOutlook.add((Component)layerButton, (Object)"1, 2");
            JBasicPopupMenu groupPopupMenu = new JBasicPopupMenu();
            ButtonGroup groupTypeButtonGroup = new ButtonGroup();
            TGroupType[] groupTypes = new TGroupType[]{TGroupType.RECTANGLE_GROUP_TYPE, TGroupType.ROUND_RECTANGLE_GROUP_TYPE, TGroupType.ROUND_GROUP_TYPE, TGroupType.OCTAGON_GROUP_TYPE, TGroupType.PARALLELOGRAM_GROUP_TYPE, TGroupType.ELLIPSE_GROUP_TYPE};
            for (int i = 0; i < groupTypes.length; ++i) {
                TGroupType groupType = groupTypes[i];
                JBasicRadioButtonMenuItem groupTypeMenuItem = new JBasicRadioButtonMenuItem((Action)TGraphController.getGroupTypeConfigAction(TGraphControlBar.this.graph, groupType));
                groupPopupMenu.add((JMenuItem)groupTypeMenuItem);
                if (groupType == TGroupType.PARALLELOGRAM_GROUP_TYPE) {
                    groupTypeMenuItem.setSelected(true);
                }
                groupTypeButtonGroup.add((AbstractButton)groupTypeMenuItem);
            }
            groupPopupMenu.addSeparator();
            JBasicMenuItem expandAllGroupsMenuItem = new JBasicMenuItem((Action)TGraphController.getGroupExpandAction(TGraphControlBar.this.graph));
            groupPopupMenu.add((JMenuItem)expandAllGroupsMenuItem);
            JBasicMenuItem collapseAllGroupsMenuItem = new JBasicMenuItem((Action)TGraphController.getGroupCollapseAction(TGraphControlBar.this.graph));
            groupPopupMenu.add((JMenuItem)collapseAllGroupsMenuItem);
            JBasicMenuButton groupButton = new JBasicMenuButton((Icon)TIconFactory.getContextIcon("group.png"), TLocale.getString("group_setting"));
            groupButton.setPopupMenu((JPopupMenu)groupPopupMenu);
            this.nodeOutlook.add((Component)groupButton, (Object)"0, 3");
            JBasicPopupMenu linkPopupMenu = new JBasicPopupMenu();
            JBasicMenuItem showAllLinksMenuItem = new JBasicMenuItem((Action)TGraphController.getLinkShowAction(TGraphControlBar.this.graph));
            linkPopupMenu.add((JMenuItem)showAllLinksMenuItem);
            JBasicMenuItem hideAllLinksMenuItem = new JBasicMenuItem((Action)TGraphController.getLinkHideAction(TGraphControlBar.this.graph));
            linkPopupMenu.add((JMenuItem)hideAllLinksMenuItem);
            JBasicMenuButton linkButton = new JBasicMenuButton((Icon)TIconFactory.getContextIcon("link.png"), TLocale.getString("link_setting"));
            linkButton.setPopupMenu((JPopupMenu)linkPopupMenu);
            this.nodeOutlook.add((Component)linkButton, (Object)"1, 3");
            ButtonManager.updateUI((Container)this.nodeOutlook, (Dimension)new Dimension(25, 25), (ButtonGroup)new ButtonGroup());
            this.add((Component)this.nodeOutlook);
        }

        public JFlatOutlook getNodeOutlook() {
            return this.nodeOutlook;
        }
    }

    public class ViewToolBar
    extends JPanel {
        private JFlatOutlook viewOutlook;

        public ViewToolBar() {
            double[][] size = new double[][]{{30.0, 30.0}, {-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0}};
            this.viewOutlook = new JFlatOutlook();
            this.viewOutlook.setLayout((LayoutManager)new TableLayout((double[][])size));
            JBasicToggleButton selectButton = new JBasicToggleButton((Action)TGraphController.getSelectAction(TGraphControlBar.this.graph));
            selectButton.setSelected(true);
            selectButton.setText("");
            this.viewOutlook.add((Component)selectButton, (Object)"0, 0");
            JBasicToggleButton panButton = new JBasicToggleButton((Action)TGraphController.getPanAction(TGraphControlBar.this.graph));
            panButton.setText("");
            this.viewOutlook.add((Component)panButton, (Object)"0, 1");
            JBasicToggleButton lazeMoveButton = new JBasicToggleButton((Action)TGraphController.getLazyMoveAction(TGraphControlBar.this.graph));
            lazeMoveButton.setText("");
            this.viewOutlook.add((Component)lazeMoveButton, (Object)"1, 1");
            JBasicButton zoomInButton = new JBasicButton((Action)TGraphController.getZoomInAction(TGraphControlBar.this.graph));
            zoomInButton.setText("");
            this.viewOutlook.add((Component)zoomInButton, (Object)"0, 2");
            JBasicButton zoomOutButton = new JBasicButton((Action)TGraphController.getZoomOutAction(TGraphControlBar.this.graph));
            zoomOutButton.setText("");
            this.viewOutlook.add((Component)zoomOutButton, (Object)"1, 2");
            JBasicToggleButton zoomInRectangleButton = new JBasicToggleButton((Action)TGraphController.getZoomInRectangleAction(TGraphControlBar.this.graph));
            zoomInRectangleButton.setText("");
            this.viewOutlook.add((Component)zoomInRectangleButton, (Object)"0, 3");
            JBasicButton zoomResetButton = new JBasicButton((Action)TGraphController.getZoomResetAction(TGraphControlBar.this.graph));
            zoomResetButton.setText("");
            this.viewOutlook.add((Component)zoomResetButton, (Object)"1, 3");
            JBasicToggleButton magnifierButton = new JBasicToggleButton((Action)TGraphController.getMagnifierAction(TGraphControlBar.this.graph));
            magnifierButton.setText("");
            this.viewOutlook.add((Component)magnifierButton, (Object)"0, 4");
            JBasicPopupMenu zoomPopupMenu = new JBasicPopupMenu();
            JBasicMenuItem zoomToOverviewMenuItem = new JBasicMenuItem((Action)TGraphController.getZoomToOverviewAction(TGraphControlBar.this.graph));
            zoomPopupMenu.add((JMenuItem)zoomToOverviewMenuItem);
            zoomPopupMenu.addSeparator();
            JBasicMenuItem zoomBackMenuItem = new JBasicMenuItem((Action)TGraphController.getZoomBackAction(TGraphControlBar.this.graph));
            zoomPopupMenu.add((JMenuItem)zoomBackMenuItem);
            JBasicMenuButton zoomButton = new JBasicMenuButton((Icon)TIconFactory.getContextIcon("zoom.png"), TLocale.getString("graph_zoom"));
            zoomButton.setPopupMenu((JPopupMenu)zoomPopupMenu);
            this.viewOutlook.add((Component)zoomButton, (Object)"1, 4");
            JBasicToggleButton scaleButton = new JBasicToggleButton((Action)TGraphController.getScaleAction(TGraphControlBar.this.graph));
            scaleButton.setText("");
            scaleButton.setGrouped(false);
            this.viewOutlook.add((Component)scaleButton, (Object)"0, 5");
            JBasicToggleButton layoutButton = new JBasicToggleButton((Action)TGraphController.getLayoutAction(TGraphControlBar.this.graph));
            layoutButton.setText("");
            layoutButton.setGrouped(false);
            this.viewOutlook.add((Component)layoutButton, (Object)"1, 5");
            JBasicButton fullscreenButton = new JBasicButton((Action)TGraphController.getFullScreenAction(TGraphControlBar.this.graph));
            fullscreenButton.setText("");
            this.viewOutlook.add((Component)fullscreenButton, (Object)"0, 6");
            JBasicToggleButton overviewButton = new JBasicToggleButton((Action)TGraphController.getOverviewAction(TGraphControlBar.this.graph));
            overviewButton.setText("");
            overviewButton.setGrouped(false);
            this.viewOutlook.add((Component)overviewButton, (Object)"1, 6");
            ButtonManager.updateUI((Container)this.viewOutlook, (Dimension)new Dimension(25, 25), (ButtonGroup)new ButtonGroup());
            this.add((Component)this.viewOutlook);
        }

        public JFlatOutlook getViewOutlook() {
            return this.viewOutlook;
        }
    }
}

