/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.style.button.lite;

import com.nepxion.swing.button.IButtonModel;
import com.nepxion.swing.style.button.AbstractButtonUI;
import com.nepxion.swing.style.button.IButtonStyle;
import com.nepxion.swing.style.button.lite.ILiteButtonStyle;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class LiteButtonUI
extends AbstractButtonUI {
    public static final String ID = LiteButtonUI.class.getName();
    protected Color rolloverBackground;
    protected Color rolloverBorderColor;
    protected Color selectionBackground;
    protected Color selectionBorderColor;
    protected ILiteButtonStyle buttonStyle;

    public LiteButtonUI(IButtonStyle buttonStyle) {
        this.setButtonStyle(buttonStyle);
        this.setArrowPainted(false);
    }

    @Override
    public IButtonStyle getButtonStyle() {
        return this.buttonStyle;
    }

    @Override
    public void setButtonStyle(IButtonStyle buttonStyle) {
        this.buttonStyle = (ILiteButtonStyle)buttonStyle;
        this.rolloverBackground = this.buttonStyle.getRolloverBackground();
        this.rolloverBorderColor = this.buttonStyle.getRolloverBorderColor();
        this.selectionBackground = this.buttonStyle.getSelectionBackground();
        this.selectionBorderColor = this.buttonStyle.getSelectionBorderColor();
    }

    @Override
    public void paintMenuDropDown(IButtonModel buttonModel, Graphics g, JComponent c) {
    }

    @Override
    public void paintPressed(IButtonModel buttonModel, Graphics g, JComponent c) {
        g.setColor(this.selectionBackground);
        g.fillRect(0, 0, c.getWidth() - 1, c.getHeight() - 1);
        g.setColor(this.selectionBorderColor);
        g.drawRect(0, 0, c.getWidth() - 1, c.getHeight() - 1);
    }

    @Override
    public void paintSelected(IButtonModel buttonModel, Graphics g, JComponent c) {
        this.paintPressed(buttonModel, g, c);
    }

    @Override
    public void paintRollover(IButtonModel buttonModel, Graphics g, JComponent c) {
        g.setColor(this.rolloverBackground);
        g.fillRect(0, 0, c.getWidth() - 1, c.getHeight() - 1);
        g.setColor(this.rolloverBorderColor);
        g.drawRect(0, 0, c.getWidth() - 1, c.getHeight() - 1);
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        if (c.getWidth() % 2 != 0) {
            ++textRect.x;
        }
        if (c.getHeight() % 2 != 0) {
            ++textRect.y;
        }
        textRect.x += this.getWidthOffset();
        textRect.y += this.getHeightOffset();
        super.paintText(g, c, textRect, text);
    }

    @Override
    protected void paintIcon(Graphics g, JComponent c, Rectangle iconRect) {
        if (c.getWidth() % 2 != 0) {
            ++iconRect.x;
        }
        if (c.getHeight() % 2 != 0) {
            ++iconRect.y;
        }
        iconRect.x += this.getWidthOffset();
        iconRect.y += this.getHeightOffset();
        super.paintIcon(g, c, iconRect);
    }
}

