/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.panel;

import com.nepxion.swing.checkbox.JBasicCheckBox;
import com.nepxion.swing.dimension.DimensionManager;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.radiobutton.JBasicRadioButton;
import com.nepxion.swing.textfield.JIPAddressTextField;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JIPPropertyPanel
extends JPanel {
    private JBasicRadioButton dhcpIPAddressRadioButton;
    private JBasicRadioButton useIPAddressRadioButton;
    private JLabel ipAddressLabel;
    private JIPAddressTextField ipAddressTextField;
    private JLabel subnetMaskLabel;
    private JIPAddressTextField subnetMaskTextField;
    private JLabel defaultGatewayLabel;
    private JIPAddressTextField defaultGatewayTextField;
    private JBasicRadioButton dhcpDNSRadioButton;
    private JBasicRadioButton useDNSRadioButton;
    private JLabel preferredDNSLabel;
    private JIPAddressTextField preferredDNSTextField;
    private JLabel alternateDNSLabel;
    private JIPAddressTextField alternateDNSTextField;
    private JBasicCheckBox showIconCheckBox;

    public JIPPropertyPanel() {
        this.add(new IPAddressPanel());
        this.add(new DNSPanel());
        this.add(new ShowIconPanel());
        DimensionManager.setDimension(this, new Dimension(425, 350));
    }

    public String getIPAddress() {
        return this.ipAddressTextField.getIPAddress();
    }

    public void setIPAddress(String ipAddress) {
        this.ipAddressTextField.setIPAddress(ipAddress);
    }

    public String getSubnetMask() {
        return this.subnetMaskTextField.getIPAddress();
    }

    public void setSubnetMask(String subnetMask) {
        this.subnetMaskTextField.setIPAddress(subnetMask);
    }

    public String getDefaultGateway() {
        return this.defaultGatewayTextField.getIPAddress();
    }

    public void setDefaultGateway(String defaultGateway) {
        this.defaultGatewayTextField.setIPAddress(defaultGateway);
    }

    public String getPreferredDNS() {
        return this.preferredDNSTextField.getIPAddress();
    }

    public void setPreferredDNS(String preferredDNS) {
        this.preferredDNSTextField.setIPAddress(preferredDNS);
    }

    public String getAlternateDNS() {
        return this.alternateDNSTextField.getIPAddress();
    }

    public void setAlternateDNS(String alternateDNS) {
        this.alternateDNSTextField.setIPAddress(alternateDNS);
    }

    public void setIconShown(boolean isIconShown) {
        this.showIconCheckBox.setSelected(isIconShown);
    }

    public boolean isIconShown() {
        return this.showIconCheckBox.isSelected();
    }

    public class ShowIconPanel
    extends JPanel {
        public ShowIconPanel() {
            JIPPropertyPanel.this.showIconCheckBox = new JBasicCheckBox(SwingLocale.getString("show_icon"), SwingLocale.getString("show_icon"));
            JIPPropertyPanel.this.showIconCheckBox.setPreferredSize(new Dimension(410, 22));
            this.add(JIPPropertyPanel.this.showIconCheckBox);
            this.setPreferredSize(new Dimension(410, 24));
        }
    }

    public class DNSItemLister
    implements ItemListener {
        @Override
        public void itemStateChanged(ItemEvent e) {
            JBasicRadioButton radioButton = (JBasicRadioButton)e.getSource();
            JIPPropertyPanel.this.preferredDNSLabel.setEnabled(radioButton.isSelected());
            JIPPropertyPanel.this.preferredDNSTextField.setEnabled(radioButton.isSelected());
            JIPPropertyPanel.this.alternateDNSLabel.setEnabled(radioButton.isSelected());
            JIPPropertyPanel.this.alternateDNSTextField.setEnabled(radioButton.isSelected());
        }
    }

    public class DNSPanel
    extends JPanel {
        public DNSPanel() {
            JIPPropertyPanel.this.dhcpDNSRadioButton = new JBasicRadioButton(SwingLocale.getString("dhcp_dns_server_address"));
            JIPPropertyPanel.this.dhcpDNSRadioButton.setPreferredSize(new Dimension(170, 22));
            JIPPropertyPanel.this.dhcpDNSRadioButton.setEnabled(false);
            JIPPropertyPanel.this.useDNSRadioButton = new JBasicRadioButton(SwingLocale.getString("use_dns_server_address"), true);
            JIPPropertyPanel.this.useDNSRadioButton.setPreferredSize(new Dimension(205, 22));
            JIPPropertyPanel.this.useDNSRadioButton.addItemListener(new DNSItemLister());
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(JIPPropertyPanel.this.dhcpDNSRadioButton);
            buttonGroup.add(JIPPropertyPanel.this.useDNSRadioButton);
            JIPPropertyPanel.this.preferredDNSLabel = new JLabel(SwingLocale.getString("preferred_dns_server"));
            JIPPropertyPanel.this.preferredDNSLabel.setPreferredSize(new Dimension(120, 22));
            JIPPropertyPanel.this.preferredDNSTextField = new JIPAddressTextField();
            JIPPropertyPanel.this.preferredDNSTextField.setPreferredSize(new Dimension(245, 22));
            JIPPropertyPanel.this.alternateDNSLabel = new JLabel(SwingLocale.getString("alternate_dns_server"));
            JIPPropertyPanel.this.alternateDNSLabel.setPreferredSize(new Dimension(120, 22));
            JIPPropertyPanel.this.alternateDNSTextField = new JIPAddressTextField();
            JIPPropertyPanel.this.alternateDNSTextField.setPreferredSize(new Dimension(245, 22));
            this.setBorder(BorderFactory.createTitledBorder(SwingLocale.getString("dns_config")));
            this.setPreferredSize(new Dimension(410, 120));
            this.add(JIPPropertyPanel.this.dhcpDNSRadioButton);
            this.add(JIPPropertyPanel.this.useDNSRadioButton);
            this.add(JIPPropertyPanel.this.preferredDNSLabel);
            this.add(JIPPropertyPanel.this.preferredDNSTextField);
            this.add(JIPPropertyPanel.this.alternateDNSLabel);
            this.add(JIPPropertyPanel.this.alternateDNSTextField);
        }
    }

    public class IPAddressItemLister
    implements ItemListener {
        @Override
        public void itemStateChanged(ItemEvent e) {
            JBasicRadioButton radioButton = (JBasicRadioButton)e.getSource();
            JIPPropertyPanel.this.ipAddressLabel.setEnabled(radioButton.isSelected());
            JIPPropertyPanel.this.ipAddressTextField.setEnabled(radioButton.isSelected());
            JIPPropertyPanel.this.subnetMaskLabel.setEnabled(radioButton.isSelected());
            JIPPropertyPanel.this.subnetMaskTextField.setEnabled(radioButton.isSelected());
            JIPPropertyPanel.this.defaultGatewayLabel.setEnabled(radioButton.isSelected());
            JIPPropertyPanel.this.defaultGatewayTextField.setEnabled(radioButton.isSelected());
            JIPPropertyPanel.this.dhcpDNSRadioButton.setEnabled(!radioButton.isSelected());
            if (radioButton.isSelected()) {
                JIPPropertyPanel.this.useDNSRadioButton.setSelected(true);
            } else {
                JIPPropertyPanel.this.useDNSRadioButton.setEnabled(true);
            }
        }
    }

    public class IPAddressPanel
    extends JPanel {
        public IPAddressPanel() {
            JIPPropertyPanel.this.dhcpIPAddressRadioButton = new JBasicRadioButton(SwingLocale.getString("dhcp_ip_address"));
            JIPPropertyPanel.this.dhcpIPAddressRadioButton.setPreferredSize(new Dimension(170, 22));
            JIPPropertyPanel.this.useIPAddressRadioButton = new JBasicRadioButton(SwingLocale.getString("use_ip_address"), true);
            JIPPropertyPanel.this.useIPAddressRadioButton.setPreferredSize(new Dimension(205, 22));
            JIPPropertyPanel.this.useIPAddressRadioButton.addItemListener(new IPAddressItemLister());
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(JIPPropertyPanel.this.dhcpIPAddressRadioButton);
            buttonGroup.add(JIPPropertyPanel.this.useIPAddressRadioButton);
            JIPPropertyPanel.this.ipAddressLabel = new JLabel(SwingLocale.getString("ip_address"));
            JIPPropertyPanel.this.ipAddressLabel.setPreferredSize(new Dimension(120, 22));
            JIPPropertyPanel.this.ipAddressTextField = new JIPAddressTextField();
            JIPPropertyPanel.this.ipAddressTextField.setPreferredSize(new Dimension(245, 22));
            JIPPropertyPanel.this.subnetMaskLabel = new JLabel(SwingLocale.getString("subnet_mask"));
            JIPPropertyPanel.this.subnetMaskLabel.setPreferredSize(new Dimension(120, 22));
            JIPPropertyPanel.this.subnetMaskTextField = new JIPAddressTextField();
            JIPPropertyPanel.this.subnetMaskTextField.setPreferredSize(new Dimension(245, 22));
            JIPPropertyPanel.this.defaultGatewayLabel = new JLabel(SwingLocale.getString("default_gateway"));
            JIPPropertyPanel.this.defaultGatewayLabel.setPreferredSize(new Dimension(120, 22));
            JIPPropertyPanel.this.defaultGatewayTextField = new JIPAddressTextField();
            JIPPropertyPanel.this.defaultGatewayTextField.setPreferredSize(new Dimension(245, 22));
            this.setBorder(BorderFactory.createTitledBorder(SwingLocale.getString("ip_config")));
            this.setPreferredSize(new Dimension(410, 147));
            this.add(JIPPropertyPanel.this.dhcpIPAddressRadioButton);
            this.add(JIPPropertyPanel.this.useIPAddressRadioButton);
            this.add(JIPPropertyPanel.this.ipAddressLabel);
            this.add(JIPPropertyPanel.this.ipAddressTextField);
            this.add(JIPPropertyPanel.this.subnetMaskLabel);
            this.add(JIPPropertyPanel.this.subnetMaskTextField);
            this.add(JIPPropertyPanel.this.defaultGatewayLabel);
            this.add(JIPPropertyPanel.this.defaultGatewayTextField);
        }
    }
}

