/*
 * Decompiled with CFR 0.152.
 */
package twaver.web.svg.network.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import javax.swing.ImageIcon;
import twaver.Element;
import twaver.TUIManager;
import twaver.TWaverConst;
import twaver.TWaverUtil;
import twaver.base.A.D.H;
import twaver.base.A.H.I;
import twaver.web.WebUtil;
import twaver.web.svg.network.SVGContext;
import twaver.web.svg.network.SVGStruct;
import twaver.web.svg.network.TSVGNetwork;
import twaver.web.svg.network.ui.ElementSVGUI;
import twaver.web.svg.network.ui.SVGAttachment;

public abstract class SVGComponentAttachment
implements SVGAttachment {
    public static final String SVGATTACHEMENTCLOSED = "element.svg.attachement.closed";
    public static final String SVGATTACHEMENTMINIED = "element.svg.attachement.minied";
    public static final String CLOSEURL = TUIManager.getString("message.close.url");
    public static final String MINIURL = TUIManager.getString("message.minimize.url");
    private String C = TUIManager.getString("web.component.attachment.minimizedicon.url");
    private String G;
    private Element I;
    private TSVGNetwork J;
    private ElementSVGUI W;
    private static final int h = 9;
    private static final int d = 9;
    public static final int SHOW = 1;
    public static final int CLOSE = 2;
    public static final int SHRINK = 3;
    public static final int MINIMIZE = 4;
    private int i = 15;
    private int S = 15;
    private int c = 1;
    private int D = 2;
    private boolean E = false;
    private Rectangle U = null;
    private Shape L = null;
    private int A = 100;
    private int B = 100;
    private int R = 0;
    private int T = 0;
    private int Z = 3;
    private boolean _ = false;
    private Color g = TWaverConst.COLOR_SHADOW;
    private Shape b = null;
    private int K = 3;
    private boolean M = true;
    private Color V = Color.BLACK;
    private Stroke a = TWaverConst.BASIC_STROKE;
    private boolean H = true;
    private Color Q = TWaverConst.COLOR_IVORY;
    private boolean O = false;
    private Color Y = Color.WHITE;
    private int f = 5;
    private boolean j = false;
    private boolean X = true;
    private boolean F = false;
    private double P = 0.0;
    private double N = 0.0;
    private float e = 1.0f;

    public SVGComponentAttachment(String name, ElementSVGUI ui) {
        this.G = name;
        this.I = ui.getElement();
        this.J = ui.getNetwork();
        this.W = ui;
    }

    public Element getElement() {
        return this.I;
    }

    public TSVGNetwork getNetwork() {
        return this.J;
    }

    public ElementSVGUI getSVGUI() {
        return this.W;
    }

    public boolean isClosed(Element element) {
        Boolean value = (Boolean)element.getClientProperty(SVGATTACHEMENTCLOSED);
        if (value == null) {
            return false;
        }
        return value;
    }

    public boolean isMinimzied(Element element) {
        Boolean value = (Boolean)element.getClientProperty(SVGATTACHEMENTMINIED);
        if (value == null) {
            return false;
        }
        return value;
    }

    public SVGStruct toSVG(SVGContext context) {
        String contentSVG;
        if (this.isClosed(this.I)) {
            return SVGStruct.EMPTY;
        }
        int width = this.getContentSize().width;
        int height = this.getContentSize().height;
        StringBuffer sb = new StringBuffer();
        ImageIcon minIcon = TWaverUtil.getImageIcon(this.C);
        int ih = minIcon.getIconHeight();
        int iw = minIcon.getIconWidth();
        if (this.isMinimzied(this.I)) {
            Point peakPoint = twaver.base.A.H.I.A(this.J, context, this.I, new Dimension(iw, ih), this.Z, this.R, this.T);
            twaver.base.A.H.I.A(context, sb, " attIcon='max'", this.C, null, peakPoint.x, peakPoint.y);
            return new SVGStruct(sb.toString(), new Rectangle(iw, ih));
        }
        Point peakPoint = twaver.base.A.H.I.A(this.J, context, this.I, TWaverConst.EMPTY_DIMENSION, this.Z, this.R, this.T);
        H struct = null;
        struct = this.c == 1 ? new H(peakPoint, width, height, this.D, 0, 0, this.E) : new H(peakPoint, width, height, this.D, this.S, this.i, this.E);
        this.L = struct.B;
        Rectangle shapeBounds = struct.A;
        this.P = shapeBounds.getX();
        this.N = shapeBounds.getY();
        this.b = AffineTransform.getTranslateInstance(this.K, this.K).createTransformedShape(this.L);
        if (this._) {
            twaver.base.A.H.I.A(context, sb, (Shape)shapeBounds, (Object)this.g, null, null, this.e, 0.0, null);
        }
        if (this.H) {
            if (this.O) {
                String gradientID = this.getGradientID(context, this.f, this.Y, this.Q);
                twaver.base.A.H.I.A(context, sb, this.L, (Object)gradientID, null, null, this.e, 0.0, null);
            } else {
                twaver.base.A.H.I.A(context, sb, this.L, (Object)this.Q, null, null, this.e, 0.0, null);
            }
        }
        if (this.M) {
            twaver.base.A.H.I.A(context, sb, this.L, this.V, this.a);
        }
        if ((contentSVG = this.getContentSVG(this.P, this.N)) != null) {
            sb.append("<g");
            twaver.base.A.H.I.C(sb);
            sb.append(">");
            sb.append(contentSVG);
            sb.append("</g>");
        }
        this.A(context, sb, shapeBounds);
        return new SVGStruct(sb.toString(), new Rectangle(width, height));
    }

    private void A(SVGContext context, StringBuffer sb, Rectangle contentSize) {
        int iconX = contentSize.x + contentSize.width - 9 - 2;
        int iconY = contentSize.y + 2;
        if (this.c == 2) {
            iconX += this.S;
        }
        if (this.j) {
            twaver.base.A.H.I.A(context, sb, " attIcon='close'", CLOSEURL, null, iconX, iconY);
            iconY += 10;
        }
        if (this.X) {
            twaver.base.A.H.I.A(context, sb, " attIcon='min'", MINIURL, null, iconX, iconY);
            iconY += 10;
        }
    }

    protected String getGradientID(SVGContext context, int type, Color gradientColor, Color fillColor) {
        String id = WebUtil.getGradientID(type, gradientColor, fillColor);
        if (id != null) {
            context.registerGradientID(id);
        }
        return id;
    }

    public abstract String getContentSVG(double var1, double var3);

    public Rectangle getContentSize() {
        return new Rectangle(this.A, this.B);
    }

    public void setSize(Dimension size) {
        this.A = size.width;
        this.B = size.height;
    }

    public Dimension getSize() {
        return new Dimension(this.A, this.B);
    }

    public String getMinimizedIconURL() {
        return this.C;
    }

    public void setMinimizedIconURL(String minimizedIconURL) {
        this.C = minimizedIconURL;
    }

    public String getName() {
        return this.G;
    }

    public void setName(String name) {
        this.G = name;
    }

    public ElementSVGUI getUi() {
        return this.W;
    }

    public void setUi(ElementSVGUI ui) {
        this.W = ui;
    }

    public int getTail() {
        return this.i;
    }

    public void setTail(int tail) {
        this.i = tail;
    }

    public int getArc() {
        return this.S;
    }

    public void setArc(int arc) {
        this.S = arc;
    }

    public int getStyle() {
        return this.c;
    }

    public void setStyle(int style) {
        this.c = style;
    }

    public int getDirection() {
        return this.D;
    }

    public void setDirection(int direction) {
        this.D = direction;
    }

    public boolean isAutoAdjustDirection() {
        return this.E;
    }

    public void setAutoAdjustDirection(boolean autoAdjustDirection) {
        this.E = autoAdjustDirection;
    }

    public Rectangle getComponentBounds() {
        return this.U;
    }

    public void setComponentBounds(Rectangle componentBounds) {
        this.U = componentBounds;
    }

    public Shape getShape() {
        return this.L;
    }

    public void setShape(Shape shape) {
        this.L = shape;
    }

    public int getWidth() {
        return this.A;
    }

    public void setWidth(int width) {
        this.A = width;
    }

    public int getHeight() {
        return this.B;
    }

    public void setHeight(int height) {
        this.B = height;
    }

    public int getXOffset() {
        return this.R;
    }

    public void setXOffset(int offset) {
        this.R = offset;
    }

    public int getYOffset() {
        return this.T;
    }

    public void setYOffset(int offset) {
        this.T = offset;
    }

    public int getPosition() {
        return this.Z;
    }

    public void setPosition(int position) {
        this.Z = position;
    }

    public boolean isShadowVisible() {
        return this._;
    }

    public void setShadowVisible(boolean shadowVisible) {
        this._ = shadowVisible;
    }

    public Color getShadowColor() {
        return this.g;
    }

    public void setShadowColor(Color shadowColor) {
        this.g = shadowColor;
    }

    public Shape getShadowShape() {
        return this.b;
    }

    public void setShadowShape(Shape shadowShape) {
        this.b = shadowShape;
    }

    public int getShadowOffset() {
        return this.K;
    }

    public void setShadowOffset(int shadowOffset) {
        this.K = shadowOffset;
    }

    public boolean isBorderVisible() {
        return this.M;
    }

    public void setBorderVisible(boolean borderVisible) {
        this.M = borderVisible;
    }

    public Color getBorderColor() {
        return this.V;
    }

    public void setBorderColor(Color borderColor) {
        this.V = borderColor;
    }

    public Stroke getBorderStroke() {
        return this.a;
    }

    public void setBorderStroke(Stroke borderStroke) {
        this.a = borderStroke;
    }

    public boolean isBodyVisible() {
        return this.H;
    }

    public void setBodyVisible(boolean bodyVisible) {
        this.H = bodyVisible;
    }

    public Color getBodyColor() {
        return this.Q;
    }

    public void setBodyColor(Color bodyColor) {
        this.Q = bodyColor;
    }

    public boolean isBodyGradient() {
        return this.O;
    }

    public void setBodyGradient(boolean bodyGradient) {
        this.O = bodyGradient;
    }

    public Color getBodyGradientColor() {
        return this.Y;
    }

    public void setBodyGradientColor(Color bodyGradientColor) {
        this.Y = bodyGradientColor;
    }

    public int getBodyGradientFactory() {
        return this.f;
    }

    public void setBodyGradientFactory(int bodyGradientFactory) {
        this.f = bodyGradientFactory;
    }

    public boolean isClosable() {
        return this.j;
    }

    public void setClosable(boolean closable) {
        this.j = closable;
    }

    public boolean isMinimizable() {
        return this.X;
    }

    public void setMinimizable(boolean minimizable) {
        this.X = minimizable;
    }

    public boolean isMinimized() {
        return this.F;
    }

    public void setMinimized(boolean minimized) {
        this.F = minimized;
    }

    public double getStartX() {
        return this.P;
    }

    public double getStartY() {
        return this.N;
    }

    public void setElement(Element element) {
        this.I = element;
    }

    public void setNetwork(TSVGNetwork network) {
        this.J = network;
    }

    public float getAlpha() {
        return this.e;
    }

    public void setAlpha(float alpha) {
        this.e = alpha;
    }

    public Color getBoundColor() {
        return this.V;
    }

    public void setBoundColor(Color boundColor) {
        this.V = boundColor;
    }

    public void setFillOpacity(float fo) {
        this.e = fo;
    }

    public float getFillOpacity() {
        return this.e;
    }
}

