/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.table;

import com.nepxion.swing.table.ITable;
import com.nepxion.swing.table.TableManager;
import com.nepxion.swing.table.layoutable.TableCellRendererConstants;
import com.nepxion.swing.table.layoutable.TableCellRendererLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class JBasicTable
extends JTable
implements ITable,
TableCellRendererConstants,
MouseListener {
    private int columnWidthGap = 20;
    private int rowHeightGap = -4;
    private boolean isAutoLayout = true;
    private int selectedIndex = -1;

    public JBasicTable() {
        this.initComponents();
    }

    public JBasicTable(TableModel dm) {
        super(dm);
        this.initComponents();
    }

    public JBasicTable(TableModel dm, TableColumnModel cm) {
        super(dm, cm);
        this.initComponents();
    }

    public JBasicTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
        this.initComponents();
    }

    public JBasicTable(int numRows, int numColumns) {
        super(numRows, numColumns);
        this.initComponents();
    }

    public JBasicTable(Vector rowData, Vector columnNames) {
        super(rowData, columnNames);
        this.initComponents();
    }

    public JBasicTable(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
        this.initComponents();
    }

    private void initComponents() {
        TableManager.setPreferenceStyle(this);
        this.addMouseListener(this);
        this.getSelectionModel().addListSelectionListener(this);
        this.setRowSorter();
    }

    @Override
    public void setModel(TableModel tableModel) {
        super.setModel(tableModel);
        TableRowSorter tableRowSorter = (TableRowSorter)this.getRowSorter();
        if (tableRowSorter != null) {
            tableRowSorter.setModel(tableModel);
        }
        tableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (JBasicTable.this.getAutoResizeMode() == 0 && JBasicTable.this.isAutoLayout) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JBasicTable.this.adaptLayout("columnLayoutMode");
                        }
                    });
                }
            }
        });
    }

    @Override
    public void setAutoResizeMode(int mode) {
        super.setAutoResizeMode(mode);
        if (mode == 0) {
            this.adaptLayout("columnLayoutMode");
        }
    }

    @Override
    public int getSelectionMode() {
        return TableManager.getSelectionMode(this);
    }

    @Override
    public void setSelectionMode(int mode) {
        TableManager.setSelectionMode(this, mode);
    }

    @Override
    public TableColumn getColumn(int column) {
        return this.getColumnModel().getColumn(column);
    }

    public void setRowSorter(TableModel tableModel) {
        TableRowSorter<TableModel> tableRowSorter = new TableRowSorter<TableModel>(tableModel);
        this.setRowSorter(tableRowSorter);
    }

    public void setRowSorter() {
        TableModel tableModel = this.getModel();
        this.setRowSorter(tableModel);
    }

    @Override
    public int getRowIndexToModel(int rowIndex) {
        return this.convertRowIndexToModel(rowIndex);
    }

    @Override
    public int[] getRowIndexesToModel(int[] rowIndexes) {
        int[] indexes = new int[rowIndexes.length];
        for (int i = 0; i < rowIndexes.length; ++i) {
            indexes[i] = this.convertRowIndexToModel(rowIndexes[i]);
        }
        return indexes;
    }

    @Override
    public int getColumnWidthGap() {
        return this.columnWidthGap;
    }

    @Override
    public void setColumnWidthGap(int columnWidthGap) {
        this.columnWidthGap = columnWidthGap;
    }

    @Override
    public int getRowHeightGap() {
        return this.rowHeightGap;
    }

    @Override
    public void setRowHeightGap(int rowHeightGap) {
        this.rowHeightGap = rowHeightGap;
    }

    @Override
    public boolean isAutoLayout() {
        return this.isAutoLayout;
    }

    @Override
    public void setAutoLayout(boolean isAutoLayout) {
        this.isAutoLayout = isAutoLayout;
    }

    @Override
    public void adaptLayout(String layoutMode) {
        TableCellRendererLayout layout = new TableCellRendererLayout(this);
        layout.doLayout(new int[]{this.columnWidthGap, this.rowHeightGap}, layoutMode);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        int[] selectedRows = this.getSelectedRows();
        if (selectedRows.length == 0) {
            boolean isAdjusting = e.getValueIsAdjusting();
            if (isAdjusting) {
                if (this.getSelectedRow() == this.selectedIndex) {
                    return;
                }
                this.selectedIndex = this.getSelectedRow();
                this.executeSelection(this.selectedIndex);
            }
        } else {
            if (this.getSelectedRow() == this.selectedIndex) {
                return;
            }
            this.selectedIndex = this.getSelectedRow();
            this.executeSelection(this.selectedIndex);
        }
    }

    @Override
    public void executeSelection(int selectedRow) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int selectedRow = this.getSelectedRow();
        this.executeClicked(selectedRow, e);
    }

    public void executeClicked(int selectedRow, MouseEvent e) {
        if (e.getClickCount() > 1) {
            this.executeDoubleClicked(selectedRow);
        } else {
            this.executeClicked(selectedRow);
        }
    }

    @Override
    public void executeClicked(int selectedRow) {
    }

    @Override
    public void executeDoubleClicked(int selectedRow) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!e.isPopupTrigger()) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        int selectedRow = this.getSelectedRow();
        if (selectedRow > -1) {
            this.executePopupMenu(selectedRow, x, y);
        } else {
            this.executePopupMenu(x, y);
        }
    }

    @Override
    public void executePopupMenu(int selectedRow, int x, int y) {
    }

    @Override
    public void executePopupMenu(int x, int y) {
    }
}

