/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.searcher.ip.local;

import com.nepxion.swing.action.JSecurityAction;
import com.nepxion.swing.handle.HandleManager;
import com.nepxion.swing.icon.IconFactory;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.optionpane.JBasicOptionPane;
import com.nepxion.swing.searcher.ip.local.AddressTableModel;
import com.nepxion.swing.searcher.ip.local.JAddressPanel;
import com.nepxion.swing.searcher.ip.local.JAddressTable;
import com.nepxion.swing.thread.dialog.JThreadDialog;
import com.nepxion.util.searcher.ip.local.IPSearcher;
import java.awt.event.ActionEvent;
import java.util.List;

public class AddressController {
    public static JSecurityAction getSearchAction(final JAddressPanel panel) {
        JSecurityAction action = new JSecurityAction(SwingLocale.getString("query"), IconFactory.getSwingIcon("stereo_search.png"), SwingLocale.getString("ip_to_address")){

            @Override
            public void execute(ActionEvent e) {
                JThreadDialog dialog = new JThreadDialog(HandleManager.getFrame(panel), SwingLocale.getString("ip_to_address"), SwingLocale.getString("query_and_wait")){

                    @Override
                    protected void loadForeground(Object data) throws Exception {
                        List entityList = (List)data;
                        if (entityList == null || entityList.isEmpty()) {
                            JBasicOptionPane.showMessageDialog(HandleManager.getFrame(panel), SwingLocale.getString("no_records"), SwingLocale.getString("warning"), 2);
                            return;
                        }
                        AddressTableModel tableModel = (AddressTableModel)panel.getAddressTable().getModel();
                        tableModel.setRowDatas(entityList);
                        panel.setCount(entityList.size());
                    }

                    @Override
                    protected Object loadBackground() throws Exception {
                        String address = panel.getAddress();
                        IPSearcher searcher = IPSearcher.getInstance();
                        List entityList = searcher.getIPEntityList(address);
                        return entityList;
                    }
                };
                dialog.execute();
            }
        };
        return action;
    }

    public static JSecurityAction getClearAction(final JAddressTable table) {
        JSecurityAction action = new JSecurityAction(SwingLocale.getString("clear"), IconFactory.getSwingIcon("stereo/delete_16.png"), SwingLocale.getString("clear_query_result")){

            @Override
            public void execute(ActionEvent e) {
                int selectedValue = JBasicOptionPane.showConfirmDialog(HandleManager.getFrame(table), SwingLocale.getString("confirm_to_clear_query_result"), SwingLocale.getString("confirm"), 0);
                if (selectedValue != 0) {
                    return;
                }
                AddressTableModel tableModel = (AddressTableModel)table.getModel();
                tableModel.clearRows();
            }
        };
        return action;
    }
}

