/*
 * Decompiled with CFR 0.152.
 */
package twaver.network.ui;

import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import twaver.Element;
import twaver.network.TNetwork;
import twaver.network.ui.Attachment;
import twaver.network.ui.ElementUI;

public abstract class AbstractAttachment
implements Attachment {
    protected ElementUI ui = null;
    protected Element element = null;
    protected TNetwork network = null;

    public AbstractAttachment(ElementUI ui) {
        this.ui = ui;
        this.element = ui.getElement();
        this.network = ui.getNetwork();
    }

    public ElementUI getElementUI() {
        return this.ui;
    }

    public boolean contains(int x, int y) {
        Shape shape = this.getShape();
        if (shape != null) {
            return shape.contains(x, y);
        }
        return false;
    }

    public void performAction(int gesture, MouseEvent e2) {
        if (this.network.isEnableAttachmentDefaultAction()) {
            this.ui.performAction(gesture, e2);
        }
    }

    public boolean isSelectable() {
        return true;
    }

    public Shape getShape() {
        return this.getBounds();
    }

    public void elementPropertyChange(PropertyChangeEvent evt) {
    }

    public String getName() {
        return null;
    }

    public boolean isShownOnTop() {
        return false;
    }
}

