/*
 * Decompiled with CFR 0.152.
 */
package twaver.network.inputhandler;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import twaver.TWaverUtil;
import twaver.base.A.E.m;
import twaver.network.InteractionEvent;
import twaver.network.TNetwork;
import twaver.network.inputhandler.AbstractMoveInputHandler;

public class LazyMoveInputHandler
extends AbstractMoveInputHandler {
    protected Rectangle sourceBounds = null;
    protected Rectangle2D.Double movingBounds = null;

    public LazyMoveInputHandler(TNetwork network) {
        super(network);
    }

    protected void dragProcess(MouseEvent e2, double xOffset, double yOffset) {
        this.E();
        this.network.adjustCanvasSize(e2.getPoint());
        this.movingBounds.x += xOffset;
        this.movingBounds.y += yOffset;
        this.E();
        this.network.fireInteractionPerformed(this.network.getDataBox().getSelectionModel(), 4, e2);
    }

    protected void releaseProcess(final MouseEvent e2, double xf, double yf) {
        if (this.sourceBounds != null) {
            this.E();
            final double xOffset = this.movingBounds.x - (double)this.sourceBounds.x;
            final double yOffset = this.movingBounds.y - (double)this.sourceBounds.y;
            if (Math.sqrt(xOffset * xOffset + yOffset * yOffset) >= (double)this.network.getDragCriticalValue()) {
                this.network.getDataBox().getUndoRedoManager().setIgnorePropertyChange(true);
                if (!this.network.isAnimateElementMove()) {
                    this.network.moveSelectedElements(xOffset, yOffset);
                    this.network.fireInteractionPerformed(this.network.getDataBox().getSelectionModel(), 5, e2);
                    this.network.getDataBox().getUndoRedoManager().setIgnorePropertyChange(false);
                    this.fireBatchMoveEvent(xOffset, yOffset);
                } else {
                    Runnable r = new Runnable(){

                        public void run() {
                            LazyMoveInputHandler.this.network.fireInteractionPerformed(LazyMoveInputHandler.this.network.getDataBox().getSelectionModel(), 5, e2);
                            LazyMoveInputHandler.this.network.getDataBox().getUndoRedoManager().setIgnorePropertyChange(false);
                            LazyMoveInputHandler.this.fireBatchMoveEvent(xOffset, yOffset);
                        }
                    };
                    this.network.moveSelectedElements(xOffset, yOffset, r, -1, -1);
                }
            }
            this.sourceBounds = null;
            this.movingBounds = null;
        }
    }

    public void keyPressed(KeyEvent e2) {
        super.keyPressed(e2);
        if (e2.getKeyCode() == 27 && this.sourceBounds != null) {
            this.E();
            m.A(this.network, false, this);
            this.mousePressedPoint = null;
            this.mouseDragPoint = null;
            this.sourceBounds = null;
            this.movingBounds = null;
            InteractionEvent event = new InteractionEvent((Object)this.network.getDataBox().getSelectionModel(), 12);
            this.network.fireInteractionPerformed(event);
        }
    }

    protected Rectangle getSelectionBounds() {
        if (this.sourceBounds == null) {
            Rectangle selectionBounds = this.getElementBounds();
            this.sourceBounds = (Rectangle)selectionBounds.clone();
            this.movingBounds = new Rectangle2D.Double(this.sourceBounds.x, this.sourceBounds.y, this.sourceBounds.width, this.sourceBounds.height);
            this.E();
        }
        return this.movingBounds.getBounds();
    }

    private void E() {
        this.network.getRenderer().repaintLogicalBounds(this.movingBounds.getBounds());
    }

    public void mark(Graphics2D g2) {
        TWaverUtil.drawDashRectangle(g2, this.movingBounds.getBounds(), 1.0);
        super.mark(g2);
    }

    protected boolean isDraggable(int distance) {
        return true;
    }
}

