/*
 * Decompiled with CFR 0.152.
 */
package twaver.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import twaver.Element;
import twaver.TDataBox;
import twaver.TUIManager;
import twaver.TWaverConst;
import twaver.base.A.D.O;
import twaver.base.A.E.D;
import twaver.base.A.E.a;
import twaver.base.A.E.d;
import twaver.base.A.F.A.A;
import twaver.chart.AbstractChart;
import twaver.chart.C;
import twaver.chart.Marker;
import twaver.web.svg.chart.AbstractSVGChart;
import twaver.web.svg.chart.SVGDialChart;
import twaver.web.svg.network.SVGContext;

public class DialChart
extends AbstractChart {
    private boolean \u049c = TUIManager.getBoolean("tchart.dial.scale.inside");
    private int \u0472 = TUIManager.getInt("tchart.dial.scale.major.count");
    private int \u049e = TUIManager.getInt("tchart.dial.scale.minor.count");
    private boolean \u0490 = TUIManager.getBoolean("tchart.dial.scale.minor.visible");
    private double \u049a = TUIManager.getDouble("tchart.dial.scale.length");
    private String \u04a0 = TUIManager.getString("tchart.dial.scale.stroke");
    private Font \u0492 = TUIManager.getFont("tchart.dial.scale.text.font");
    private Color \u047d = TUIManager.getColor("tchart.dial.scale.color");
    private boolean \u0476 = TUIManager.getBoolean("tchart.dial.scale.text.visible");
    private double \u0477 = TUIManager.getDouble("tchart.dial.start.angle");
    private double \u04a1 = TUIManager.getDouble("tchart.dial.end.angle");
    private double \u047c = TUIManager.getDouble("tchart.dial.max.value");
    private double \u0470 = TUIManager.getDouble("tchart.dial.min.value");
    private String \u047e = TUIManager.getString("tchart.dial.ring.stroke");
    private Color \u0491 = TUIManager.getColor("tchart.dial.ring.color");
    private Color \u047b = TUIManager.getColor("tchart.dial.ring.fill.color");
    private Color \u0494 = TUIManager.getColor("tchart.dial.ring.border.color");
    private Color \u0499 = TUIManager.getColor("tchart.dial.ball.color");
    private Color \u0479 = TUIManager.getColor("tchart.dial.ball.border.color");
    private double \u0475 = TUIManager.getDouble("tchart.dial.ball.size");
    private int \u0497 = TUIManager.getInt("tchart.dial.scale.style");
    private boolean \u0473 = TUIManager.getBoolean("tchart.dial.ring.border.visible");
    private boolean \u049d = TUIManager.getBoolean("tchart.dial.ring.gradient");
    private boolean \u0480 = TUIManager.getBoolean("tchart.dial.ball.gradient");
    private int \u0471 = TUIManager.getInt("tchart.dial.ring.gradient.factory");
    private int \u0496 = TUIManager.getInt("tchart.dial.ball.gradient.factory");
    private Color \u0495 = TUIManager.getColor("tchart.dial.ring.gradient.color");
    private Color \u049b = TUIManager.getColor("tchart.dial.ball.gradient.color");
    private boolean \u04a5 = TUIManager.getBoolean("tchart.dial.scale.mintext.visible");
    private Color \u049f = TUIManager.getColor("tchart.dial.scale.text.color");
    private int \u0481 = TUIManager.getInt("tchart.dial.type");
    private double \u04a3 = TUIManager.getDouble("tchart.dial.arcrange");
    private double \u0474 = TUIManager.getDouble("tchart.dial.ball.percent.size");
    private Rectangle \u047a;
    private double \u0498;
    private double \u047f;
    private List \u04a4 = new ArrayList();
    private double \u0478 = Math.PI / 180;
    private double \u04a2 = 0.08;
    private double \u0493 = 0.08;

    public DialChart() {
        this(new TDataBox());
    }

    public DialChart(TDataBox box) {
        this(box, null, null);
    }

    public DialChart(TDataBox box, String title, Color backgroundColor) {
        this(box, title, backgroundColor, null);
    }

    public DialChart(TDataBox box, String title, Color backgroundColor, Color foregroundColor) {
        super(box, title, backgroundColor, foregroundColor);
    }

    public DialChart(List items) {
        super(items);
    }

    public DialChart(List items, String title) {
        super(items, title);
    }

    public DialChart(List items, String title, Color backgroundColor) {
        super(items, title, backgroundColor);
    }

    protected void calculate() {
        this.\u0498 = this.\u047c - this.\u0470;
        this.\u047f = this.\u04a1 - this.\u0477;
        if (this.\u0481 == 2) {
            this.\u047f = this.\u04a3;
            this.\u0477 = 90.0 + (360.0 - this.\u04a3) / 2.0;
        }
    }

    public DialChart(List items, String title, Color backgroundColor, Color foregroundColor) {
        super(items, title, backgroundColor, foregroundColor);
    }

    public void paintChart(Graphics2D g2d, int width, int height) {
        g2d.setStroke(TWaverConst.BASIC_STROKE);
        this.backgroundBounds.x = this.xGap;
        this.backgroundBounds.y = this.yGap;
        this.backgroundBounds.width = width - 2 * this.xGap;
        this.backgroundBounds.height = height - 2 * this.yGap;
        this.paintBackground(g2d);
        if (this.\u0481 == 2) {
            this.C(g2d, width, height);
        } else {
            this.D(g2d, width, height);
        }
        this.G(g2d);
        this.F(g2d);
        this.E(g2d);
    }

    private void C(Graphics2D g2d, int width, int height) {
        double r;
        double widthMaxR;
        Dimension dim = this.B(this.\u047c + "", this.\u0492);
        double centerX = width / 2;
        double centerY = 0.0;
        if (this.\u04a3 > 180.0) {
            widthMaxR = ((double)(width - 2 * this.xGap - 2 * dim.width) - 2.0 * this.\u049a) / 2.0;
            double heightMaxRr = ((double)(height - 2 * this.yGap - 2 * dim.height) - 2.0 * this.\u049a) / (1.0 + Math.cos((360.0 - this.\u04a3) / 2.0 * this.\u0478));
            if (this.\u049c) {
                widthMaxR = (width - 2 * this.xGap) / 2;
                double ballActualSize = this.\u0475;
                if (this.\u0474 > 0.0) {
                    ballActualSize = (double)height * this.\u0474;
                }
                heightMaxRr = ((double)(height - 2 * this.yGap) - ballActualSize) / (1.0 + Math.cos((360.0 - this.\u04a3) / 2.0 * this.\u0478));
            }
            boolean isUseW = widthMaxR > heightMaxRr;
            double d2 = r = isUseW ? heightMaxRr : widthMaxR;
            if (isUseW) {
                centerY = (double)(this.yGap + dim.height) + r + this.\u049a;
                if (this.\u049c) {
                    centerY = (double)this.yGap + r;
                }
            } else {
                centerY = (double)(height / 2) + (r - r * Math.cos((360.0 - this.\u04a3) / 2.0 * this.\u0478)) / 2.0;
            }
        } else {
            widthMaxR = ((double)(width - 2 * this.xGap - 2 * dim.width) - 2.0 * this.\u049a) / 2.0;
            double ballActualSize = this.\u0475;
            if (this.\u0474 > 0.0) {
                ballActualSize = (double)height * this.\u0474;
            }
            double heightMaxRr = (double)(height - 2 * this.yGap - dim.height) - this.\u049a - ballActualSize;
            if (this.\u049c) {
                widthMaxR = (width - 2 * this.xGap) / 2;
                heightMaxRr = (double)(height - 2 * this.yGap) - ballActualSize;
            }
            boolean isUseW = widthMaxR > heightMaxRr;
            r = isUseW ? heightMaxRr : widthMaxR;
            centerY = isUseW ? (double)(height - this.yGap - dim.height / 2) - (double)height / 2.0 * this.\u0474 : (double)(height / 2) + r / 2.0;
        }
        this.\u047a = new Rectangle((int)(centerX - r), (int)(centerY - r), (int)(2.0 * r), (int)(2.0 * r));
        Arc2D.Double arc = new Arc2D.Double(this.\u047a, -(90.0 + (360.0 - this.\u04a3) / 2.0), -this.\u04a3, 2);
        g2d.setColor(this.\u047b);
        if (this.\u049d) {
            O factory = d.E(this.\u0471);
            Paint paint = factory.A(new Rectangle(this.\u047a.x, this.\u047a.y, this.\u047a.width, height), this.\u0495, this.\u047b);
            g2d.setPaint(paint);
        }
        g2d.fill(arc);
        if (this.\u0473) {
            double subR = r - r / 2.0 * this.\u04a2;
            Rectangle2D.Double rectangle = new Rectangle2D.Double(this.\u047a.getCenterX() - subR, this.\u047a.getCenterY() - subR, 2.0 * subR, 2.0 * subR);
            Arc2D.Double subArc = new Arc2D.Double(rectangle, -(90.0 + (360.0 - this.\u04a3) / 2.0), -this.\u04a3, 2);
            Area area = new Area(arc);
            area.subtract(new Area(subArc));
            g2d.setColor(this.\u0494);
            g2d.fill(area);
        }
        g2d.setColor(this.\u0491);
        g2d.setStroke(TUIManager.getStrokeByType(this.\u047e));
        if (this.\u04a3 != 0.0 && this.\u04a3 % 360.0 == 0.0) {
            Ellipse2D.Double ell = new Ellipse2D.Double((int)(centerX - r), (int)(centerY - r), (int)(2.0 * r), (int)(2.0 * r));
            g2d.draw(ell);
        } else {
            g2d.draw(arc);
        }
    }

    private void D(Graphics2D g2d, int width, int height) {
        double widthLen = (double)(width - 2 * this.xGap) / 2.0;
        double heightLen = (double)(height - 2 * this.yGap) / 2.0;
        if (this.\u049c) {
            Rectangle widthR = D.A(this.xGap, (double)this.yGap + heightLen - widthLen, (double)this.xGap + widthLen * 2.0, (double)this.yGap + heightLen - widthLen + widthLen * 2.0);
            Rectangle heightR = D.A((double)this.xGap + widthLen - heightLen, this.yGap, (double)this.xGap + widthLen - heightLen + heightLen * 2.0, (double)this.yGap + heightLen * 2.0);
            this.\u047a = widthLen < heightLen ? widthR : heightR;
        } else {
            Dimension dim = this.B(this.\u047c + "", this.\u0492);
            double widthR = widthLen - this.\u049a - dim.getWidth();
            double heightR = heightLen - this.\u049a - dim.getHeight();
            double r = heightLen > widthLen ? widthR : heightR;
            this.\u047a = D.A((double)this.xGap + widthLen - r, (double)this.yGap + heightLen - r, (double)this.xGap + widthLen + r, (double)this.yGap + heightLen + r);
        }
        Ellipse2D.Double ellip = new Ellipse2D.Double(this.\u047a.getX(), this.\u047a.getY(), this.\u047a.getWidth(), this.\u047a.getHeight());
        g2d.setColor(this.\u047b);
        if (this.\u049d) {
            O factory = d.E(this.\u0471);
            Paint paint = factory.A(new Rectangle(this.\u047a.x, this.\u047a.y, this.\u047a.width, this.\u047a.height), this.\u0495, this.\u047b);
            g2d.setPaint(paint);
        }
        g2d.fill(ellip);
        if (this.\u0473) {
            double centerX = ellip.getCenterX();
            double centerY = ellip.getCenterY();
            double eWidth = ellip.getWidth() - this.\u047a.getWidth() / 2.0 * this.\u04a2;
            double eHeight = ellip.getHeight() - this.\u047a.getWidth() / 2.0 * this.\u04a2;
            Ellipse2D.Double ellipse = new Ellipse2D.Double(centerX - eWidth / 2.0, centerY - eHeight / 2.0, eWidth, eHeight);
            Arc2D.Double pie = new Arc2D.Double(this.\u047a.getX(), this.\u047a.getY(), this.\u047a.getWidth(), this.\u047a.getHeight(), 0.0, 360.0, 2);
            Area area = new Area(pie);
            area.subtract(new Area(ellipse));
            g2d.setColor(this.\u0494);
            g2d.fill(area);
        }
        g2d.setColor(this.\u0491);
        g2d.setStroke(TUIManager.getStrokeByType(this.\u047e));
        g2d.draw(ellip);
    }

    private void F(Graphics2D g2d) {
        double averageAngle = this.\u047f / (double)this.\u0472;
        double r = this.\u047a.getWidth() / 2.0;
        Point2D.Double point = new Point2D.Double(this.\u047a.getX() + this.\u047a.getWidth() / 2.0, this.\u047a.getY() + this.\u047a.getHeight() / 2.0);
        g2d.setColor(this.\u047d);
        for (int i2 = 0; i2 <= this.\u0472; ++i2) {
            g2d.setStroke(TUIManager.getStrokeByType(this.\u04a0));
            double angel = this.\u0477 + averageAngle * (double)i2;
            double endx = point.getX() + r * Math.cos(angel * this.\u0478);
            double endy = point.getY() + r * Math.sin(angel * this.\u0478);
            double startx = point.getX() + (this.\u049c ? r - this.\u049a : r + this.\u049a) * Math.cos(angel * this.\u0478);
            double starty = point.getY() + (this.\u049c ? r - this.\u049a : r + this.\u049a) * Math.sin(angel * this.\u0478);
            if (this.\u0497 == 1) {
                Line2D.Double li = new Line2D.Double(startx, starty, endx, endy);
                g2d.draw(li);
            } else if (this.\u0497 == 2) {
                double ellx = (startx + endx) / 2.0 - this.\u049a / 2.0;
                double elly = (starty + endy) / 2.0 - this.\u049a / 2.0;
                Ellipse2D.Double ed = new Ellipse2D.Double(ellx, elly, this.\u049a, this.\u049a);
                g2d.fill(ed);
            }
            if (this.\u0490 && i2 != this.\u0472) {
                int temp = this.\u049e + 1;
                for (int j2 = 0; j2 < this.\u049e; ++j2) {
                    double minangle = angel + averageAngle / (double)temp * (double)(j2 + 1);
                    double minEndx = point.getX() + r * Math.cos(minangle * this.\u0478);
                    double minEndy = point.getY() + r * Math.sin(minangle * this.\u0478);
                    double percent = 2.0;
                    if ((double)this.\u049e % 2.0 != 0.0 && j2 == this.\u049e / 2) {
                        percent = 1.5;
                    }
                    double minStartx = point.getX() + (this.\u049c ? r - this.\u049a / percent : r + this.\u049a / percent) * Math.cos(minangle * this.\u0478);
                    double minStarty = point.getY() + (this.\u049c ? r - this.\u049a / percent : r + this.\u049a / percent) * Math.sin(minangle * this.\u0478);
                    Shape shape = null;
                    if (this.\u0497 == 1) {
                        shape = new Line2D.Double(minStartx, minStarty, minEndx, minEndy);
                        g2d.draw(shape);
                        continue;
                    }
                    if (this.\u0497 != 2) continue;
                    double ellx = (minStartx + minEndx) / 2.0 - this.\u049a / (2.0 * percent);
                    double elly = (minStarty + minEndy) / 2.0 - this.\u049a / (2.0 * percent);
                    shape = new Ellipse2D.Double(ellx, elly, this.\u049a / percent, this.\u049a / percent);
                    g2d.fill(shape);
                }
            }
            if (!this.\u0476 || i2 == 0 && !this.\u04a5) continue;
            String text = this.getScaleValueText(i2, this.\u0498, this.\u0472);
            Dimension dim = this.B(text, this.\u0492);
            double scaleLen = this.\u049a + dim.getWidth() / 2.0;
            double labelx = point.getX() + (this.\u049c ? r - scaleLen : r + scaleLen) * Math.cos(angel * this.\u0478);
            double labely = point.getY() + (this.\u049c ? r - scaleLen : r + scaleLen) * Math.sin(angel * this.\u0478);
            this.A(g2d, text, this.\u049f, this.\u0492, (int)labelx, (int)labely, 1);
        }
    }

    protected String getScaleValueText(int index, double valueRange, int scaleMajorCount) {
        String text = this.getFormat().format(this.\u0470 + valueRange / (double)scaleMajorCount * (double)index);
        return text;
    }

    private void E(Graphics2D g2d) {
        Element element;
        double pointx = this.\u047a.getX() + this.\u047a.getWidth() / 2.0;
        double pointy = this.\u047a.getY() + this.\u047a.getHeight() / 2.0;
        Point2D.Double point = new Point2D.Double(pointx, pointy);
        Iterator it = this.publishedElements.iterator();
        Element showInBall = null;
        boolean showBallFlag = false;
        while (it.hasNext()) {
            element = (Element)it.next();
            if (this.getValue(element) > this.\u047c || this.getValue(element) < this.\u0470 || element.isSelected()) continue;
            if (!showBallFlag) {
                showInBall = element;
                showBallFlag = true;
            }
            this.A(g2d, element, point);
        }
        showBallFlag = false;
        it = this.publishedElements.iterator();
        while (it.hasNext()) {
            element = (Element)it.next();
            if (this.getValue(element) > this.\u047c || this.getValue(element) < this.\u0470 || !element.isSelected()) continue;
            if (!showBallFlag) {
                showInBall = element;
                showBallFlag = true;
            }
            this.A(g2d, element, point);
        }
        double actualBallSize = this.getActualBallSize();
        Ellipse2D.Double ball = new Ellipse2D.Double(point.getX() - actualBallSize, point.getY() - actualBallSize, actualBallSize * 2.0, actualBallSize * 2.0);
        g2d.setColor(this.\u0499);
        if (this.\u0480) {
            O factory = d.E(this.\u0496);
            int rectangleX = (int)(point.getX() - actualBallSize);
            int rectangleY = (int)(point.getY() - actualBallSize);
            int width = (int)(actualBallSize * 2.0);
            Paint paint = factory.A(new Rectangle(rectangleX, rectangleY, width, width), this.\u049b, this.\u0499);
            g2d.setPaint(paint);
        }
        g2d.fill(ball);
        g2d.setStroke(TUIManager.getStrokeByType("solid.2"));
        g2d.setColor(this.\u0479);
        g2d.draw(ball);
        if (this.isValueTextCenter() && null != showInBall && this.valueTextVisible) {
            this.A(g2d, this.getFormatedText(showInBall, this.getValue(showInBall)), this.valueTextColor, this.valueTextFont, (int)point.getX(), (int)point.getY(), 1);
        }
    }

    private void A(Graphics2D g2d, Element element, Point2D.Double point) {
        double angle = (this.getValue(element) - this.\u0470) / this.\u0498 * this.\u047f + this.\u0477;
        double r = this.\u047a.getWidth() / 2.0;
        Stroke elemenStroke = this.getStroke(element);
        g2d.setStroke(elemenStroke);
        Shape shape = null;
        double actualBallSize = this.getActualBallSize();
        double handLen = this.getHandLegth(element);
        Polygon polygon = new Polygon();
        int firstPointX = (int)(point.getX() + Math.cos(angle * this.\u0478) * handLen * r);
        int firstPointY = (int)(point.getY() + Math.sin(angle * this.\u0478) * handLen * r);
        polygon.addPoint(firstPointX, firstPointY);
        double te1 = 90.0 - angle;
        double center1x = actualBallSize / 1.2 * Math.cos(te1 * this.\u0478) + point.getX();
        double center1y = point.getY() - actualBallSize / 1.2 * Math.sin(te1 * this.\u0478);
        double center2x = point.getX() - actualBallSize / 1.2 * Math.cos(te1 * this.\u0478);
        double center2y = point.getY() + actualBallSize / 1.2 * Math.sin(te1 * this.\u0478);
        polygon.addPoint((int)center1x, (int)center1y);
        polygon.addPoint((int)center2x, (int)center2y);
        shape = polygon;
        double endPointX = point.getX() + Math.cos(angle * this.\u0478) * handLen * r;
        double endPointY = point.getY() + Math.sin(angle * this.\u0478) * handLen * r;
        Point2D.Double endPoint = new Point2D.Double(endPointX, endPointY);
        int handStyle = this.getHandStyle(element);
        if (handStyle == 1) {
            Line2D.Double li = new Line2D.Double(point.getX(), point.getY(), endPoint.x, endPoint.y);
            shape = elemenStroke.createStrokedShape(li);
        } else if (handStyle == 3) {
            double endx = point.getX() + Math.cos(angle * this.\u0478) * handLen * 0.94 * r;
            double endy = point.getY() + Math.sin(angle * this.\u0478) * handLen * 0.94 * r;
            Line2D.Double line = new Line2D.Double(point.getX(), point.getY(), endx, endy);
            shape = elemenStroke.createStrokedShape(line);
            double strokeW = 10.0;
            if (elemenStroke != null && elemenStroke instanceof BasicStroke) {
                strokeW = ((BasicStroke)elemenStroke).getLineWidth();
            }
            Polygon pol = new Polygon();
            pol.addPoint((int)endPoint.x, (int)endPoint.y);
            endx = point.getX() + Math.cos(angle * this.\u0478) * handLen * 0.918 * r;
            endy = point.getY() + Math.sin(angle * this.\u0478) * handLen * 0.918 * r;
            double temLen = r * 0.06 * Math.tan(0.5235987755982988);
            temLen = strokeW > temLen ? strokeW : temLen;
            double arrow1x = endx + temLen * Math.sin(angle * this.\u0478);
            double arrow1y = endy - temLen * Math.cos(angle * this.\u0478);
            double arrow2x = endx - temLen * Math.sin(angle * this.\u0478);
            double arrow2y = endy + temLen * Math.cos(angle * this.\u0478);
            pol.addPoint((int)arrow1x, (int)arrow1y);
            pol.addPoint((int)arrow2x, (int)arrow2y);
            Area ar = new Area(shape);
            ar.add(new Area(pol));
            shape = ar;
        }
        if (element.isSelected()) {
            g2d.setStroke(this.getSelectedStroke(element));
            g2d.setColor(this.getSelectedColor(element));
            g2d.draw(shape);
        }
        GradientPaint gPaint = new GradientPaint(point, this.getColor(element), endPoint, this.getColor(element).brighter(), true);
        g2d.setPaint(gPaint);
        g2d.fill(shape);
        this.shapeStructs.add(0, new C(shape, element, this.getToolTipText(element)));
        if (this.isValueTextVisible() && !this.isValueTextCenter()) {
            g2d.translate(point.getX(), point.getY());
            int flag = angle % 360.0 > 90.0 & angle % 360.0 < 270.0 ? -1 : 1;
            double rotateAng = flag == 1 ? angle : angle - 180.0;
            g2d.rotate(rotateAng * this.\u0478);
            double x = (handLen * r - actualBallSize) / 2.0 + actualBallSize;
            this.A(g2d, this.getFormatedText(element, this.getValue(element)), this.valueTextColor, this.valueTextFont, (int)x * flag, 0, 1);
            g2d.rotate(-rotateAng * this.\u0478);
            g2d.translate(-point.getX(), -point.getY());
        }
    }

    protected double getActualBallSize() {
        if (this.\u0474 > 0.0) {
            return this.\u047a.getWidth() / 2.0 * this.\u0474;
        }
        return this.\u0475;
    }

    private void G(Graphics2D g2d) {
        if (this.\u04a4 != null) {
            Collections.sort(this.\u04a4, A.A());
            int size = this.\u04a4.size();
            for (int i2 = 1; i2 < size; ++i2) {
                Marker markerst = (Marker)this.\u04a4.get(i2 - 1);
                Marker markeren = (Marker)this.\u04a4.get(i2);
                double start = (markerst.getValue() - this.\u0470) / this.\u0498 * this.\u047f + this.\u0477;
                if (markerst.getValue() > this.\u047c || markeren.getValue() < this.\u0470) continue;
                if (markerst.getValue() < this.\u0470) {
                    start = this.\u0477;
                }
                double value = (markeren.getValue() - this.\u0470) / this.\u0498 * this.\u047f + this.\u0477 - start;
                if (markeren.getValue() > this.\u047c) {
                    value = this.\u0498 / this.\u0498 * this.\u047f + this.\u0477 - start;
                }
                double startValue = 360.0 - start - value;
                Arc2D.Double pie = new Arc2D.Double(this.\u047a.getX(), this.\u047a.getY(), this.\u047a.getWidth(), this.\u047a.getHeight(), startValue, value, 2);
                Area area = new Area(pie);
                double centerX = pie.getCenterX();
                double centerY = pie.getCenterY();
                double eWidth = pie.getWidth() - this.\u047a.getWidth() / 2.0 * this.\u0493;
                double eHeight = pie.getHeight() - this.\u047a.getWidth() / 2.0 * this.\u0493;
                Ellipse2D.Double ellipse = new Ellipse2D.Double(centerX - eWidth / 2.0, centerY - eHeight / 2.0, eWidth, eHeight);
                area.subtract(new Area(ellipse));
                g2d.setColor(markerst.getColor());
                g2d.fill(area);
            }
        }
    }

    public String getToolTipText(Element element) {
        return element.getName() + ":" + this.getFormat(element).format(this.getValue(element));
    }

    public double getHandLegth(Element element) {
        return element.getChartDialHandLength();
    }

    public int getHandStyle(Element element) {
        return element.getChartDialHandStyle();
    }

    public List getMarkers() {
        return this.\u04a4;
    }

    public void setMarkers(List markers) {
        this.\u04a4 = markers;
        this.chartPane.repaint();
    }

    public boolean isScaleInside() {
        return this.\u049c;
    }

    public void setScaleInside(boolean scaleInside) {
        this.\u049c = scaleInside;
        this.chartPane.repaint();
    }

    public double getStartAngle() {
        return this.\u0477;
    }

    public void setStartAngle(double startAngle) {
        this.\u0477 = startAngle;
        this.publishData();
    }

    public double getEndAngle() {
        return this.\u04a1;
    }

    public void setEndAngle(double endAngle) {
        this.\u04a1 = endAngle;
        this.publishData();
    }

    public double getMaxValue() {
        return this.\u047c;
    }

    public void setMaxValue(double maxValue) {
        this.\u047c = maxValue;
        this.publishData();
    }

    public double getMinValue() {
        return this.\u0470;
    }

    public void setMinValue(double minValue) {
        this.\u0470 = minValue;
        this.publishData();
    }

    public double getScaleLength() {
        return this.\u049a;
    }

    public void setScaleLength(double scaleLength) {
        this.\u049a = scaleLength;
        this.chartPane.repaint();
    }

    public String getRingStroke() {
        return this.\u047e;
    }

    public void setRingStroke(String ringStroke) {
        this.\u047e = ringStroke;
        this.chartPane.repaint();
    }

    public Color getRingColor() {
        return this.\u0491;
    }

    public void setRingColor(Color ringColor) {
        this.\u0491 = ringColor;
        this.chartPane.repaint();
    }

    public String getScaleStroke() {
        return this.\u04a0;
    }

    public void setScaleStroke(String scaleStroke) {
        this.\u04a0 = scaleStroke;
        this.chartPane.repaint();
    }

    public Color getScaleColor() {
        return this.\u047d;
    }

    public void setScaleColor(Color scaleColor) {
        this.\u047d = scaleColor;
        this.chartPane.repaint();
    }

    public Color getRingBorderColor() {
        return this.\u0494;
    }

    public void setRingBorderColor(Color ringBorderColor) {
        this.\u0494 = ringBorderColor;
        this.chartPane.repaint();
    }

    public boolean isScaleTextVisible() {
        return this.\u0476;
    }

    public void setScaleTextVisible(boolean scaleTextVisible) {
        this.\u0476 = scaleTextVisible;
        this.chartPane.repaint();
    }

    public int getScaleMajorCount() {
        return this.\u0472;
    }

    public void setScaleMajorCount(int scaleMajorCount) {
        this.\u0472 = scaleMajorCount;
        this.chartPane.repaint();
    }

    public boolean isScaleMinorVisible() {
        return this.\u0490;
    }

    public void setScaleMinorVisible(boolean scaleMinorVisible) {
        this.\u0490 = scaleMinorVisible;
        this.chartPane.repaint();
    }

    public Color getBallBorderColor() {
        return this.\u0479;
    }

    public void setBallBorderColor(Color ballBorderColor) {
        this.\u0479 = ballBorderColor;
        this.chartPane.repaint();
    }

    public double getBallSize() {
        return this.\u0475;
    }

    public void setBallSize(double ballSize) {
        if (ballSize == 0.0) {
            ballSize = 1.0;
        }
        this.\u0475 = ballSize;
        this.chartPane.repaint();
    }

    public int getScaleStyle() {
        return this.\u0497;
    }

    public void setScaleStyle(int scaleStyle) {
        this.\u0497 = scaleStyle;
        this.chartPane.repaint();
    }

    public Color getBallColor() {
        return this.\u0499;
    }

    public void setBallColor(Color ballColor) {
        this.\u0499 = ballColor;
        this.chartPane.repaint();
    }

    public int getScaleMinorCount() {
        return this.\u049e;
    }

    public void setScaleMinorCount(int scaleMinorNumber) {
        this.\u049e = scaleMinorNumber;
        this.chartPane.repaint();
    }

    public boolean isRingBorderVisible() {
        return this.\u0473;
    }

    public void setRingBorderVisible(boolean ringBorderVisible) {
        this.\u0473 = ringBorderVisible;
        this.chartPane.repaint();
    }

    public Color getRingFillColor() {
        return this.\u047b;
    }

    public void setRingFillColor(Color fillColor) {
        this.\u047b = fillColor;
        this.chartPane.repaint();
    }

    public boolean isRingGradient() {
        return this.\u049d;
    }

    public void setRingGradient(boolean ringGradient) {
        this.\u049d = ringGradient;
        this.chartPane.repaint();
    }

    public Color getBallGradientColor() {
        return this.\u049b;
    }

    public void setBallGradientColor(Color ballGradientColor) {
        this.\u049b = ballGradientColor;
        this.chartPane.repaint();
    }

    public boolean isBallGradient() {
        return this.\u0480;
    }

    public void setBallGradient(boolean ballGradient) {
        this.\u0480 = ballGradient;
        this.chartPane.repaint();
    }

    public int getRingGradientFactory() {
        return this.\u0471;
    }

    public void setRingGradientFactory(int ringGradientFactory) {
        this.\u0471 = ringGradientFactory;
        this.chartPane.repaint();
    }

    public int getBallGradientFactory() {
        return this.\u0496;
    }

    public void setBallGradientFactory(int ballGradientFactory) {
        this.\u0496 = ballGradientFactory;
        this.chartPane.repaint();
    }

    public Color getRingGradientColor() {
        return this.\u0495;
    }

    public void setRingGradientColor(Color ringGradientColor) {
        this.\u0495 = ringGradientColor;
        this.chartPane.repaint();
    }

    public boolean isScaleMinTextVisible() {
        return this.\u04a5;
    }

    public void setScaleMinTextVisible(boolean scaleMinTextVisible) {
        this.\u04a5 = scaleMinTextVisible;
        this.chartPane.repaint();
    }

    public Rectangle getRingBound() {
        return this.\u047a;
    }

    public Color getScaleTextColor() {
        return this.\u049f;
    }

    public void setScaleTextColor(Color scaleTextColor) {
        this.\u049f = scaleTextColor;
        this.chartPane.repaint();
    }

    public Font getScaleTextFont() {
        return this.\u0492;
    }

    public void setScaleTextFont(Font scaleTextFont) {
        this.\u0492 = scaleTextFont;
        this.chartPane.repaint();
    }

    public void setArcRange(double arcRange) {
        double oldRange = this.\u04a3;
        if (arcRange >= 360.0) {
            arcRange = 360.0;
        }
        if (arcRange <= 0.0) {
            arcRange = 0.0;
        }
        this.\u04a3 = arcRange;
        if (oldRange != this.\u04a3) {
            this.publishData();
        }
    }

    public double getArcRange() {
        return this.\u04a3;
    }

    public int getDialType() {
        return this.\u0481;
    }

    public void setDialType(int dialType) {
        int old = this.\u0481;
        this.\u0481 = dialType;
        if (old != this.\u0481) {
            this.publishData();
        }
    }

    public double getBallPercentSize() {
        return this.\u0474;
    }

    public void setBallPercentSize(double ballPercentSize) {
        this.\u0474 = ballPercentSize;
        this.chartPane.repaint();
    }

    protected void setChartSVGAttribute(AbstractSVGChart absChart) {
        super.setChartSVGAttribute(absChart);
        SVGDialChart chart = (SVGDialChart)absChart;
        chart.setMarkers(this.getMarkers());
        chart.setScaleInside(this.isScaleInside());
        chart.setStartAngle(this.getStartAngle());
        chart.setEndAngle(this.getEndAngle());
        chart.setMaxValue(this.getMaxValue());
        chart.setMinValue(this.getMinValue());
        chart.setScaleLength(this.getScaleLength());
        chart.setRingStroke(this.getRingStroke());
        chart.setRingColor(this.getRingColor());
        chart.setScaleStroke(this.getScaleStroke());
        chart.setScaleColor(this.getScaleColor());
        chart.setRingBorderColor(this.getRingBorderColor());
        chart.setScaleTextVisible(this.isScaleTextVisible());
        chart.setScaleMajorCount(this.getScaleMajorCount());
        chart.setScaleMinorVisible(this.isScaleMinorVisible());
        chart.setBallBorderColor(this.getBallBorderColor());
        chart.setBallSize(this.getBallSize());
        chart.setScaleStyle(this.getScaleStyle());
        chart.setBallColor(this.getBallColor());
        chart.setScaleMinorCount(this.getScaleMinorCount());
        chart.setRingBorderVisible(this.isRingBorderVisible());
        chart.setRingFillColor(this.getRingFillColor());
        chart.setRingGradient(this.isRingGradient());
        chart.setBallGradient(this.isBallGradient());
        chart.setRingGradientFactory(this.getRingGradientFactory());
        chart.setBallGradientFactory(this.getBallGradientFactory());
        chart.setRingGradientColor(this.getRingGradientColor());
        chart.setScaleMinTextVisible(this.isScaleMinTextVisible());
        chart.setScaleTextColor(this.getScaleTextColor());
        chart.setScaleTextFont(this.getScaleTextFont());
        chart.setArcRange(this.getArcRange());
        chart.setDialType(this.getDialType());
        chart.setBallPercentSize(this.getBallPercentSize());
    }

    public void exportSVG(String fileName, int width, int height) {
        if (fileName == null) {
            return;
        }
        if (!fileName.toLowerCase().endsWith(".svg")) {
            fileName = fileName + ".svg";
        }
        SVGDialChart chart = new SVGDialChart();
        this.setChartSVGAttribute(chart);
        SVGContext context = new SVGContext();
        a.A(fileName, chart.toSVG(context, width, height));
    }
}

