/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.List;
import twaver.AbstractElement;
import twaver.Element;
import twaver.Node;
import twaver.TDataBox;
import twaver.TUIManager;
import twaver.TWaverUtil;
import twaver.base.A.E.b;
import twaver.base.A.E.l;
import twaver.base.OrthogonalLinkDirectionType;

public class Link
extends AbstractElement {
    private boolean E = false;
    private Node I = null;
    private Node H = null;
    private Node F = null;
    private Node G = null;
    private int D = 1;

    public Link() {
        this.A();
    }

    public Link(Object id) {
        super(id);
        this.A();
    }

    public Link(Node from, Node to) {
        this.setFrom(from);
        this.setTo(to);
        this.A();
    }

    public Link(Object id, Node from, Node to) {
        this(id);
        this.setFrom(from);
        this.setTo(to);
        this.A();
    }

    private void A() {
        this.getClientProperties().put("attachment.position", TWaverUtil.valueOf(0));
        this.getClientProperties().put("border.underneath", Boolean.TRUE);
    }

    public int getLinkType() {
        return this.D;
    }

    public void setLinkType(int linkType) {
        if (this.D != linkType) {
            int oldValue = this.D;
            this.D = linkType;
            this.firePropertyChange("linkType", oldValue, this.D);
        }
    }

    public String getUIClassID() {
        return "LinkUI";
    }

    public String getSVGUIClassID() {
        return "LinkSVGUI";
    }

    public Node getFrom() {
        return this.I;
    }

    public void setFrom(Node from) {
        Node oldValue = this.I;
        if (this.I != null) {
            this.I.F(this);
        }
        this.I = from;
        if (this.I != null) {
            this.I.E(this);
        }
        this.checkAgentNode();
        this.firePropertyChange("from", oldValue, this.I);
    }

    public Node getTo() {
        return this.H;
    }

    public void setTo(Node to) {
        Node oldValue = this.H;
        if (this.H != null) {
            this.H.G(this);
        }
        this.H = to;
        if (to != null) {
            this.H.D(this);
        }
        this.checkAgentNode();
        this.firePropertyChange("to", oldValue, this.H);
    }

    public Node getFromAgent() {
        return this.F;
    }

    public Node getToAgent() {
        return this.G;
    }

    public boolean isLoop() {
        return this.I == this.H && this.I != null && this.H != null;
    }

    public Point getLocation() {
        return null;
    }

    public int getWidth() {
        return 0;
    }

    public int getHeight() {
        return 0;
    }

    public Rectangle getBounds() {
        return null;
    }

    public void setLocation(double x, double y) {
    }

    public void setLocation(Point location) {
    }

    public void setLocation(Point2D.Double location) {
    }

    public Point getCenterLocation() {
        return null;
    }

    public void setCenterLocation(double x, double y) {
    }

    public void setCenterLocation(Point2D location) {
    }

    public double getX() {
        return -1.0;
    }

    public double getY() {
        return -1.0;
    }

    public Element copy() {
        return this.copy(null);
    }

    public Element copy(Object id) {
        return this.copy(id, (TDataBox)null);
    }

    public Link copy(Node from, Node to) {
        return this.copy(from, to, (TDataBox)null);
    }

    public Link copy(Object id, Node from, Node to) {
        return this.copy(id, from, to, null);
    }

    public Element copy(TDataBox box) {
        try {
            Constructor<?> constructor = this.getClass().getConstructor(Node.class, Node.class);
            Element newElement = (Element)constructor.newInstance(this.getFrom(), this.getTo());
            this.exportValues(newElement, box);
            return newElement;
        }
        catch (Exception ex) {
            TWaverUtil.handleError(null, ex);
            return null;
        }
    }

    public Element copy(Object id, TDataBox box) {
        try {
            Constructor<?> constructor = this.getClass().getConstructor(Object.class, Node.class, Node.class);
            Element newElement = (Element)constructor.newInstance(id, this.getFrom(), this.getTo());
            this.exportValues(newElement, box);
            return newElement;
        }
        catch (Exception ex) {
            TWaverUtil.handleError(null, ex);
            return null;
        }
    }

    public Link copy(Node from, Node to, TDataBox box) {
        try {
            Constructor<?> constructor = this.getClass().getConstructor(Node.class, Node.class);
            Element newElement = (Element)constructor.newInstance(from, to);
            this.exportValues(newElement, box);
            return (Link)newElement;
        }
        catch (Exception ex) {
            TWaverUtil.handleError(null, ex);
            return null;
        }
    }

    public Link copy(Object id, Node from, Node to, TDataBox box) {
        try {
            Constructor<?> constructor = this.getClass().getConstructor(Object.class, Node.class, Node.class);
            Element newElement = (Element)constructor.newInstance(id, from, to);
            this.exportValues(newElement, box);
            return (Link)newElement;
        }
        catch (Exception ex) {
            TWaverUtil.handleError(null, ex);
            return null;
        }
    }

    public void checkAgentNode() {
        Node newToAgent;
        Node newFromAgent = l.B(this);
        if (this.F != newFromAgent) {
            Node oldValue = this.F;
            if (this.F != null) {
                this.F.H(this);
            }
            this.F = newFromAgent;
            if (this.F != null) {
                this.F.B(this);
            }
            this.firePropertyChange("fromAgent", oldValue, this.F);
        }
        if (this.G != (newToAgent = l.A(this))) {
            Node oldValue = this.G;
            if (this.G != null) {
                this.G.A(this);
            }
            this.G = newToAgent;
            if (this.G != null) {
                this.G.C(this);
            }
            this.firePropertyChange("toAgent", oldValue, this.G);
        }
    }

    public void setBundleExpand(boolean bundleExpand) {
        List links = l.A(this.F, this.G);
        if (links != null) {
            Iterator it = links.iterator();
            while (it.hasNext()) {
                Link link = (Link)it.next();
                link.putClientProperty((Object)"link.bundle.expand", bundleExpand);
            }
        }
    }

    public void putClientProperty(Object key, Object value) {
        super.putClientProperty(key, value);
        if (key.equals("link.dash") && Boolean.TRUE.equals(value)) {
            this.putLinkStyle("dash");
        } else if (key.equals("link.chain") && Boolean.TRUE.equals(value)) {
            this.putLinkStyle("chain");
        }
    }

    public boolean isBundleAgent() {
        return !this.isLinkBundleExpand() && this.getLinkBundleSize() > 1 && this.getLinkBundleIndex() == 0;
    }

    public void putLinkStyle(String linkStyle) {
        this.putClientProperty((Object)"link.style", linkStyle);
    }

    public void putLinkColor(Color linkColor) {
        this.putClientProperty((Object)"link.color", linkColor);
    }

    public void putLinkOutlineColor(Color linkOutlineColor) {
        this.putClientProperty((Object)"link.outline.color", linkOutlineColor);
    }

    public void putLinkOutlineWidth(int linkOutlineWidth) {
        this.putClientProperty((Object)"link.outline.width", linkOutlineWidth);
    }

    public void putLinkWidth(int linkWidth) {
        this.putClientProperty((Object)"link.width", linkWidth);
    }

    public void putLinkExtend(int linkExtend) {
        this.putClientProperty((Object)"link.extend", linkExtend);
    }

    public void putLinkProportion(double linkProportion) {
        this.putClientProperty((Object)"link.proportion", new Double(linkProportion));
    }

    public void putLinkFlowingWidth(int linkFlowingWidth) {
        this.putClientProperty((Object)"link.flowing.width", linkFlowingWidth);
    }

    public void putLinkFromArrow(boolean linkFromArrow) {
        this.putClientProperty((Object)"link.fromArrow", linkFromArrow);
    }

    public void putLinkToArrow(boolean linkToArrow) {
        this.putClientProperty((Object)"link.toArrow", linkToArrow);
    }

    public void putLinkFlowing(boolean linkFlowing) {
        this.putClientProperty((Object)"link.flowing", linkFlowing);
    }

    public void putLinkFlowingConverse(boolean linkFlowingConverse) {
        this.putClientProperty((Object)"link.flowing.converse", linkFlowingConverse);
    }

    public void putLinkBlinking(boolean linkBlinking) {
        this.putClientProperty((Object)"link.blinking", linkBlinking);
    }

    public void putLinkBlinkingColor(Color linkBlinkingColor) {
        this.putClientProperty((Object)"link.blinking.color", linkBlinkingColor);
    }

    public void putLinkFlowingColor(Color linkFlowingColor) {
        this.putClientProperty((Object)"link.flowing.color", linkFlowingColor);
    }

    public void putLinkBundleExpand(boolean linkBundleExpand) {
        this.putClientProperty((Object)"link.bundle.expand", linkBundleExpand);
    }

    public void putLinkBundleIndex(int linkBundleIndex) {
        this.putClientProperty((Object)"link.bundle.index", linkBundleIndex);
    }

    public void putLinkBundleSize(int linkBundleSize) {
        this.putClientProperty((Object)"link.bundle.size", linkBundleSize);
    }

    public void putLink3D(boolean link3D) {
        this.putClientProperty((Object)"link.3d", link3D);
    }

    public void putLinkLabelRotatable(boolean linkLabelRotatable) {
        this.putClientProperty((Object)"link.label.rotatable", linkLabelRotatable);
    }

    public void putLinkAntialias(boolean linkAntialias) {
        this.putClientProperty((Object)"link.antialias", linkAntialias);
    }

    public void putLinkFromArrowCenter(boolean linkFromArrowCenter) {
        this.putClientProperty((Object)"link.from.arrow.center", linkFromArrowCenter);
    }

    public void putLinkToArrowCenter(boolean linkToArrowCenter) {
        this.putClientProperty((Object)"link.to.arrow.center", linkToArrowCenter);
    }

    public void putLinkFromArrowStyle(int linkFromArrowStyle) {
        this.putClientProperty((Object)"link.from.arrow.style", linkFromArrowStyle);
    }

    public void putLinkToArrowStyle(int linkToArrowStyle) {
        this.putClientProperty((Object)"link.to.arrow.style", linkToArrowStyle);
    }

    public void putLinkFromArrowColor(Color linkFromArrowColor) {
        this.putClientProperty((Object)"link.from.arrow.color", linkFromArrowColor);
    }

    public void putLinkToArrowColor(Color linkToArrowColor) {
        this.putClientProperty((Object)"link.to.arrow.color", linkToArrowColor);
    }

    public void putLinkFromArrowOutline(boolean linkFromArrowOutline) {
        this.putClientProperty((Object)"link.from.arrow.outline", linkFromArrowOutline);
    }

    public void putLinkToArrowOutline(boolean linkToArrowOutline) {
        this.putClientProperty((Object)"link.to.arrow.outline", linkToArrowOutline);
    }

    public void putLinkFromArrowOutlineColor(Color linkFromArrowOutlineColor) {
        this.putClientProperty((Object)"link.from.arrow.outline.color", linkFromArrowOutlineColor);
    }

    public void putLinkToArrowOutlineColor(Color linkToArrowOutlineColor) {
        this.putClientProperty((Object)"link.to.arrow.outline.color", linkToArrowOutlineColor);
    }

    public void putLinkHollow(boolean linkHollow) {
        this.putClientProperty((Object)"link.style", linkHollow);
    }

    public void putLinkHandlerPosition(int linkHandlerPosition) {
        this.putClientProperty((Object)"link.handler.position", linkHandlerPosition);
    }

    public void putLinkHandlerXOffset(int linkHandlerXOffset) {
        this.putClientProperty((Object)"link.handler.xoffset", linkHandlerXOffset);
    }

    public void putLinkHandlerYOffset(int linkHandlerYOffset) {
        this.putClientProperty((Object)"link.handler.yoffset", linkHandlerYOffset);
    }

    public void putLinkHandlerVisible(boolean linkHandlerVisible) {
        this.putClientProperty((Object)"link.handler.visible", linkHandlerVisible);
    }

    public void putLinkFromArrowXOffset(int linkFromArrowXOffset) {
        this.putClientProperty((Object)"link.from.arrow.xoffset", linkFromArrowXOffset);
    }

    public void putLinkFromArrowYOffset(int linkFromArrowYOffset) {
        this.putClientProperty((Object)"link.from.arrow.yoffset", linkFromArrowYOffset);
    }

    public void putLinkToArrowXOffset(int linkToArrowXOffset) {
        this.putClientProperty((Object)"link.to.arrow.xoffset", linkToArrowXOffset);
    }

    public void putLinkToArrowYOffset(int linkToArrowYOffset) {
        this.putClientProperty((Object)"link.to.arrow.yoffset", linkToArrowYOffset);
    }

    public void putLinkToPosition(int linkToPosition) {
        this.putClientProperty((Object)"link.to.position", linkToPosition);
    }

    public void putLinkFromPosition(int linkFromPosition) {
        this.putClientProperty((Object)"link.from.position", linkFromPosition);
    }

    public void putLinkToXOffset(int linkToXOffset) {
        this.putClientProperty((Object)"link.to.xoffset", linkToXOffset);
    }

    public void putLinkToYOffset(int linkToYOffset) {
        this.putClientProperty((Object)"link.to.yoffset", linkToYOffset);
    }

    public void putLinkFromXOffset(int linkFromXOffset) {
        this.putClientProperty((Object)"link.from.xoffset", linkFromXOffset);
    }

    public void putLinkFromYOffset(int linkFromYOffset) {
        this.putClientProperty((Object)"link.from.yoffset", linkFromYOffset);
    }

    public void putLinkOrthogonalDirection(OrthogonalLinkDirectionType direction) {
        this.putClientProperty((Object)"link.orthogonal.direction", direction);
    }

    public String getLinkStyle() {
        return b.Q(this, "link.style");
    }

    public boolean isLinkHollow() {
        return b.K(this, "link.hollow");
    }

    public Color getLinkColor() {
        return b.P(this, "link.color");
    }

    public Color getLinkOutlineColor() {
        return b.P(this, "link.outline.color");
    }

    public int getLinkOutlineWidth() {
        return b.J(this, "link.outline.width");
    }

    public int getLinkWidth() {
        return b.J(this, "link.width");
    }

    public int getLinkExtend() {
        return b.J(this, "link.extend");
    }

    public double getLinkProportion() {
        double proportion = b.M(this, "link.proportion");
        if (proportion < 0.0 || proportion > 1.0) {
            return 0.5;
        }
        return proportion;
    }

    public int getLinkFlowingWidth() {
        return b.J(this, "link.flowing.width");
    }

    public boolean isLinkFromArrow() {
        return b.K(this, "link.fromArrow");
    }

    public boolean isLinkToArrow() {
        return b.K(this, "link.toArrow");
    }

    public boolean isLinkFlowing() {
        return b.K(this, "link.flowing");
    }

    public boolean isLinkFlowingConverse() {
        return b.K(this, "link.flowing.converse");
    }

    public boolean isLinkBlinking() {
        return b.K(this, "link.blinking");
    }

    public Color getLinkBlinkingColor() {
        return b.P(this, "link.blinking.color");
    }

    public boolean isLink3D() {
        return b.K(this, "link.3d");
    }

    public Color getLinkFlowingColor() {
        return b.P(this, "link.flowing.color");
    }

    public boolean isLinkBundleExpand() {
        return b.K(this, "link.bundle.expand");
    }

    public int getLinkBundleIndex() {
        return b.J(this, "link.bundle.index");
    }

    public int getLinkBundleSize() {
        return b.J(this, "link.bundle.size");
    }

    public boolean isLinkLabelRotatable() {
        return b.K(this, "link.label.rotatable");
    }

    public boolean isLinkAntialias() {
        return b.K(this, "link.antialias");
    }

    public boolean isLinkFromArrowCenter() {
        return b.K(this, "link.from.arrow.center");
    }

    public boolean isLinkToArrowCenter() {
        return b.K(this, "link.to.arrow.center");
    }

    public int getLinkFromArrowStyle() {
        return b.J(this, "link.from.arrow.style");
    }

    public int getLinkToArrowStyle() {
        return b.J(this, "link.to.arrow.style");
    }

    public Color getLinkFromArrowColor() {
        return b.P(this, "link.from.arrow.color");
    }

    public Color getLinkToArrowColor() {
        return b.P(this, "link.to.arrow.color");
    }

    public Color getLinkFromArrowOutlineColor() {
        return b.P(this, "link.from.arrow.outline.color");
    }

    public Color getLinkToArrowOutlineColor() {
        return b.P(this, "link.to.arrow.outline.color");
    }

    public boolean isLinkFromArrowOutline() {
        return b.K(this, "link.from.arrow.outline");
    }

    public boolean isLinkToArrowOutline() {
        return b.K(this, "link.to.arrow.outline");
    }

    public int getLinkHandlerPosition() {
        return b.J(this, "link.handler.position");
    }

    public int getLinkToPosition() {
        return b.J(this, "link.to.position");
    }

    public int getLinkFromPosition() {
        return b.J(this, "link.from.position");
    }

    public int getLinkHandlerXOffset() {
        return b.J(this, "link.handler.xoffset");
    }

    public int getLinkHandlerYOffset() {
        return b.J(this, "link.handler.yoffset");
    }

    public boolean isLinkHandlerVisible() {
        return b.K(this, "link.handler.visible");
    }

    public int getLinkFromArrowXOffset() {
        return b.J(this, "link.from.arrow.xoffset");
    }

    public int getLinkFromArrowYOffset() {
        return b.J(this, "link.from.arrow.yoffset");
    }

    public int getLinkToArrowXOffset() {
        return b.J(this, "link.to.arrow.xoffset");
    }

    public int getLinkToArrowYOffset() {
        return b.J(this, "link.to.arrow.yoffset");
    }

    public int getLinkToXOffset() {
        return b.J(this, "link.to.xoffset");
    }

    public int getLinkToYOffset() {
        return b.J(this, "link.to.yoffset");
    }

    public int getLinkFromXOffset() {
        return b.J(this, "link.from.xoffset");
    }

    public int getLinkFromYOffset() {
        return b.J(this, "link.from.yoffset");
    }

    public OrthogonalLinkDirectionType getLinkOrthogonalDirection() {
        Object value = this.getClientProperty("link.orthogonal.direction");
        if (value instanceof OrthogonalLinkDirectionType) {
            return (OrthogonalLinkDirectionType)value;
        }
        return (OrthogonalLinkDirectionType)TUIManager.get("link.orthogonal.direction");
    }

    public boolean isShapeFrozen() {
        return this.E;
    }

    public void setShapeFrozen(boolean shapeFrozen) {
        if (this.E != shapeFrozen) {
            boolean oldValue = this.E;
            this.E = shapeFrozen;
            this.firePropertyChange("shapeFrozen", oldValue, this.E);
        }
    }
}

