/*
 * Decompiled with CFR 0.152.
 */
package twaver.table.editor;

import twaver.TUIManager;
import twaver.TWaverUtil;
import twaver.table.editor.AbstractCellEditor;

public class FloatEditor
extends AbstractCellEditor {
    public FloatEditor() {
        this(TUIManager.getString("table.alignment.number"));
    }

    public FloatEditor(String alignment) {
        TWaverUtil.setHorizontalAlignment(this.getComponent(), alignment);
    }

    public Object getCellEditorValue() {
        Object value = super.getCellEditorValue();
        if (value == null || "".equals(value)) {
            return null;
        }
        if (value instanceof Float) {
            return value;
        }
        if (value instanceof Number) {
            return new Float(((Number)value).floatValue());
        }
        try {
            return new Float(Float.parseFloat(value.toString()));
        }
        catch (Exception ex) {
            return value;
        }
    }

    public boolean validInputValue(Object inputValue) {
        return inputValue instanceof Float;
    }
}

