/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.util.searcher.mobile.locating;

import com.nepxion.util.net.http.apache.ClientInvoker;
import com.nepxion.util.net.http.apache.ClientParameterList;
import com.nepxion.util.net.http.apache.ClientRequestPost;
import com.nepxion.util.searcher.mobile.locating.LocatingMobileConstants;
import com.nepxion.util.searcher.mobile.locating.LocatingMobileEntity;
import com.nepxion.util.xml.dom4j.Dom4JReader;
import java.net.URI;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class LocatingMobileSearcher
implements LocatingMobileConstants {
    private String charset = "UTF-8";
    private ClientInvoker clientInvoker;

    public LocatingMobileSearcher() {
        this("UTF-8");
    }

    public LocatingMobileSearcher(String charset) {
        this.charset = charset;
        this.clientInvoker = new ClientInvoker();
    }

    public LocatingMobileEntity search(String mobile) throws Exception {
        String text = this.getXML(mobile);
        return this.createEntity(text);
    }

    private LocatingMobileEntity createEntity(String xml) {
        if (xml == null || xml.equals("")) {
            return null;
        }
        Document document = null;
        try {
            document = Dom4JReader.getDocument(xml);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        Element rootElement = document.getRootElement();
        LocatingMobileEntity moblieEntity = new LocatingMobileEntity();
        Element mobileElement = rootElement.element("Mobile");
        moblieEntity.setMobile(mobileElement.getText());
        Element provinceElement = rootElement.element("Province");
        moblieEntity.setProvince(provinceElement.getText());
        Element cityElement = rootElement.element("City");
        moblieEntity.setCity(cityElement.getText());
        Element areaCodeElement = rootElement.element("AreaCode");
        moblieEntity.setAreaCode(areaCodeElement.getText());
        Element postCodeElement = rootElement.element("PostCode");
        moblieEntity.setPostCode(postCodeElement.getText());
        Element corpElement = rootElement.element("Corp");
        moblieEntity.setCorp(corpElement.getText());
        Element cardElement = rootElement.element("Card");
        moblieEntity.setCard(cardElement.getText());
        return moblieEntity;
    }

    public String getXML(String mobile) throws Exception {
        ClientRequestPost clientRequestPost = new ClientRequestPost();
        clientRequestPost.setURI(URI.create("http://api.showji.com/locating/"));
        ClientParameterList clientParameterList = new ClientParameterList();
        clientParameterList.put("m", mobile);
        clientParameterList.put("output", "xml");
        clientRequestPost.setParameterEntity(clientParameterList, this.charset);
        String responseText = this.clientInvoker.getResponseText(clientRequestPost, this.charset);
        return responseText;
    }
}

