/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.util.searcher.ip.sina;

import com.nepxion.util.net.http.apache.ClientInvoker;
import com.nepxion.util.net.http.apache.ClientParameterList;
import com.nepxion.util.net.http.apache.ClientRequestGet;
import com.nepxion.util.searcher.ip.sina.SinaIPConstants;
import com.nepxion.util.searcher.ip.sina.SinaIPEntity;
import java.net.URI;
import java.util.StringTokenizer;

public class SinaIPSearcher
implements SinaIPConstants {
    private String charset = "GBK";
    private ClientInvoker clientInvoker;

    public SinaIPSearcher() {
        this("GBK");
    }

    public SinaIPSearcher(String charset) {
        this.charset = charset;
        this.clientInvoker = new ClientInvoker();
    }

    public SinaIPEntity search(String ip) throws Exception {
        String text = this.getText(ip);
        return this.createEntity(text);
    }

    public SinaIPEntity search() throws Exception {
        String text = this.getText(null);
        return this.createEntity(text);
    }

    private SinaIPEntity createEntity(String text) {
        if (text == null || text.equals("")) {
            return null;
        }
        SinaIPEntity ipEntity = new SinaIPEntity();
        StringTokenizer stringTokenizer = new StringTokenizer(text, ",");
        String ip = stringTokenizer.nextToken();
        ip = ip.substring(ip.indexOf("\"") + 1, ip.lastIndexOf("\""));
        ipEntity.setIP(ip);
        String country = stringTokenizer.nextToken();
        country = country.substring(country.indexOf("\"") + 1, country.lastIndexOf("\""));
        ipEntity.setCountry(country);
        String province = stringTokenizer.nextToken();
        province = province.substring(province.indexOf("\"") + 1, province.lastIndexOf("\""));
        ipEntity.setProvince(province);
        String city = stringTokenizer.nextToken();
        city = city.substring(city.indexOf("\"") + 1, city.lastIndexOf("\""));
        ipEntity.setCity(city);
        String corp = stringTokenizer.nextToken();
        corp = corp.substring(corp.indexOf("\"") + 1);
        corp = corp.substring(0, corp.indexOf("\""));
        ipEntity.setCorp(corp);
        return ipEntity;
    }

    public String getText(String ip) throws Exception {
        ClientRequestGet clientRequestGet = new ClientRequestGet();
        clientRequestGet.setURI(URI.create("http://counter.sina.com.cn/ip"));
        if (ip != null) {
            ClientParameterList clientParameterList = new ClientParameterList();
            clientParameterList.put("ip", ip);
            clientRequestGet.setParameterEntity(clientParameterList, this.charset);
        }
        String responseText = this.clientInvoker.getResponseText(clientRequestGet, this.charset);
        return responseText;
    }
}

