/*
 * Decompiled with CFR 0.152.
 */
package y.view.hierarchy;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import y.base.Command;
import y.base.Edge;
import y.base.Graph;
import y.base.GraphEvent;
import y.base.Node;
import y.base.NodeList;
import y.view.Graph2DUndoManager;
import y.view.hierarchy.HierarchyEvent;
import y.view.hierarchy.HierarchyListener;
import y.view.hierarchy.HierarchyManager;

public class Graph2DHierarchyUndoManager
extends Graph2DUndoManager
implements HierarchyListener {
    private HierarchyManager p;
    private Graph r;
    private Graph o = null;
    private PropertyChangeSupport q = new PropertyChangeSupport(this);

    public Graph2DHierarchyUndoManager(HierarchyManager hierarchyManager) {
        this.p = hierarchyManager;
    }

    public void hierarchyChange(HierarchyEvent hierarchyEvent) {
        switch (hierarchyEvent.getType()) {
            case 6: {
                Node node = (Node)hierarchyEvent.getData();
                Graph graph = hierarchyEvent.getGraph();
                this.push(new _int(graph, node, this.p.isFolderNode(node)));
                this.setActiveGraph(graph);
                break;
            }
            case 7: {
                Edge edge = (Edge)hierarchyEvent.getData();
                Graph graph = hierarchyEvent.getGraph();
                this.push(new _for(graph, edge, this.p.isInterEdge(edge)));
                this.setActiveGraph(graph);
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.q.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.q.removePropertyChangeListener(propertyChangeListener);
    }

    public Graph getActiveGraph() {
        return this.r;
    }

    public void setActiveGraph(Graph graph) {
        if (this.isActive()) {
            this.o = this.o == null ? graph : this.p.getNearestCommonAncestor(this.o, graph);
        } else {
            if (this.r == graph) {
                return;
            }
            this.r = graph;
        }
    }

    public void onGraphEvent(GraphEvent graphEvent) {
        byte by = graphEvent.getType();
        if (by != 13 && by != 12) {
            this.setActiveGraph(graphEvent.getGraph());
        }
        super.onGraphEvent(graphEvent);
    }

    public void redo() {
        this.o = null;
        super.redo();
        if (this.o != null) {
            this.setActiveGraph(this.o);
            this.q.firePropertyChange("activeGraph", null, this.r);
            this.o = null;
        }
    }

    public void undo() {
        this.o = null;
        super.undo();
        if (this.o != null) {
            this.setActiveGraph(this.o);
            this.q.firePropertyChange("activeGraph", null, this.r);
            this.o = null;
        }
    }

    class _a
    extends _if {
        Graph u;
        Graph v;
        NodeList t;

        public _a(Graph graph, Graph graph2, NodeList nodeList) {
            this.u = graph;
            this.v = graph2;
            this.t = nodeList;
        }

        public void undo() {
            Graph2DHierarchyUndoManager.this.p.foldSubgraph(this.t, Graph2DHierarchyUndoManager.this.p.getAnchorNode(this.u));
        }

        public void redo() {
            Graph2DHierarchyUndoManager.this.p.unfoldSubgraph(this.u, this.t);
        }
    }

    class _do
    extends _if {
        Graph x;
        Graph y;
        NodeList w;

        public _do(Graph graph, Graph graph2, NodeList nodeList) {
            this.x = graph;
            this.y = graph2;
            this.w = nodeList;
        }

        public void undo() {
            Graph2DHierarchyUndoManager.this.p.unfoldSubgraph(this.y, this.w);
        }

        public void redo() {
            Graph2DHierarchyUndoManager.this.p.foldSubgraph(this.w, Graph2DHierarchyUndoManager.this.p.getAnchorNode(this.y));
        }
    }

    class _int
    extends _if {
        boolean ah;
        Graph ai;
        Node ag;
        Graph af;

        public _int(Graph graph, Node node, boolean bl) {
            this.ai = graph;
            this.ag = node;
            this.ah = bl;
            if (bl) {
                this.af = Graph2DHierarchyUndoManager.this.p.getInnerGraph(node);
            }
        }

        public void undo() {
            if (this.ah) {
                Graph2DHierarchyUndoManager.this.p.convertToFolderNode(this.ag, this.af);
            } else {
                this.af = Graph2DHierarchyUndoManager.this.p.getInnerGraph(this.ag);
                Graph2DHierarchyUndoManager.this.p.convertToNormalNode(this.ag);
            }
        }

        public void redo() {
            if (this.ah) {
                this.af = Graph2DHierarchyUndoManager.this.p.getInnerGraph(this.ag);
                Graph2DHierarchyUndoManager.this.p.convertToNormalNode(this.ag);
            } else {
                Graph2DHierarchyUndoManager.this.p.convertToFolderNode(this.ag, this.af);
            }
        }
    }

    class _for
    extends _if {
        boolean aa;
        Graph ac;
        Edge ae;
        Graph z;
        Node ab;
        Node ad;

        public _for(Graph graph, Edge edge, boolean bl) {
            this.ac = graph;
            this.ae = edge;
            this.aa = bl;
            if (bl) {
                this.ab = Graph2DHierarchyUndoManager.this.p.getRealSource(edge);
                this.ad = Graph2DHierarchyUndoManager.this.p.getRealTarget(edge);
            }
        }

        public void undo() {
            if (this.aa) {
                Graph2DHierarchyUndoManager.this.p.convertToInterEdge(this.ae, this.ab, this.ad);
            } else {
                this.ab = Graph2DHierarchyUndoManager.this.p.getRealSource(this.ae);
                this.ad = Graph2DHierarchyUndoManager.this.p.getRealTarget(this.ae);
                Graph2DHierarchyUndoManager.this.p.convertToNormalEdge(this.ae);
            }
        }

        public void redo() {
            if (this.aa) {
                this.ab = Graph2DHierarchyUndoManager.this.p.getRealSource(this.ae);
                this.ad = Graph2DHierarchyUndoManager.this.p.getRealTarget(this.ae);
                Graph2DHierarchyUndoManager.this.p.convertToNormalEdge(this.ae);
            } else {
                Graph2DHierarchyUndoManager.this.p.convertToInterEdge(this.ae, this.ab, this.ad);
            }
        }
    }

    abstract class _if
    implements Command {
        _if() {
        }

        public void execute() {
        }
    }
}

