/*
 * Decompiled with CFR 0.152.
 */
package twaver.gis.link;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import twaver.Link;
import twaver.TWaverUtil;
import twaver.gis.GisManager;
import twaver.network.TNetwork;
import twaver.network.ui.LinkUI;

public class InterceptedLinkUI
extends LinkUI {
    private static final Point G = new Point();

    public InterceptedLinkUI(TNetwork network, Link link) {
        super(network, link);
    }

    public Point getCenterPoint() {
        if (this.centerPoint == null) {
            this.getPath();
        }
        if (this.centerPoint == null) {
            return G;
        }
        return (Point)this.centerPoint.clone();
    }

    private Point C(GeneralPath path) {
        Point result = null;
        ArrayList ps = new ArrayList();
        InterceptedLinkUI.getPoints(path, ps, null);
        int size = ps.size();
        int offset = ps.size() / 2;
        if (size % 2 == 0 && offset > 1) {
            Point2D p1 = (Point2D)ps.get(offset - 1);
            Point2D p2 = (Point2D)ps.get(offset);
            result = new Point((int)(p2.getX() + p1.getX()) / 2, (int)(p2.getY() + p1.getY()) / 2);
        } else {
            Point from = this.getFromPoint();
            Point to = this.getToPoint();
            result = new Point((int)(from.getX() + to.getX()) / 2, (int)(from.getY() + to.getY()) / 2);
        }
        return result;
    }

    public static final void getPoints(GeneralPath path, List ps, List segments) {
        float[] segment = new float[6];
        PathIterator pi = path.getPathIterator(null);
        while (!pi.isDone()) {
            int segtype = pi.currentSegment(segment);
            if (segments != null) {
                segments.add(TWaverUtil.valueOf((int)segtype));
            }
            switch (segtype) {
                case 0: {
                    ps.add(new Point2D.Double((int)segment[0], (int)segment[1]));
                    break;
                }
                case 1: {
                    ps.add(new Point2D.Double((int)segment[0], (int)segment[1]));
                    break;
                }
                case 2: {
                    ps.add(new Point2D.Double((int)segment[0], (int)segment[1]));
                    ps.add(new Point2D.Double((int)segment[2], (int)segment[3]));
                    break;
                }
                case 3: {
                    ps.add(new Point2D.Double((int)segment[0], (int)segment[1]));
                    ps.add(new Point2D.Double((int)segment[2], (int)segment[3]));
                    ps.add(new Point2D.Double((int)segment[4], (int)segment[5]));
                    break;
                }
            }
            pi.next();
        }
    }

    public GeneralPath getPath() {
        if (this.path == null) {
            this.path = this.C(this);
        }
        return this.path;
    }

    private GeneralPath C(Point from, Point to) {
        GeneralPath customPath = null;
        double x0 = from.getX();
        double y0 = from.getY();
        double x1 = to.getX();
        double y1 = to.getY();
        double zoom = this.network.getZoom();
        Object vo = this.network.getClientProperty((Object)"viewport");
        if (!(vo instanceof Rectangle)) {
            return this.D(from, to);
        }
        customPath = new GeneralPath();
        Rectangle viewport = (Rectangle)vo;
        int w = (int)((double)viewport.width / zoom);
        int h = (int)((double)viewport.height / zoom);
        viewport = new Rectangle(new Dimension(w, h));
        boolean intersects = viewport.intersectsLine(x1, y1, x0, y0);
        boolean contains = viewport.contains(x0, y0, x1, y1);
        if (intersects || contains) {
            if (intersects) {
                Point2D[] result = this.E(x0, y0, x1, y1, viewport);
                if (result != null) {
                    x0 = result[0].getX();
                    y0 = result[0].getY();
                    x1 = result[1].getX();
                    y1 = result[1].getY();
                    customPath.moveTo((float)x0, (float)y0);
                    customPath.lineTo((float)x1, (float)y1);
                }
            } else {
                customPath.moveTo((float)x0, (float)y0);
                customPath.lineTo((float)x1, (float)y1);
            }
        }
        this.centerPoint = this.C(customPath);
        return customPath;
    }

    private GeneralPath C(LinkUI linkUI) {
        Point from = linkUI.getFromPoint();
        Point to = linkUI.getToPoint();
        Link link = this.getLink();
        int type = link.getLinkType();
        int bundleIndex = this.getBundleIndex();
        int bundleSize = this.getBundleSize();
        boolean bundleAgent = this.isBundleAgent();
        if ((bundleSize <= 1 || bundleAgent) && type != 0) {
            return this.C(from, to);
        }
        return this.getBundledShape(type, bundleIndex, bundleSize, bundleAgent, from, to, this.network);
    }

    private static int C(Point fromPoint, Point toPoint, int bundleOffset) {
        int dest = (int)fromPoint.distance(toPoint);
        return dest > bundleOffset * 2 ? bundleOffset : dest / 2;
    }

    private static int C(int bundleIndex, int bundleSize, int bundleGap) {
        int i = bundleIndex;
        if (bundleSize % 2 == 0) {
            ++i;
        }
        i = (i + 1) / 2 * (i % 2 == 0 ? -1 : 1);
        int yOffset = bundleGap * i;
        if (bundleSize % 2 == 0) {
            yOffset = i > 0 ? (yOffset -= bundleGap / 4 + 2) : (yOffset += bundleGap / 4 + 2);
        }
        return yOffset;
    }

    private double C(double x1, double y1, double x2, double y2) {
        if (x1 == x2) {
            if (y2 == y1) {
                return 0.0;
            }
            if (y2 > y1) {
                return 1.5707963267948966;
            }
            return -1.5707963267948966;
        }
        return Math.atan((y2 - y1) / (x2 - x1));
    }

    public GeneralPath getBundledShape(int type, int bundleIndex, int bundleSize, boolean bundleAgent, Point from, Point to, TNetwork network) {
        int yOffset;
        int xOffset;
        Object vo = network.getClientProperty((Object)"viewport");
        if (!(vo instanceof Rectangle)) {
            return this.D(from, to);
        }
        Rectangle window = (Rectangle)vo;
        if (type == 0) {
            xOffset = InterceptedLinkUI.C(from, to, network.getParallelLinkOffset());
            yOffset = bundleSize <= 1 || bundleAgent ? 0 : InterceptedLinkUI.C(bundleIndex, bundleSize, network.getParallelLinkGap());
        } else {
            xOffset = InterceptedLinkUI.C(from, to, network.getStraightLinkOffset());
            yOffset = InterceptedLinkUI.C(bundleIndex, bundleSize, network.getStraightLinkGap());
        }
        Point p = new Point((int)from.distance(to), 0);
        Point p1 = new Point(xOffset, yOffset);
        Point p2 = new Point(p.x - xOffset, yOffset);
        if (from.x > to.x) {
            p.x = -p.x;
            p1.x = -p1.x;
            p2.x = -p2.x;
        }
        if (from.x == to.x && from.y > to.y) {
            p1.y = -p1.y;
            p2.y = -p2.y;
        }
        GeneralPath path = new GeneralPath();
        if (type == 0) {
            path.moveTo(p1.x, p1.y);
            path.lineTo(p.x - p1.x, p1.y);
        } else {
            path.moveTo(0.0f, 0.0f);
            path.lineTo(p1.x, p1.y);
            path.lineTo(p2.x, p2.y);
            path.lineTo(p.x, p.y);
        }
        AffineTransform at = AffineTransform.getTranslateInstance(from.x, from.y);
        at.rotate(this.C(from.getX(), from.getY(), to.getX(), to.getY()));
        Shape shape = at.createTransformedShape(path);
        GeneralPath shapePath = new GeneralPath(shape);
        this.centerPoint = this.C(shapePath);
        int w = (int)(window.getWidth() / network.getZoom());
        int h = (int)(window.getHeight() / network.getZoom());
        window = new Rectangle(0, 0, w, h);
        if (this.D(window, shapePath)) {
            return shapePath;
        }
        List points = this.C(window, shapePath);
        int size = points.size();
        path = new GeneralPath();
        if (size > 0) {
            path = new GeneralPath();
            int i = 0;
            while (i < size) {
                Point2D point0 = (Point2D)points.get(i);
                Point2D point1 = (Point2D)points.get(i + 1);
                path.moveTo((float)point0.getX(), (float)point0.getY());
                path.lineTo((float)point1.getX(), (float)point1.getY());
                i += 2;
            }
        }
        return path;
    }

    private boolean D(Rectangle rect, GeneralPath path) {
        PathIterator iterator = path.getPathIterator(null);
        double[] coords = new double[6];
        double x = 0.0;
        double y = 0.0;
        while (!iterator.isDone()) {
            int type = iterator.currentSegment(coords);
            switch (type) {
                case 0: 
                case 1: {
                    x = coords[0];
                    y = coords[1];
                    if (!(x < rect.getMinX() || x > rect.getMaxX() || y < rect.getMinY()) && !(y > rect.getMaxY())) break;
                    return false;
                }
            }
            iterator.next();
        }
        return true;
    }

    private boolean D(double x0, double y0, double x1, double y1, Rectangle window) {
        return window.contains(x0, y0) && window.contains(x1, y1);
    }

    private Point2D C(double x0, double y0, double x1, double y1, Rectangle2D window) {
        double x = window.getMinX();
        double y = y0 + (y1 - y0) * (x - x0) / (x1 - x0);
        return new Point2D.Double(x, y);
    }

    private Point2D D(double x0, double y0, double x1, double y1, Rectangle2D window) {
        double x = window.getMaxX();
        double y = y0 + (y1 - y0) * (x - x0) / (x1 - x0);
        return new Point2D.Double(x, y);
    }

    private Point2D F(double x0, double y0, double x1, double y1, Rectangle2D window) {
        double y = window.getMinY();
        double x = x0 + (y - y0) * (x1 - x0) / (y1 - y0);
        return new Point2D.Double(x, y);
    }

    private Point2D G(double x0, double y0, double x1, double y1, Rectangle2D window) {
        double y = window.getMaxY();
        double x = x0 + (y - y0) * (x1 - x0) / (y1 - y0);
        return new Point2D.Double(x, y);
    }

    private Point2D[] E(double x0, double y0, double x1, double y1, Rectangle2D window) {
        Point2D[] result = new Point2D[2];
        double y = y1;
        double x = x1;
        boolean contain0 = window.contains(x0, y0);
        boolean contain1 = window.contains(x1, y1);
        if (contain0 || contain1) {
            if (!contain0) {
                x1 = x0;
                y1 = y0;
                x0 = x;
                y0 = y;
            }
            if (x1 <= window.getMinX()) {
                x = window.getMinX();
                y = y0 + (y1 - y0) * (x - x0) / (x1 - x0);
                if (y < window.getY()) {
                    y = window.getMinY();
                    x = x0 + (y - y0) * (x1 - x0) / (y1 - y0);
                } else if (y > window.getMaxY()) {
                    y = window.getMaxY();
                    x = x0 + (y - y0) * (x1 - x0) / (y1 - y0);
                }
            } else if (x1 >= window.getMaxX()) {
                x = window.getMaxX();
                y = y0 + (y1 - y0) * (x - x0) / (x1 - x0);
                if (y < window.getMinY()) {
                    y = window.getMinY();
                    x = x0 + (y - y0) * (x1 - x0) / (y1 - y0);
                } else if (y > window.getMaxY()) {
                    y = window.getMaxY();
                    x = x0 + (y - y0) * (x1 - x0) / (y1 - y0);
                }
            } else {
                if (y1 <= window.getMinY()) {
                    y = window.getMinY();
                } else if (y1 >= window.getMaxY()) {
                    y = window.getMaxY();
                }
                if (y1 != y0) {
                    x = x0 + (y - y0) * (x1 - x0) / (y1 - y0);
                }
            }
            result[1] = new Point2D.Double(x, y);
            result[0] = new Point2D.Double(x0, y0);
        } else {
            double rx = window.getMaxX();
            double by = window.getMaxY();
            if (x0 >= rx && x1 >= rx || y0 >= by && y1 >= by) {
                result = null;
            } else {
                Point2D left = this.C(x0, y0, x1, y1, window);
                Point2D top = this.F(x0, y0, x1, y1, window);
                Point2D bottom = this.G(x0, y0, x1, y1, window);
                Point2D right = this.D(x0, y0, x1, y1, window);
                Point2D[] points = new Point2D[]{left, top, bottom, right};
                Vector<Point2D> validatePoints = new Vector<Point2D>();
                int i = 0;
                while (i < points.length) {
                    if (this.C(points[i], window)) {
                        validatePoints.add(points[i]);
                    }
                    ++i;
                }
                if (validatePoints.size() == 2) {
                    Point2D p1 = (Point2D)validatePoints.get(0);
                    Point2D p2 = (Point2D)validatePoints.get(1);
                    if (p1.getX() <= p2.getX()) {
                        result[0] = p1;
                        result[1] = p2;
                    } else {
                        result[0] = p2;
                        result[1] = p1;
                    }
                }
            }
        }
        return result;
    }

    private boolean C(Point2D point, Rectangle2D window) {
        double x = point.getX();
        double y = point.getY();
        return window.getMinX() <= x && window.getMaxX() >= x && window.getMinY() <= y && window.getMaxY() >= y;
    }

    private GeneralPath D(Point from, Point to) {
        GeneralPath customPath = new GeneralPath();
        customPath.moveTo((float)from.getX(), (float)from.getY());
        customPath.lineTo((float)to.getX(), (float)to.getY());
        return customPath;
    }

    private List C(Rectangle sourceRectangle, GeneralPath targetPath) {
        ArrayList result = new ArrayList();
        PathIterator pit = targetPath.getPathIterator(null);
        double[] coords = new double[6];
        double lastX = 0.0;
        double lastY = 0.0;
        while (!pit.isDone()) {
            int type = pit.currentSegment(coords);
            switch (type) {
                case 0: {
                    lastX = coords[0];
                    lastY = coords[1];
                    break;
                }
                case 1: {
                    result.addAll(this.C(lastX, lastY, coords[0], coords[1], sourceRectangle));
                    lastX = coords[0];
                    lastY = coords[1];
                }
            }
            pit.next();
        }
        return result;
    }

    private List C(final double x0, final double y0, double x1, double y1, Rectangle window) {
        ArrayList<Point2D> result = new ArrayList<Point2D>();
        if (window.intersectsLine(x0, y0, x1, y1)) {
            if (this.D(x0, y0, x1, y1, window)) {
                result.add(new Point2D.Double(x0, y0));
                result.add(new Point2D.Double(x1, y1));
            } else {
                Point2D[] points = new Point2D[4];
                if (x0 <= window.getMaxX() && x0 >= window.getMinX() && y0 <= window.getMaxY() && y0 >= window.getMinY()) {
                    result.add(new Point2D.Double(x0, y0));
                }
                points[0] = this.C(x0, y0, x1, y1, (Rectangle2D)window);
                points[1] = this.F(x0, y0, x1, y1, window);
                points[2] = this.D(x0, y0, x1, y1, (Rectangle2D)window);
                points[3] = this.G(x0, y0, x1, y1, window);
                int i = 0;
                while (i < points.length) {
                    if (this.C(points[i], window)) {
                        double maxx = Math.max(x0, x1);
                        double maxy = Math.max(y0, y1);
                        double minx = Math.min(x0, x1);
                        double miny = Math.min(y0, y1);
                        double x = points[i].getX();
                        double y = points[i].getY();
                        if (x >= minx && x <= maxx && y >= miny && y <= maxy) {
                            result.add(points[i]);
                        }
                    }
                    ++i;
                }
                Collections.sort(result, new Comparator(){

                    public int compare(Object a, Object b) {
                        Point2D p1 = (Point2D)a;
                        Point2D p2 = (Point2D)b;
                        double result = Math.abs(p1.getX() - x0) - Math.abs(p2.getX() - x0);
                        if (result == 0.0) {
                            result = Math.abs(p1.getY() - y0) - Math.abs(p2.getY() - y0);
                        }
                        return (int)(result * 10000.0);
                    }
                });
                if (x1 <= window.getMaxX() && x1 >= window.getMinX() && y1 <= window.getMaxY() && y1 >= window.getMinY()) {
                    result.add(new Point2D.Double(x1, y1));
                }
            }
        }
        return result;
    }

    public void invalidateShape() {
        if (GisManager.getBoolean("link.keepwidth")) {
            Link link = (Link)this.getElement();
            this.linkWidth = (int)((double)link.getLinkWidth() / this.network.getZoom());
        }
        super.invalidateShape();
    }
}

