/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.table.layoutable;

import com.nepxion.swing.table.layoutable.TableCellRendererConstants;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class TableCellRendererLayout
implements TableCellRendererConstants {
    private JTable table;

    public TableCellRendererLayout(JTable table) {
        this.table = table;
    }

    public void doLayout() {
        this.doLayout("rowColumnLayoutMode");
    }

    public void doLayout(String layoutMode) {
        this.doLayout((int[])null, layoutMode);
    }

    public void doLayout(int[] gaps) {
        this.doLayout(gaps, "rowColumnLayoutMode");
    }

    public void doLayout(int[] gaps, String layoutMode) {
        this.doLayout(null, null, gaps, layoutMode);
    }

    public void doLayout(int[][] sizes) {
        this.doLayout(sizes, "rowColumnLayoutMode");
    }

    public void doLayout(int[][] sizes, String layoutMode) {
        this.doLayout(sizes, (int[][])null, layoutMode);
    }

    public void doLayout(int[][] sizes, int[][] range) {
        this.doLayout(sizes, range, "rowColumnLayoutMode");
    }

    public void doLayout(int[][] sizes, int[][] range, String layoutMode) {
        this.doLayout(sizes, range, null, layoutMode);
    }

    public void doLayout(int[][] range, int[] gaps) {
        this.doLayout(range, gaps, "rowColumnLayoutMode");
    }

    public void doLayout(int[][] range, int[] gaps, String layoutMode) {
        this.doLayout(null, range, gaps, layoutMode);
    }

    public void doLayout(int[][] sizes, int[][] range, int[] gaps, String layoutMode) {
        int[] columnWidths = null;
        int[] rowHeights = null;
        if (sizes != null) {
            columnWidths = sizes[0];
            rowHeights = sizes[1];
        }
        int[] columnRangeWidths = null;
        int[] rowRangeHeights = null;
        if (range != null) {
            columnRangeWidths = range[0];
            rowRangeHeights = range[1];
        }
        int columnMinimumWidth = 0;
        int columnMaximumWidth = 0;
        if (columnRangeWidths != null) {
            columnMinimumWidth = columnRangeWidths[0];
            columnMaximumWidth = columnRangeWidths[1];
        }
        int rowMinimumHeight = 0;
        int rowMaximumHeight = 0;
        if (rowRangeHeights != null) {
            rowMinimumHeight = rowRangeHeights[0];
            rowMaximumHeight = rowRangeHeights[1];
        }
        int columnGap = 0;
        int rowGap = 0;
        if (gaps != null) {
            columnGap = gaps[0];
            rowGap = gaps[1];
        }
        if (layoutMode.equals("rowColumnLayoutMode") || layoutMode.equals("columnLayoutMode")) {
            int columnCount = this.table.getColumnCount();
            for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                int columnWidth = -2;
                if (columnWidths == null) {
                    columnWidth = -1;
                } else {
                    if (columnIndex >= columnWidths.length) break;
                    columnWidth = columnWidths[columnIndex];
                }
                this.doLayoutColumnWidth(columnIndex, columnWidth, columnMinimumWidth, columnMaximumWidth, columnGap);
            }
        }
        if (layoutMode.equals("rowColumnLayoutMode") || layoutMode.equals("rowLayoutMode")) {
            int rowCount = this.table.getRowCount();
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                int rowHeight = -2;
                if (rowHeights == null) {
                    rowHeight = -1;
                } else {
                    if (rowIndex >= rowHeights.length) break;
                    rowHeight = rowHeights[rowIndex];
                }
                this.doLayoutRowHeight(rowIndex, rowHeight, rowMinimumHeight, rowMaximumHeight, rowGap);
            }
        }
    }

    public void doLayoutColumnWidth(int columnIndex, int columnWidth, int columnMinimumWidth, int columnMaximumWidth, int columnGap) {
        JTableHeader header = this.table.getTableHeader();
        TableColumn column = this.table.getColumnModel().getColumn(columnIndex);
        header.setResizingColumn(column);
        if (columnWidth > 0) {
            column.setWidth(columnWidth + columnGap);
        }
        if (columnWidth == -1) {
            int rowCount = this.table.getRowCount();
            Component headerCellRenderer = header.getDefaultRenderer().getTableCellRendererComponent(this.table, column.getIdentifier(), false, false, 0, columnIndex);
            int width = (int)headerCellRenderer.getPreferredSize().getWidth();
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                Component cellRenderer;
                TableCellRenderer tableCellRenderer = this.table.getCellRenderer(rowIndex, columnIndex);
                if (tableCellRenderer == null || (cellRenderer = tableCellRenderer.getTableCellRendererComponent(this.table, this.table.getValueAt(rowIndex, columnIndex), false, false, rowIndex, columnIndex)) == null) continue;
                int cellRendererWidth = (int)cellRenderer.getPreferredSize().getWidth();
                width = Math.max(cellRendererWidth, width);
            }
            if (columnMinimumWidth > 0 && columnMinimumWidth > width) {
                width = columnMinimumWidth;
            } else if (columnMaximumWidth > 0 && columnMaximumWidth < width) {
                width = columnMaximumWidth;
            }
            column.setWidth(width + columnGap);
        }
    }

    public void doLayoutRowHeight(int rowIndex, int rowHeight, int rowMinimumHeight, int rowMaximumHeight, int rowGap) {
        if (rowHeight > 0) {
            this.table.setRowHeight(rowIndex, rowHeight + rowGap);
        }
        if (rowHeight == -1) {
            int columnCount = this.table.getColumnCount();
            int height = 0;
            for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                int cellRendererHeight;
                Component cellRenderer;
                TableCellRenderer tableCellRenderer = this.table.getCellRenderer(rowIndex, columnIndex);
                if (tableCellRenderer == null || (cellRenderer = tableCellRenderer.getTableCellRendererComponent(this.table, this.table.getValueAt(rowIndex, columnIndex), false, false, rowIndex, columnIndex)) == null || height >= (cellRendererHeight = (int)cellRenderer.getPreferredSize().getHeight())) continue;
                height = cellRendererHeight;
            }
            if (rowMinimumHeight > 0 && rowMinimumHeight > height) {
                height = rowMinimumHeight;
            } else if (rowMaximumHeight > 0 && rowMaximumHeight < height) {
                height = rowMaximumHeight;
            }
            if (height + rowGap > 0) {
                this.table.setRowHeight(rowIndex, height + rowGap);
            }
        }
    }
}

