/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.panel;

import com.nepxion.swing.handle.HandleManager;
import com.nepxion.swing.layout.filed.FiledLayout;
import com.nepxion.swing.listener.DisplayAbilityListener;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.optionpane.JBasicOptionPane;
import com.nepxion.swing.textfield.number.JNumberTextField;
import com.nepxion.swing.validation.IValidation;
import java.awt.Dimension;
import java.awt.event.HierarchyEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingConstants;

public class JTimePanel
extends JPanel
implements SwingConstants,
IValidation {
    private JNumberTextField dayTextField = new JNumberTextField(0.0);
    private JPanel dayPanel = new JPanel();
    private JNumberTextField hourTextField;
    private JPanel hourPanel;
    private JNumberTextField minuteTextField;
    private JPanel minutePanel;
    private JNumberTextField secondTextField;
    private JPanel secondPanel;
    private JNumberTextField milliSecondTextField;
    private JPanel milliSecondPanel;

    public JTimePanel(int orientation) {
        this.dayPanel.setLayout(new BoxLayout(this.dayPanel, 0));
        this.dayPanel.add(this.dayTextField);
        this.dayPanel.add(Box.createHorizontalStrut(2));
        this.dayPanel.add(new JLabel(SwingLocale.getString("day")));
        this.dayPanel.add(Box.createHorizontalStrut(2));
        this.hourTextField = new JNumberTextField(2, 0, 0.0, 23.0);
        this.hourPanel = new JPanel();
        this.hourPanel.setLayout(new BoxLayout(this.hourPanel, 0));
        this.hourPanel.add(this.hourTextField);
        this.hourPanel.add(Box.createHorizontalStrut(2));
        this.hourPanel.add(new JLabel(SwingLocale.getString("hour")));
        this.hourPanel.add(Box.createHorizontalStrut(2));
        this.minuteTextField = new JNumberTextField(2, 0, 0.0, 59.0);
        this.minutePanel = new JPanel();
        this.minutePanel.setLayout(new BoxLayout(this.minutePanel, 0));
        this.minutePanel.add(this.minuteTextField);
        this.minutePanel.add(Box.createHorizontalStrut(2));
        this.minutePanel.add(new JLabel(SwingLocale.getString("minute")));
        this.minutePanel.add(Box.createHorizontalStrut(2));
        this.secondTextField = new JNumberTextField(2, 0, 0.0, 59.0);
        this.secondPanel = new JPanel();
        this.secondPanel.setLayout(new BoxLayout(this.secondPanel, 0));
        this.secondPanel.add(this.secondTextField);
        this.secondPanel.add(Box.createHorizontalStrut(2));
        this.secondPanel.add(new JLabel(SwingLocale.getString("second")));
        this.secondPanel.add(Box.createHorizontalStrut(2));
        this.milliSecondTextField = new JNumberTextField(3, 0, 0.0, 999.0);
        this.milliSecondPanel = new JPanel();
        this.milliSecondPanel.setLayout(new BoxLayout(this.milliSecondPanel, 0));
        this.milliSecondPanel.add(this.milliSecondTextField);
        this.milliSecondPanel.add(Box.createHorizontalStrut(2));
        this.milliSecondPanel.add(new JLabel(SwingLocale.getString("millisecond")));
        this.milliSecondPanel.add(Box.createHorizontalStrut(2));
        if (orientation == 0) {
            this.setLayout(new FiledLayout(1, 0, 0));
            this.setTextFieldDimension(new Dimension(30, 22));
        } else if (orientation == 1) {
            this.setLayout(new FiledLayout(0, 0, 5));
            this.setTextFieldDimension(new Dimension(80, 22));
            this.setLabelDimension(new Dimension(70, 22));
        }
        this.add(this.dayPanel);
        this.add(this.hourPanel);
        this.add(this.minutePanel);
        this.add(this.secondPanel);
        this.add(this.milliSecondPanel);
        this.addHierarchyListener(new DisplayAbilityListener(){

            @Override
            public void displayAbilityChanged(HierarchyEvent e) {
                if (JTimePanel.this.dayTextField.getText().equals("")) {
                    JTimePanel.this.dayTextField.setText("0");
                }
                if (JTimePanel.this.hourTextField.getText().equals("")) {
                    JTimePanel.this.hourTextField.setText("0");
                }
                if (JTimePanel.this.minuteTextField.getText().equals("")) {
                    JTimePanel.this.minuteTextField.setText("0");
                }
                if (JTimePanel.this.secondTextField.getText().equals("")) {
                    JTimePanel.this.secondTextField.setText("0");
                }
                if (JTimePanel.this.milliSecondTextField.getText().equals("")) {
                    JTimePanel.this.milliSecondTextField.setText("0");
                }
            }
        });
    }

    public void showDay(boolean visible) {
        if (visible) {
            this.add(this.dayPanel);
        } else {
            this.remove(this.dayPanel);
        }
    }

    public void showHour(boolean visible) {
        if (visible) {
            this.add(this.hourPanel);
        } else {
            this.remove(this.hourPanel);
        }
    }

    public void showMinute(boolean visible) {
        if (visible) {
            this.add(this.minutePanel);
        } else {
            this.remove(this.minutePanel);
        }
    }

    public void showSecond(boolean visible) {
        if (visible) {
            this.add(this.secondPanel);
        } else {
            this.remove(this.secondPanel);
        }
    }

    public void showMilliSecond(boolean visible) {
        if (visible) {
            this.add(this.milliSecondPanel);
        } else {
            this.remove(this.milliSecondPanel);
        }
    }

    public void setTextFieldDimension(Dimension dimension) {
        this.dayPanel.getComponent(0).setPreferredSize(dimension);
        this.hourPanel.getComponent(0).setPreferredSize(dimension);
        this.minutePanel.getComponent(0).setPreferredSize(dimension);
        this.secondPanel.getComponent(0).setPreferredSize(dimension);
        this.milliSecondPanel.getComponent(0).setPreferredSize(dimension);
    }

    public void setLabelDimension(Dimension dimension) {
        this.dayPanel.getComponent(2).setPreferredSize(dimension);
        this.hourPanel.getComponent(2).setPreferredSize(dimension);
        this.minutePanel.getComponent(2).setPreferredSize(dimension);
        this.secondPanel.getComponent(2).setPreferredSize(dimension);
        this.milliSecondPanel.getComponent(2).setPreferredSize(dimension);
    }

    public void setInterval(int[] interval) {
        if (interval.length != 5) {
            throw new IllegalArgumentException(SwingLocale.getString("invalid_time_array_format"));
        }
        this.dayTextField.setText(interval[0] + "");
        this.hourTextField.setText(interval[1] + "");
        this.minuteTextField.setText(interval[2] + "");
        this.secondTextField.setText(interval[3] + "");
        this.milliSecondTextField.setText(interval[4] + "");
    }

    public int[] getInterval() {
        int[] interval = new int[]{Integer.parseInt(this.dayTextField.getText()), Integer.parseInt(this.hourTextField.getText()), Integer.parseInt(this.minuteTextField.getText()), Integer.parseInt(this.secondTextField.getText()), Integer.parseInt(this.milliSecondTextField.getText())};
        return interval;
    }

    @Override
    public boolean verify() {
        if (this.dayTextField.isVisible() && this.dayTextField.getText().equals("")) {
            JBasicOptionPane.showMessageDialog(HandleManager.getFrame(this), SwingLocale.getString("day_description"), SwingLocale.getString("warning"), 2);
            return false;
        }
        if (this.hourTextField.isVisible() && this.hourTextField.getText().equals("")) {
            JBasicOptionPane.showMessageDialog(HandleManager.getFrame(this), SwingLocale.getString("hour_description"), SwingLocale.getString("warning"), 2);
            return false;
        }
        if (this.minuteTextField.isVisible() && this.minuteTextField.getText().equals("")) {
            JBasicOptionPane.showMessageDialog(HandleManager.getFrame(this), SwingLocale.getString("minute_description"), SwingLocale.getString("warning"), 2);
            return false;
        }
        if (this.secondTextField.isVisible() && this.secondTextField.getText().equals("")) {
            JBasicOptionPane.showMessageDialog(HandleManager.getFrame(this), SwingLocale.getString("second_description"), SwingLocale.getString("warning"), 2);
            return false;
        }
        if (this.milliSecondTextField.isVisible() && this.milliSecondTextField.getText().equals("")) {
            JBasicOptionPane.showMessageDialog(HandleManager.getFrame(this), SwingLocale.getString("millisecond_description"), SwingLocale.getString("warning"), 2);
            return false;
        }
        return true;
    }
}

