/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.lookandfeel;

import com.l2fprod.common.swing.plaf.LookAndFeelAddons;
import com.l2fprod.common.swing.plaf.aqua.AquaLookAndFeelAddons;
import com.l2fprod.common.swing.plaf.metal.MetalLookAndFeelAddons;
import com.l2fprod.common.swing.plaf.windows.WindowsClassicLookAndFeelAddons;
import com.l2fprod.common.swing.plaf.windows.WindowsLookAndFeelAddons;
import com.nepxion.swing.button.ButtonContext;
import com.nepxion.swing.button.ButtonManager;
import com.nepxion.swing.font.FontContext;
import com.nepxion.swing.font.FontManager;
import com.nepxion.swing.style.button.flat.FlatButtonUI;
import com.nepxion.swing.style.button.flat.FlatMenuButtonUI;
import com.nepxion.swing.style.button.flat.FlatSplitButtonUI;
import com.nepxion.swing.style.button.flat.JFlatButtonStyle;
import com.nepxion.swing.style.button.lite.JAcidLiteButtonStyle;
import com.nepxion.swing.style.button.lite.JAlloyLiteButtonStyle;
import com.nepxion.swing.style.button.lite.JBedouinLiteButtonStyle;
import com.nepxion.swing.style.button.lite.JBorlandLiteButtonStyle;
import com.nepxion.swing.style.button.lite.JEclipseLiteButtonStyle;
import com.nepxion.swing.style.button.lite.JGlassLiteButtonStyle;
import com.nepxion.swing.style.button.lite.JNimbusLiteButtonStyle;
import com.nepxion.swing.style.button.lite.LiteButtonUI;
import com.nepxion.swing.style.button.lite.LiteMenuButtonUI;
import com.nepxion.swing.style.button.lite.LiteSplitButtonUI;
import com.nepxion.swing.style.framework.JLiteStyle;
import com.nepxion.swing.style.framework.JNimbusStyle;
import com.nepxion.swing.style.framework.JWindowsStyle;
import com.nepxion.swing.style.framework.StyleContext;
import com.nepxion.swing.style.framework.StyleManager;
import java.lang.reflect.InvocationTargetException;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class LookAndFeelManager {
    public static void setSystemLookAndFeel() {
        LookAndFeelManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName(), JLiteStyle.ID, FlatButtonUI.ID, FlatMenuButtonUI.ID, FlatSplitButtonUI.ID, JFlatButtonStyle.ID);
    }

    public static void setDefaultMetalLookAndFeel() {
        try {
            MetalLookAndFeel lookAndFeel = new MetalLookAndFeel();
            MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme(){
                private FontUIResource uiRes = new FontUIResource("Dialog", 0, 12);

                @Override
                public FontUIResource getControlTextFont() {
                    return this.uiRes;
                }

                @Override
                public FontUIResource getSystemTextFont() {
                    return this.uiRes;
                }

                @Override
                public FontUIResource getUserTextFont() {
                    return this.uiRes;
                }

                @Override
                public FontUIResource getMenuTextFont() {
                    return this.uiRes;
                }

                @Override
                public FontUIResource getWindowTitleFont() {
                    return this.uiRes;
                }

                @Override
                public FontUIResource getSubTextFont() {
                    return this.uiRes;
                }
            });
            UIManager.setLookAndFeel(lookAndFeel);
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        LookAndFeelManager.setStyle(JLiteStyle.ID);
        LookAndFeelManager.setFont();
        LookAndFeelManager.setButtonUI(FlatButtonUI.ID, FlatMenuButtonUI.ID, FlatSplitButtonUI.ID, JFlatButtonStyle.ID);
    }

    public static void setMetalLookAndFeel() {
        LookAndFeelManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel", JLiteStyle.ID, FlatButtonUI.ID, FlatMenuButtonUI.ID, FlatSplitButtonUI.ID, JFlatButtonStyle.ID);
    }

    public static void setWindowsLookAndFeel() {
        LookAndFeelManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel", JWindowsStyle.ID, FlatButtonUI.ID, FlatMenuButtonUI.ID, FlatSplitButtonUI.ID, JFlatButtonStyle.ID);
    }

    public static void setMotifLookAndFeel() {
        LookAndFeelManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel", JLiteStyle.ID, FlatButtonUI.ID, FlatMenuButtonUI.ID, FlatSplitButtonUI.ID, JFlatButtonStyle.ID);
    }

    public static void setGTKLookAndFeel() {
        LookAndFeelManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel", JLiteStyle.ID, FlatButtonUI.ID, FlatMenuButtonUI.ID, FlatSplitButtonUI.ID, JFlatButtonStyle.ID);
    }

    public static void setNimbusLookAndFeel() {
        LookAndFeelManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel", JNimbusStyle.ID, LiteButtonUI.ID, LiteMenuButtonUI.ID, LiteSplitButtonUI.ID, JNimbusLiteButtonStyle.ID);
    }

    public static void setAlloyLookAndFeel() {
        LookAndFeelManager.setLookAndFeel("com.incors.plaf.alloy.DefaultThemeAlloyLookAndFeel", JLiteStyle.ID, LiteButtonUI.ID, LiteMenuButtonUI.ID, LiteSplitButtonUI.ID, JAlloyLiteButtonStyle.ID);
    }

    public static void setAcidLookAndFeel() {
        LookAndFeelManager.setLookAndFeel("com.incors.plaf.alloy.AcidThemeAlloyLookAndFeel", JLiteStyle.ID, LiteButtonUI.ID, LiteMenuButtonUI.ID, LiteSplitButtonUI.ID, JAcidLiteButtonStyle.ID);
    }

    public static void setBedouinLookAndFeel() {
        LookAndFeelManager.setLookAndFeel("com.incors.plaf.alloy.BedouinThemeAlloyLookAndFeel", JLiteStyle.ID, LiteButtonUI.ID, LiteMenuButtonUI.ID, LiteSplitButtonUI.ID, JBedouinLiteButtonStyle.ID);
    }

    public static void setGlassLookAndFeel() {
        LookAndFeelManager.setLookAndFeel("com.incors.plaf.alloy.GlassThemeAlloyLookAndFeel", JLiteStyle.ID, LiteButtonUI.ID, LiteMenuButtonUI.ID, LiteSplitButtonUI.ID, JGlassLiteButtonStyle.ID);
    }

    public static void setBorlandLookAndFeel() {
        LookAndFeelManager.setLookAndFeel("com.borland.plaf.borland.BorlandLookAndFeel", JWindowsStyle.ID, LiteButtonUI.ID, LiteMenuButtonUI.ID, LiteSplitButtonUI.ID, JBorlandLiteButtonStyle.ID);
    }

    public static void setJGoodiesWindowsLookAndFeel() {
        LookAndFeelManager.setLookAndFeel("com.jgoodies.looks.windows.WindowsLookAndFeel", JWindowsStyle.ID, LiteButtonUI.ID, LiteMenuButtonUI.ID, LiteSplitButtonUI.ID, JEclipseLiteButtonStyle.ID);
    }

    public static void setPlasticLookAndFeel() {
        LookAndFeelManager.setLookAndFeel("com.jgoodies.looks.plastic.PlasticLookAndFeel", JWindowsStyle.ID, LiteButtonUI.ID, LiteMenuButtonUI.ID, LiteSplitButtonUI.ID, JEclipseLiteButtonStyle.ID);
    }

    public static void setPlasticXPLookAndFeel() {
        LookAndFeelManager.setLookAndFeel("com.jgoodies.looks.plastic.PlasticXPLookAndFeel", JWindowsStyle.ID, LiteButtonUI.ID, LiteMenuButtonUI.ID, LiteSplitButtonUI.ID, JEclipseLiteButtonStyle.ID);
    }

    public static void setPlastic3DLookAndFeel() {
        LookAndFeelManager.setLookAndFeel("com.jgoodies.looks.plastic.Plastic3DLookAndFeel", JWindowsStyle.ID, LiteButtonUI.ID, LiteMenuButtonUI.ID, LiteSplitButtonUI.ID, JEclipseLiteButtonStyle.ID);
    }

    public static void setXPLookAndFeel() {
        LookAndFeelManager.setLookAndFeel("com.stefankrause.xplookandfeel.XPLookAndFeel", JWindowsStyle.ID, FlatButtonUI.ID, FlatMenuButtonUI.ID, FlatSplitButtonUI.ID, JFlatButtonStyle.ID);
    }

    public static void setTinyLookAndFeel() {
        LookAndFeelManager.setLookAndFeel("de.muntjak.tinylookandfeel.TinyLookAndFeel", JWindowsStyle.ID, FlatButtonUI.ID, FlatMenuButtonUI.ID, FlatSplitButtonUI.ID, JFlatButtonStyle.ID);
    }

    public static void setLookAndFeel(String lookAndFeel) {
        LookAndFeelManager.setLookAndFeel(lookAndFeel, null, null, null, null, null);
    }

    public static void setLookAndFeel(String lookAndFeel, String style, String buttonUI, String menuButtonUI, String splitButtonUI, String buttonStyle) {
        try {
            UIManager.setLookAndFeel(lookAndFeel);
        }
        catch (Exception e) {
            LookAndFeelManager.setSystemLookAndFeel();
        }
        LookAndFeelManager.setStyle(style);
        LookAndFeelManager.setFont();
        LookAndFeelManager.setButtonUI(buttonUI, menuButtonUI, splitButtonUI, buttonStyle);
    }

    public static void invokeLookAndFeel(String lookAndFeel) {
        try {
            Class.forName("com.nepxion.swing.lookandfeel.LookAndFeelManager").getMethod("set" + lookAndFeel, null).invoke(null, null);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static boolean isNimbusLookAndFeel() {
        return UIManager.getLookAndFeel().getID().equals("Nimbus");
    }

    public static void addonMetalLookAndFeel() {
        try {
            LookAndFeelAddons.setAddon(MetalLookAndFeelAddons.class);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
    }

    public static void addonWindowsLookAndFeel() {
        try {
            LookAndFeelAddons.setAddon(WindowsClassicLookAndFeelAddons.class);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
    }

    public static void addonLunaLookAndFeel() {
        try {
            UIManager.put("win.xpstyle.name", "luna");
            LookAndFeelAddons.setAddon(WindowsLookAndFeelAddons.class);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
    }

    public static void addonHomesteadLookAndFeel() {
        try {
            UIManager.put("win.xpstyle.name", "homestead");
            LookAndFeelAddons.setAddon(WindowsLookAndFeelAddons.class);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
    }

    public static void addonMetallicLookAndFeel() {
        try {
            UIManager.put("win.xpstyle.name", "metallic");
            LookAndFeelAddons.setAddon(WindowsLookAndFeelAddons.class);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
    }

    public static void addonGlossyLookAndFeel() {
        try {
            LookAndFeelAddons.setAddon(AquaLookAndFeelAddons.class);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
    }

    public static void setStyle(String styleClass) {
        if (!StyleContext.setPriorityContext()) {
            StyleManager.setStyle(styleClass);
        }
        StyleManager.setThemeDecorated();
        if (StyleContext.isFrameDecorated()) {
            StyleManager.setFrameDecorated(StyleContext.isFrameDecorated());
        }
        if (StyleContext.isDialogDecorated()) {
            StyleManager.setDialogDecorated(StyleContext.isDialogDecorated());
        }
    }

    public static void setButtonUI(String buttonUIClass, String menuButtonUIClass, String splitButtonUIClass, String buttonStyleClass) {
        if (!ButtonContext.setPriorityContext()) {
            ButtonManager.setUI(buttonUIClass, menuButtonUIClass, splitButtonUIClass, buttonStyleClass);
        }
    }

    public static void setFont() {
        FontManager.setFont(FontContext.getFont());
    }
}

