/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.selector.checkbox;

import com.nepxion.swing.element.IElementNode;
import com.nepxion.swing.list.JBasicList;
import com.nepxion.swing.renderer.list.CheckBoxListCellRenderer;
import com.nepxion.swing.scrollpane.JBasicScrollPane;
import com.nepxion.util.data.CollectionUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ListModel;

public class JCheckBoxListPanel
extends JBasicScrollPane {
    public static final byte SELECT_ALL = 0;
    public static final byte SELECT_NONE = 1;
    public static final byte SELECT_REVERSE = 2;
    private JBasicList selectionList;
    private List selectedElementNodes;
    private List selectedUserObjects;

    public JCheckBoxListPanel() {
        this((List)null);
    }

    public JCheckBoxListPanel(List allElementNodes) {
        this.selectionList = allElementNodes == null ? new JBasicList() : new JBasicList(CollectionUtil.parseVector((List)allElementNodes));
        this.selectionList.setCellRenderer(new CheckBoxListCellRenderer(this.selectionList, 22));
        this.getViewport().add(this.selectionList);
    }

    public void adaptListFacade(byte selectType) {
        ListModel listModel = this.selectionList.getModel();
        block5: for (int i = 0; i < listModel.getSize(); ++i) {
            IElementNode elementNode = (IElementNode)listModel.getElementAt(i);
            switch (selectType) {
                case 0: {
                    elementNode.setSelected(true);
                    continue block5;
                }
                case 1: {
                    elementNode.setSelected(false);
                    continue block5;
                }
                case 2: {
                    elementNode.setSelected(!elementNode.isSelected());
                }
            }
        }
        this.updateSelection();
    }

    private void adaptSelection() {
        this.selectedElementNodes = new ArrayList();
        this.selectedUserObjects = new ArrayList();
        ListModel listModel = this.selectionList.getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            IElementNode elementNode = (IElementNode)listModel.getElementAt(i);
            if (!elementNode.isSelected()) continue;
            this.selectedElementNodes.add(elementNode);
            this.selectedUserObjects.add(elementNode.getUserObject());
        }
    }

    public JBasicList getList() {
        return this.selectionList;
    }

    public List getAllElementNodes() {
        return this.selectionList.getListData();
    }

    public void setAllElementNodes(List allElementNodes) {
        this.selectionList.setListData(CollectionUtil.parseVector((List)allElementNodes));
    }

    public List getSelectedElementNodes() {
        this.adaptSelection();
        return this.selectedElementNodes;
    }

    public List getSelectedUserObjects() {
        this.adaptSelection();
        return this.selectedUserObjects;
    }

    public void updateSelection() {
        this.selectionList.repaint();
    }
}

