/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.framework.ribbon;

import com.nepxion.swing.action.JAction;
import com.nepxion.swing.container.ContainerManager;
import com.nepxion.swing.container.JContainer;
import com.nepxion.swing.font.FontManager;
import com.nepxion.swing.framework.ribbon.JRibbonBar;
import com.nepxion.swing.framework.ribbon.JRibbonContainer;
import com.nepxion.swing.framework.ribbon.JRibbonHierarchy;
import com.nepxion.swing.framework.ribbon.RibbonManager;
import com.nepxion.swing.gradient.JGradientPainter;
import com.nepxion.swing.icon.IconFactory;
import com.nepxion.swing.icon.paint.CombinationIcon;
import com.nepxion.swing.label.JBasicLabel;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.menuitem.JBasicCheckBoxMenuItem;
import com.nepxion.swing.popupmenu.JBasicPopupMenu;
import com.nepxion.swing.style.framework.IStyle;
import com.nepxion.swing.tabbedpane.JEclipseTabbedPane;
import com.nepxion.swing.tabbedpane.TabbedPaneManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.UIResource;

public class JRibbonTabbedPane
extends JEclipseTabbedPane {
    public static final int BUTTON_STYLE_NORMAL = 0;
    public static final int BUTTON_STYLE_HOVER = 1;
    public static final int BUTTON_STYLE_SELECTED = 2;
    public static final String BUTTON_STYLE = "buttonStyle";
    private String title = "";
    private Font titleFont = new Font("Dialog", 0, 12);
    private Color titleColor = Color.black;
    private Icon navigatorIcon = IconFactory.getSwingIcon("ribbon/navigator.png");
    private Icon navigatorBackgroundIcon = IconFactory.getSwingIcon("ribbon/navigator_bg.png");
    private Icon navigatorBackgroundHoverIcon = IconFactory.getSwingIcon("ribbon/navigator_bg_hover.png");
    private Icon navigatorBackgroundSelectedIcon = IconFactory.getSwingIcon("ribbon/navigator_bg_selected.png");
    private CombinationIcon navigatorCombinationIcon = new CombinationIcon(this.navigatorIcon, this.navigatorBackgroundIcon, -1, 0);
    private String navigatorToolTipText = "";
    private JPopupMenu navigatorPopupMenu;
    private JBasicLabel navigatorLabel;
    private DropDownShortcutAction dropDownShortcutAction;
    private JPopupMenu dropDownPopupMenu;
    private ButtonGroup toggleTextButtonGroup;
    private ButtonGroup toggleIconButtonGroup;
    private TabFlagContainer tabLeadingFlagContainer;
    private TabFlagContainer tabTrailingFlagContainer;
    private ToggleHeightAction toggleHeightAction;
    private List shortcutActionList = new ArrayList();
    private boolean isMinimum = false;
    private JRibbonHierarchy ribbonHierarchy;

    public JRibbonTabbedPane(JRibbonHierarchy ribbonHierarchy) {
        this.ribbonHierarchy = ribbonHierarchy;
        this.initNavigator();
        this.initPopupMenu();
        this.initListener();
        this.initStyle();
        ribbonHierarchy.getNavigatorContainer().add((Component)((Object)this));
    }

    private void initNavigator() {
        this.navigatorLabel = new JBasicLabel((Icon)this.navigatorCombinationIcon, this.navigatorToolTipText);
        this.navigatorLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                CombinationIcon combinationIcon = (CombinationIcon)JRibbonTabbedPane.this.navigatorLabel.getIcon();
                combinationIcon.setLargeIcon(JRibbonTabbedPane.this.navigatorBackgroundHoverIcon);
                JRibbonTabbedPane.this.navigatorLabel.repaint();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                CombinationIcon combinationIcon = (CombinationIcon)JRibbonTabbedPane.this.navigatorLabel.getIcon();
                combinationIcon.setLargeIcon(JRibbonTabbedPane.this.navigatorBackgroundSelectedIcon);
                JRibbonTabbedPane.this.navigatorLabel.repaint();
                if (JRibbonTabbedPane.this.navigatorPopupMenu != null) {
                    JRibbonTabbedPane.this.navigatorPopupMenu.show(JRibbonTabbedPane.this.navigatorLabel, 0, JRibbonTabbedPane.this.navigatorLabel.getHeight());
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                CombinationIcon combinationIcon = (CombinationIcon)JRibbonTabbedPane.this.navigatorLabel.getIcon();
                combinationIcon.setLargeIcon(JRibbonTabbedPane.this.navigatorBackgroundIcon);
                JRibbonTabbedPane.this.navigatorLabel.repaint();
            }
        });
        this.tabLeadingFlagContainer = new TabFlagContainer();
        this.tabLeadingFlagContainer.add((Component)this.navigatorLabel, "Center");
        this.setTabLeadingComponent(this.tabLeadingFlagContainer);
        this.tabTrailingFlagContainer = new TabFlagContainer();
        this.setTabTrailingComponent(this.tabTrailingFlagContainer);
        this.toggleHeightAction = new ToggleHeightAction();
        this.addShortcutAction(this.toggleHeightAction);
        CloseRibbonAction closeRibbonAction = new CloseRibbonAction();
        this.addShortcutAction(closeRibbonAction);
        this.dropDownShortcutAction = new DropDownShortcutAction();
    }

    private void initPopupMenu() {
        this.dropDownPopupMenu = new JBasicPopupMenu();
        this.toggleTextButtonGroup = new ButtonGroup();
        JBasicCheckBoxMenuItem toggleLargTextMenuItem = new JBasicCheckBoxMenuItem(new ToggleFacadeAction(SwingLocale.getString("config_navigatorbar_show_large_text"), IconFactory.getSwingIcon("component/label_16.png"), SwingLocale.getString("config_navigatorbar_show_large_text"), "text", 1));
        this.dropDownPopupMenu.add(toggleLargTextMenuItem);
        this.toggleTextButtonGroup.add(toggleLargTextMenuItem);
        JBasicCheckBoxMenuItem toggleSmallTextMenuItem = new JBasicCheckBoxMenuItem(new ToggleFacadeAction(SwingLocale.getString("config_navigatorbar_show_small_text"), IconFactory.getSwingIcon("component/label_multi_16.png"), SwingLocale.getString("config_navigatorbar_show_small_text"), "text", 0));
        this.dropDownPopupMenu.add(toggleSmallTextMenuItem);
        this.toggleTextButtonGroup.add(toggleSmallTextMenuItem);
        JBasicCheckBoxMenuItem toggleNoTextMenuItem = new JBasicCheckBoxMenuItem(new ToggleFacadeAction(SwingLocale.getString("config_navigatorbar_show_no_text"), IconFactory.getBlankIcon(), SwingLocale.getString("config_navigatorbar_show_no_text"), "text", 2));
        this.dropDownPopupMenu.add(toggleNoTextMenuItem);
        this.toggleTextButtonGroup.add(toggleNoTextMenuItem);
        this.dropDownPopupMenu.addSeparator();
        this.toggleIconButtonGroup = new ButtonGroup();
        JBasicCheckBoxMenuItem toggleLargIconMenuItem = new JBasicCheckBoxMenuItem(new ToggleFacadeAction(SwingLocale.getString("config_navigatorbar_show_large_icon"), IconFactory.getSwingIcon("rectangle_single.png"), SwingLocale.getString("config_navigatorbar_show_large_icon"), "icon", 1));
        this.dropDownPopupMenu.add(toggleLargIconMenuItem);
        this.toggleIconButtonGroup.add(toggleLargIconMenuItem);
        JBasicCheckBoxMenuItem toggleSmallIconMenuItem = new JBasicCheckBoxMenuItem(new ToggleFacadeAction(SwingLocale.getString("config_navigatorbar_show_small_icon"), IconFactory.getSwingIcon("rectangle_multi.png"), SwingLocale.getString("config_navigatorbar_show_small_icon"), "icon", 0));
        this.dropDownPopupMenu.add(toggleSmallIconMenuItem);
        this.toggleIconButtonGroup.add(toggleSmallIconMenuItem);
        JBasicCheckBoxMenuItem toggleNoIconMenuItem = new JBasicCheckBoxMenuItem(new ToggleFacadeAction(SwingLocale.getString("config_navigatorbar_show_no_icon"), IconFactory.getBlankIcon(), SwingLocale.getString("config_navigatorbar_show_no_icon"), "icon", 2));
        this.dropDownPopupMenu.add(toggleNoIconMenuItem);
        this.toggleIconButtonGroup.add(toggleNoIconMenuItem);
    }

    private void initListener() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JAction shortcutAction = JRibbonTabbedPane.this.getShortcutAction(e);
                JRibbonTabbedPane.this.updateShortcutBar(e, shortcutAction, 2);
                if (shortcutAction != null) {
                    if (shortcutAction.getSource() == null) {
                        shortcutAction.setSource(JRibbonTabbedPane.this);
                    }
                    shortcutAction.actionPerformed(null);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                JAction shortcutAction = JRibbonTabbedPane.this.getShortcutAction(e);
                JRibbonTabbedPane.this.updateShortcutBar(e, shortcutAction, 1);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                JRibbonTabbedPane.this.updateShortcutBar(e, null, 0);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                int index = JRibbonTabbedPane.this.indexAtLocation(e.getX(), e.getY());
                if (index < 0) {
                    return;
                }
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() > 1) {
                    JRibbonTabbedPane.this.toggleHeightAction.actionPerformed(null);
                }
            }
        });
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                JAction shortcutAction = JRibbonTabbedPane.this.getShortcutAction(e);
                if (shortcutAction != null) {
                    JRibbonTabbedPane.this.updateShortcutBar(e, shortcutAction, 1);
                } else {
                    JRibbonTabbedPane.this.updateShortcutBar(e, null, 0);
                }
            }
        });
    }

    private void initStyle() {
        this.setTabShape(9, RibbonManager.getStyle());
    }

    @Override
    public void setTabPlacement(int tabPlacement) {
        if (tabPlacement != 1) {
            throw new IllegalArgumentException("The tab placement only supports TOP");
        }
        super.setTabPlacement(tabPlacement);
    }

    @Override
    protected void setBasicTabStyle(int tabShape, IStyle tabStyle) {
        super.setBasicTabStyle(tabShape, tabStyle);
        if (this.tabLeadingFlagContainer != null) {
            this.tabLeadingFlagContainer.setBorder(BorderFactory.createEmptyBorder(6, 3, 10, 2));
        }
    }

    @Override
    protected void setEclipseTabStyle(int tabShape, IStyle tabStyle) {
        super.setEclipseTabStyle(tabShape, tabStyle);
        if (this.tabLeadingFlagContainer != null) {
            this.tabLeadingFlagContainer.setBorder(BorderFactory.createEmptyBorder(5, 2, 10, 2));
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.repaint();
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public void setTitleFont(Font titleFont) {
        this.titleFont = titleFont;
        this.repaint();
    }

    public Color getTitleColor() {
        return this.titleColor;
    }

    public void setTitleColor(Color titleColor) {
        this.titleColor = titleColor;
        this.repaint();
    }

    public Icon getNavigatorIcon() {
        return this.navigatorIcon;
    }

    public void setNavigatorIcon(Icon navigatorIcon) {
        this.navigatorIcon = navigatorIcon;
        CombinationIcon combinationIcon = (CombinationIcon)this.navigatorLabel.getIcon();
        combinationIcon.setSmallIcon(navigatorIcon);
        this.navigatorLabel.repaint();
    }

    public String getNavigatorToolTipText() {
        return this.navigatorToolTipText;
    }

    public void setNavigatorToolTipText(String navigatorToolTipText) {
        this.navigatorToolTipText = navigatorToolTipText;
        this.navigatorLabel.setToolTipText(navigatorToolTipText);
    }

    public JPopupMenu getNavigatorPopupMenu() {
        return this.navigatorPopupMenu;
    }

    public void setNavigatorPopupMenu(JPopupMenu navigatorPopupMenu) {
        this.navigatorPopupMenu = navigatorPopupMenu;
    }

    public JPopupMenu getDropDownPopupMenu() {
        return this.dropDownPopupMenu;
    }

    public void setDropDownPopupMenu(JPopupMenu dropDownPopupMenu) {
        this.dropDownPopupMenu = dropDownPopupMenu;
    }

    public Component getTrailingFlagComponent() {
        if (this.tabTrailingFlagContainer.getComponentCount() == 0) {
            return null;
        }
        return this.tabTrailingFlagContainer.getComponent(0);
    }

    public void setTrailingFlagComponent(Component trailingFlagComponent) {
        this.tabTrailingFlagContainer.addComponent(trailingFlagComponent, "Center");
        this.tabTrailingFlagContainer.setPreferredSize(new Dimension(this.tabTrailingFlagContainer.getPreferredSize().width, 53));
    }

    public List getShortcutActionList() {
        return this.shortcutActionList;
    }

    public void setShortcutActionList(List shortcutActionList) {
        this.shortcutActionList = shortcutActionList;
        this.repaint();
    }

    public void addShortcutAction(JAction shortcutAction) {
        this.shortcutActionList.add(shortcutAction);
        this.repaint();
    }

    public void addShortcutAction(int index, JAction shortcutAction) {
        this.shortcutActionList.add(index, shortcutAction);
        this.repaint();
    }

    public void addShortcutActions(List shortcutActions) {
        this.shortcutActionList.addAll(shortcutActions);
        this.repaint();
    }

    public void addShortcutActions(int index, List shortcutActions) {
        this.shortcutActionList.addAll(index, shortcutActions);
        this.repaint();
    }

    public void removeShortcutAction(JAction shortcutAction) {
        this.shortcutActionList.remove(shortcutAction);
        this.repaint();
    }

    public void removeShortcutAction(int index) {
        this.shortcutActionList.remove(index);
        this.repaint();
    }

    public void removeShortcutActions(List shortcutActions) {
        this.shortcutActionList.removeAll(shortcutActions);
        this.repaint();
    }

    private JAction getShortcutAction(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (this.shortcutActionList != null && !this.shortcutActionList.isEmpty()) {
            for (JAction shortcutAction : this.shortcutActionList) {
                int startX = (Integer)shortcutAction.getValue("startX");
                int startY = (Integer)shortcutAction.getValue("startY");
                int endX = (Integer)shortcutAction.getValue("endX");
                int endY = (Integer)shortcutAction.getValue("endY");
                if (x < startX || x > endX || y < startY || y > endY) continue;
                return shortcutAction;
            }
        }
        int startX = (Integer)this.dropDownShortcutAction.getValue("startX");
        int startY = (Integer)this.dropDownShortcutAction.getValue("startY");
        int endX = (Integer)this.dropDownShortcutAction.getValue("endX");
        int endY = (Integer)this.dropDownShortcutAction.getValue("endY");
        if (x >= startX && x <= endX && y >= startY && y <= endY) {
            return this.dropDownShortcutAction;
        }
        return null;
    }

    public JRibbonHierarchy getRibbonHierarchy() {
        return this.ribbonHierarchy;
    }

    public JRibbonContainer getRibbonContainer() {
        return this.ribbonHierarchy.getRibbonContainer();
    }

    private void toggleHeight() {
        int tabHeight = TabbedPaneManager.getTabHeight((JTabbedPane)((Object)this));
        int contentHeight = TabbedPaneManager.getMaxPreferredContentHeight((JTabbedPane)((Object)this));
        if (!this.isMinimum) {
            this.setPreferredSize(new Dimension(this.getSize().width, tabHeight));
        } else {
            this.setPreferredSize(new Dimension(this.getSize().width, tabHeight + contentHeight));
        }
        ContainerManager.update((JComponent)((Object)this));
        this.isMinimum = !this.isMinimum;
    }

    private void toggleFacade(String showType, int showValue) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            JRibbonBar ribbonBar = (JRibbonBar)((Object)this.getComponentAt(i));
            ribbonBar.toggleFacade(showType, showValue);
        }
        if (!this.isMinimum) {
            this.setPreferredSize(null);
            ContainerManager.update((JComponent)((Object)this));
        }
    }

    public void setFacade(int textShowValue, int iconShowValue) {
        ToggleFacadeAction action;
        AbstractButton button;
        Enumeration<AbstractButton> enumeration = this.toggleTextButtonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            button = enumeration.nextElement();
            action = (ToggleFacadeAction)button.getAction();
            if (action.getShowValue() != textShowValue) continue;
            button.doClick();
            break;
        }
        enumeration = this.toggleIconButtonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            button = enumeration.nextElement();
            action = (ToggleFacadeAction)button.getAction();
            if (action.getShowValue() != iconShowValue) continue;
            button.doClick();
            break;
        }
    }

    private void updateShortcutBar(MouseEvent e, JAction shortcutAction, int buttonStyle) {
        if (this.shortcutActionList != null && !this.shortcutActionList.isEmpty()) {
            for (JAction action : this.shortcutActionList) {
                switch (buttonStyle) {
                    case 0: {
                        action.putValue(BUTTON_STYLE, 0);
                        break;
                    }
                    case 1: {
                        if (action == shortcutAction) {
                            action.putValue(BUTTON_STYLE, 1);
                            break;
                        }
                        action.putValue(BUTTON_STYLE, 0);
                        break;
                    }
                    case 2: {
                        if (action == shortcutAction) {
                            action.putValue(BUTTON_STYLE, 2);
                            break;
                        }
                        action.putValue(BUTTON_STYLE, 0);
                    }
                }
            }
        }
        if (shortcutAction == this.dropDownShortcutAction) {
            switch (buttonStyle) {
                case 0: {
                    shortcutAction.putValue(BUTTON_STYLE, 0);
                    break;
                }
                case 1: {
                    shortcutAction.putValue(BUTTON_STYLE, 1);
                    break;
                }
                case 2: {
                    shortcutAction.putValue(BUTTON_STYLE, 2);
                }
            }
        } else {
            this.dropDownShortcutAction.putValue(BUTTON_STYLE, 0);
        }
        this.updateShortcutBar();
    }

    private void updateShortcutBar() {
        if (this.shortcutActionList == null || this.shortcutActionList.isEmpty()) {
            return;
        }
        JAction firstShortcutAction = (JAction)this.shortcutActionList.get(0);
        DropDownShortcutAction lastShortcutAction = this.dropDownShortcutAction;
        int startX = (Integer)firstShortcutAction.getValue("startX");
        int startY = (Integer)firstShortcutAction.getValue("startY");
        int endX = (Integer)lastShortcutAction.getValue("endX");
        int endY = (Integer)lastShortcutAction.getValue("endY");
        this.paintImmediately(startX, startY, endX - startX, endY - startY);
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Color color = g2d.getColor();
        Font font = g2d.getFont();
        this.paintBackground(g2d);
        this.paintTitle(g2d);
        this.paintShortcutBar(g2d);
        g2d.setColor(color);
        g2d.setFont(font);
        super.paintComponent(g);
    }

    private void paintBackground(Graphics2D g2d) {
        int width = this.getWidth();
        JGradientPainter.fastFill(g2d, new Rectangle(0, 1, width, 4), new Color(226, 235, 244), new Color(220, 234, 236), true);
        JGradientPainter.fastFill(g2d, new Rectangle(0, 5, width, 4), new Color(213, 229, 250), new Color(216, 231, 250), true);
        JGradientPainter.fastFill(g2d, new Rectangle(0, 9, width, 19), new Color(202, 222, 247), new Color(227, 239, 253), true);
        JGradientPainter.fastFill(g2d, new Rectangle(0, 28, width, 1), new Color(219, 244, 254), new Color(219, 244, 254), true);
        JGradientPainter.fastFill(g2d, new Rectangle(0, 29, width, 1), new Color(176, 207, 247), new Color(176, 207, 247), true);
        JGradientPainter.fastFill(g2d, new Rectangle(0, 30, width, 1), new Color(219, 232, 249), new Color(219, 232, 249), true);
        JGradientPainter.fastFill(g2d, new Rectangle(0, 31, width, 23), new Color(191, 219, 255), new Color(186, 215, 253), true);
    }

    private void paintTitle(Graphics2D g2d) {
        g2d.setColor(this.titleColor);
        g2d.setFont(this.titleFont);
        int width = this.getWidth();
        int height = 28;
        if (width > 400) {
            FontManager.drawCenterString(g2d, this.title, width, height, 0, 0);
        }
    }

    private void paintShortcutBar(Graphics2D g2d) {
        Integer buttonStyle;
        int x = 47;
        int y = 4;
        int buttonWidth = 22;
        int buttonCount = this.shortcutActionList != null ? this.shortcutActionList.size() : 0;
        int width = buttonWidth * buttonCount + 1;
        g2d.drawImage(IconFactory.getSwingIcon("ribbon/toolbar_bg_left.png").getImage(), x - 14, y, null);
        g2d.drawImage(IconFactory.getSwingIcon("ribbon/toolbar_bg_right.png").getImage(), x + width, y, null);
        JGradientPainter.fastFill(g2d, new Rectangle(x, y, width, 1), new Color(246, 249, 252), new Color(240, 245, 252), false);
        JGradientPainter.fastFill(g2d, new Rectangle(x, y + 1, width, 1), new Color(186, 204, 226), new Color(191, 208, 229), false);
        JGradientPainter.fastFill(g2d, new Rectangle(x, y + 2, width, 1), new Color(222, 231, 244), new Color(216, 227, 241), false);
        JGradientPainter.fastFill(g2d, new Rectangle(x, y + 3, width, 1), new Color(230, 238, 249), new Color(230, 238, 249), false);
        JGradientPainter.fastFill(g2d, new Rectangle(x, y + 4, width, 1), new Color(219, 231, 247), new Color(219, 231, 247), false);
        JGradientPainter.fastFill(g2d, new Rectangle(x, y + 5, width, 1), new Color(216, 229, 245), new Color(216, 229, 245), false);
        JGradientPainter.fastFill(g2d, new Rectangle(x, y + 6, width, 1), new Color(213, 226, 244), new Color(213, 226, 244), false);
        JGradientPainter.fastFill(g2d, new Rectangle(x, y + 7, width, 1), new Color(210, 224, 242), new Color(210, 224, 242), false);
        JGradientPainter.fastFill(g2d, new Rectangle(x, y + 8, width, 1), new Color(206, 222, 241), new Color(206, 222, 241), false);
        JGradientPainter.fastFill(g2d, new Rectangle(x, y + 9, width, 1), new Color(204, 220, 239), new Color(204, 220, 239), false);
        JGradientPainter.fastFill(g2d, new Rectangle(x, y + 10, width, 1), new Color(202, 218, 238), new Color(202, 218, 238), false);
        JGradientPainter.fastFill(g2d, new Rectangle(x, y + 11, width, 1), new Color(200, 216, 238), new Color(200, 216, 238), false);
        JGradientPainter.fastFill(g2d, new Rectangle(x, y + 12, width, 1), new Color(199, 215, 237), new Color(199, 215, 237), false);
        JGradientPainter.fastFill(g2d, new Rectangle(x, y + 13, width, 1), new Color(196, 214, 237), new Color(196, 214, 237), false);
        JGradientPainter.fastFill(g2d, new Rectangle(x, y + 14, width, 1), new Color(196, 214, 236), new Color(196, 214, 236), false);
        JGradientPainter.fastFill(g2d, new Rectangle(x, y + 15, width, 1), new Color(195, 213, 236), new Color(195, 213, 236), false);
        JGradientPainter.fastFill(g2d, new Rectangle(x, y + 16, width, 1), new Color(196, 214, 237), new Color(196, 214, 237), false);
        JGradientPainter.fastFill(g2d, new Rectangle(x, y + 17, width, 1), new Color(196, 213, 237), new Color(196, 213, 237), false);
        JGradientPainter.fastFill(g2d, new Rectangle(x, y + 18, width, 1), new Color(197, 214, 237), new Color(197, 214, 237), false);
        JGradientPainter.fastFill(g2d, new Rectangle(x, y + 19, width, 1), new Color(199, 215, 237), new Color(199, 215, 237), false);
        JGradientPainter.fastFill(g2d, new Rectangle(x, y + 20, width, 1), new Color(201, 216, 238), new Color(201, 216, 238), false);
        JGradientPainter.fastFill(g2d, new Rectangle(x, y + 21, width, 1), new Color(201, 217, 238), new Color(197, 214, 235), false);
        JGradientPainter.fastFill(g2d, new Rectangle(x, y + 22, width, 1), new Color(154, 179, 213), new Color(162, 185, 217), false);
        if (buttonCount > 0) {
            ++x;
            ++y;
            for (JAction shortcutAction : this.shortcutActionList) {
                Icon shortcutIcon;
                Integer buttonStyle2 = (Integer)shortcutAction.getValue(BUTTON_STYLE);
                if (buttonStyle2 != null) {
                    switch (buttonStyle2) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            g2d.drawImage(IconFactory.getSwingIcon("ribbon/button_bg_hover.png").getImage(), x, y, null);
                            break;
                        }
                        case 2: {
                            g2d.drawImage(IconFactory.getSwingIcon("ribbon/button_bg_selected.png").getImage(), x, y, null);
                        }
                    }
                }
                if ((shortcutIcon = shortcutAction.getIcon()) instanceof ImageIcon) {
                    ImageIcon shortcutImageIcon = (ImageIcon)shortcutIcon;
                    g2d.drawImage(shortcutImageIcon.getImage(), x + 11 - shortcutIcon.getIconWidth() / 2, y + 11 - shortcutIcon.getIconHeight() / 2, null);
                }
                shortcutAction.putValue("startX", x);
                shortcutAction.putValue("startY", y);
                shortcutAction.putValue("endX", x += buttonWidth);
                shortcutAction.putValue("endY", y + 22);
            }
        }
        if ((buttonStyle = (Integer)this.dropDownShortcutAction.getValue(BUTTON_STYLE)) != null) {
            switch (buttonStyle) {
                case 0: {
                    break;
                }
                case 1: {
                    g2d.drawImage(IconFactory.getSwingIcon("ribbon/button_bg_hover_micro.png").getImage(), x + 12, y, null);
                    break;
                }
                case 2: {
                    g2d.drawImage(IconFactory.getSwingIcon("ribbon/button_bg_selected_micro.png").getImage(), x + 12, y, null);
                }
            }
        }
        g2d.drawImage(IconFactory.getSwingIcon("ribbon/arrow.png").getImage(), x + 12, y, null);
        this.dropDownShortcutAction.putValue("startX", x + 12);
        this.dropDownShortcutAction.putValue("startY", y);
        this.dropDownShortcutAction.putValue("endX", x + 12 + 13);
        this.dropDownShortcutAction.putValue("endY", y + 22);
    }

    public class TabFlagContainer
    extends JContainer
    implements UIResource {
        public TabFlagContainer() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
        }
    }

    public class DropDownShortcutAction
    extends JAction {
        public DropDownShortcutAction() {
            super(SwingLocale.getString("ribbon_shortcut"), IconFactory.getSwingIcon("ribbon/arrow.png"), SwingLocale.getString("ribbon_shortcut"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JRibbonTabbedPane.this.dropDownPopupMenu != null) {
                int startX = (Integer)JRibbonTabbedPane.this.dropDownShortcutAction.getValue("startX");
                int endY = (Integer)JRibbonTabbedPane.this.dropDownShortcutAction.getValue("endY");
                JRibbonTabbedPane.this.dropDownPopupMenu.show((Component)((Object)JRibbonTabbedPane.this), startX, endY);
            }
        }
    }

    public class ToggleFacadeAction
    extends JAction {
        private String showType;
        private int showValue;

        public ToggleFacadeAction(String text, Icon icon, String toolTipText, String showType, int showValue) {
            super(text, icon, toolTipText);
            this.showType = showType;
            this.showValue = showValue;
        }

        public String getShowType() {
            return this.showType;
        }

        public void setShowType(String showType) {
            this.showType = showType;
        }

        public int getShowValue() {
            return this.showValue;
        }

        public void setShowValue(int showValue) {
            this.showValue = showValue;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JRibbonTabbedPane.this.toggleFacade(this.showType, this.showValue);
        }
    }

    public class ToggleHeightAction
    extends JAction {
        public ToggleHeightAction() {
            super(SwingLocale.getString("toggle_navigatorbar_visibility"), IconFactory.getSwingIcon("ribbon/toggle_up.png"), SwingLocale.getString("toggle_navigatorbar_visibility"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JRibbonTabbedPane.this.toggleHeight();
            if (JRibbonTabbedPane.this.isMinimum) {
                this.setIcon(IconFactory.getSwingIcon("ribbon/toggle_down.png"));
            } else {
                this.setIcon(IconFactory.getSwingIcon("ribbon/toggle_up.png"));
            }
            JRibbonTabbedPane.this.updateShortcutBar();
        }
    }

    public class CloseRibbonAction
    extends JAction {
        public CloseRibbonAction() {
            super(SwingLocale.getString("close_panel"), IconFactory.getSwingIcon("ribbon/close.png"), SwingLocale.getString("close_panel"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JRibbonContainer ribbonContainer = JRibbonTabbedPane.this.getRibbonContainer();
            ribbonContainer.closeRibbonComponent();
        }
    }
}

