/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import java.awt.geom.Point2D;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import twaver.Link;
import twaver.Node;
import twaver.base.A.E.L;

public class ShapeLink
extends Link {
    protected List points = new ArrayList();
    protected int shapeLinkType = 1;

    public ShapeLink() {
    }

    public ShapeLink(Object id) {
        super(id);
    }

    public ShapeLink(Node from, Node to) {
        super(from, to);
    }

    public ShapeLink(Object id, Node from, Node to) {
        super(id, from, to);
    }

    public String getUIClassID() {
        return "ShapeLinkUI";
    }

    public String getSVGUIClassID() {
        return "ShapeLinkSVGUI";
    }

    public List getPoints() {
        return this.points;
    }

    public Point2D[] toPoints() {
        Point2D[] ps = (Point2D[])Array.newInstance(Point2D.class, this.points.size());
        this.points.toArray(ps);
        return ps;
    }

    public Point2D getPoint(int index) {
        if (index >= 0 && index < this.points.size()) {
            return (Point2D)this.points.get(index);
        }
        return null;
    }

    public void setPoints(List points) {
        this.points = L.A(points);
        this.firePointsChange();
    }

    public void setPoint(int index, Point2D point) {
        if (index >= 0 && index < this.points.size()) {
            this.points.set(index, L.A(point));
            this.firePointsChange();
        }
    }

    public void insertPoint(int index, Point2D point) {
        if (index >= 0 && index <= this.points.size()) {
            this.points.add(index, L.A(point));
            this.firePointsChange();
        }
    }

    public void removePoint(int index) {
        if (index >= 0 && index < this.points.size()) {
            this.points.remove(index);
            this.firePointsChange();
        }
    }

    public void addPoint(Point2D point) {
        if (point != null) {
            this.points.add(L.A(point));
            this.firePointsChange();
        }
    }

    public void clear() {
        if (this.points.size() > 0) {
            this.points.clear();
            this.firePointsChange();
        }
    }

    public void firePointsChange() {
        this.firePropertyChange("points", null, this.points);
    }

    public int getShapeLinkType() {
        return this.shapeLinkType;
    }

    public void setShapeLinkType(int shapeLinkType) {
        if (this.shapeLinkType != shapeLinkType) {
            int oldValue = this.shapeLinkType;
            this.shapeLinkType = shapeLinkType;
            this.firePropertyChange("shapeLinkType", oldValue, shapeLinkType);
        }
    }
}

