/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import twaver.AlarmSeverity;
import twaver.AlarmState;
import twaver.BTSAntenna;
import twaver.Element;
import twaver.Equipment;
import twaver.ExportValuesInterceptor;
import twaver.Follower;
import twaver.Group;
import twaver.Link;
import twaver.PolyLine;
import twaver.PolySubNetwork;
import twaver.ResizableNode;
import twaver.RotatableNode;
import twaver.ShapeLink;
import twaver.ShapeNode;
import twaver.Shelf;
import twaver.Slot;
import twaver.TDataBox;
import twaver.TSubNetwork;
import twaver.TUIManager;

public class DefaultExportValuesInterceptor
implements ExportValuesInterceptor {
    protected void exportParent(Element source, Element target, TDataBox box) {
        target.setParent(source.getParent());
    }

    protected void exportChildren(Element source, Element target, TDataBox box) {
        List children = source.getChildren();
        if (children != null) {
            for (int i2 = 0; i2 < children.size(); ++i2) {
                Element element = (Element)children.get(i2);
                Element copyElement = element.copy(box);
                target.addChild(copyElement);
                if (box == null) continue;
                box.addElement(copyElement);
            }
        }
    }

    protected void exportAlarmState(Element source, Element target, TDataBox box) {
        AlarmState sourceState = source.getAlarmState();
        AlarmState targetState = target.getAlarmState();
        Iterator it = AlarmSeverity.iterator();
        while (it.hasNext()) {
            AlarmSeverity severity = (AlarmSeverity)it.next();
            targetState.setNewAlarmCount(severity, sourceState.getNewAlarmCount(severity));
            targetState.setAcknowledgedAlarmCount(severity, sourceState.getAcknowledgedAlarmCount(severity));
        }
    }

    protected void exportHost(Follower source, Follower target, TDataBox box) {
        target.setHost(source.getHost());
    }

    protected void exportFrom(Link source, Link target, TDataBox box) {
        target.setFrom(source.getFrom());
    }

    protected void exportTo(Link source, Link target, TDataBox box) {
        target.setTo(source.getTo());
    }

    protected void exportBTS(BTSAntenna source, BTSAntenna target, TDataBox box) {
        target.setBTS(source.getBTS());
    }

    public void exportValues(Element source, Element target, TDataBox box) {
        Object sourceValue;
        Point2D point;
        int i2;
        List points;
        ArrayList<Point2D> list;
        Element s;
        Element t;
        if (TUIManager.isPredefinedPropertyCopied("children")) {
            this.exportChildren(source, target, box);
        }
        if (TUIManager.isPredefinedPropertyCopied("layerID")) {
            target.setLayerID(source.getLayerID());
        }
        if (TUIManager.isPredefinedPropertyCopied("icon")) {
            target.setIcon(source.getIconURL());
        }
        if (TUIManager.isPredefinedPropertyCopied("image")) {
            target.setImage(source.getImageURL());
        }
        if (TUIManager.isPredefinedPropertyCopied("alarmState")) {
            this.exportAlarmState(source, target, box);
        }
        if (TUIManager.isPredefinedPropertyCopied("name")) {
            target.setName(source.getName());
        }
        if (TUIManager.isPredefinedPropertyCopied("displayName")) {
            target.setDisplayName(source.getDisplayName());
        }
        if (TUIManager.isPredefinedPropertyCopied("enableAlarmPropagationFromChildren")) {
            target.setEnableAlarmPropagationFromChildren(source.isEnableAlarmPropagationFromChildren());
        }
        if (TUIManager.isPredefinedPropertyCopied("parent")) {
            this.exportParent(source, target, box);
        }
        if (TUIManager.isPredefinedPropertyCopied("userObject")) {
            target.setUserObject(source.getUserObject());
        }
        if (TUIManager.isPredefinedPropertyCopied("toolTipText")) {
            target.setToolTipText(source.getToolTipText());
        }
        if (TUIManager.isPredefinedPropertyCopied("selected")) {
            target.setSelected(source.isSelected());
        }
        if (TUIManager.isPredefinedPropertyCopied("visible")) {
            target.setVisible(source.isVisible());
        }
        if (TUIManager.isPredefinedPropertyCopied("location")) {
            target.setLocation(source.getX(), source.getY());
        }
        if (target instanceof ResizableNode && source instanceof ResizableNode) {
            t = (ResizableNode)target;
            s = (ResizableNode)source;
            if (TUIManager.isPredefinedPropertyCopied("size")) {
                ((ResizableNode)t).setSize(((ResizableNode)s).getSize());
            } else {
                if (TUIManager.isPredefinedPropertyCopied("width")) {
                    ((ResizableNode)t).setWidthSize(((ResizableNode)s).getWidth());
                }
                if (TUIManager.isPredefinedPropertyCopied("height")) {
                    ((ResizableNode)t).setHeightSize(((ResizableNode)s).getHeight());
                }
            }
        }
        if (target instanceof PolySubNetwork && source instanceof PolySubNetwork) {
            t = (PolySubNetwork)target;
            s = (PolySubNetwork)source;
            if (TUIManager.isPredefinedPropertyCopied("baseShape")) {
                ((PolySubNetwork)t).setBaseShape(((PolySubNetwork)s).getBaseShape());
            }
        }
        if (target instanceof TSubNetwork && source instanceof TSubNetwork) {
            t = (TSubNetwork)target;
            s = (TSubNetwork)source;
            if (TUIManager.isPredefinedPropertyCopied("background")) {
                t.setBackground(s.getBackground());
            }
            if (TUIManager.isPredefinedPropertyCopied("dataSource")) {
                t.setDataSource(s.getDataSource());
            }
            if (TUIManager.isPredefinedPropertyCopied("dataLoaded")) {
                t.setDataLoaded(s.isDataLoaded());
            }
            if (TUIManager.isPredefinedPropertyCopied("viewPoint")) {
                t.setViewPoint(s.getViewPoint());
            }
        }
        if (target instanceof Follower && source instanceof Follower && TUIManager.isPredefinedPropertyCopied("host")) {
            this.exportHost((Follower)source, (Follower)target, box);
        }
        if (target instanceof RotatableNode && source instanceof RotatableNode) {
            RotatableNode s2 = (RotatableNode)source;
            RotatableNode t2 = (RotatableNode)target;
            if (TUIManager.isPredefinedPropertyCopied("zoom")) {
                t2.setZoom(s2.getZoom());
            }
            if (TUIManager.isPredefinedPropertyCopied("angle")) {
                t2.setAngle(s2.getAngle());
            }
        }
        if (target instanceof Equipment && source instanceof Equipment) {
            t = (Equipment)target;
            s = (Equipment)source;
            if (TUIManager.isPredefinedPropertyCopied("exist")) {
                t.setExist(s.isExist());
            }
            if (TUIManager.isPredefinedPropertyCopied("tag")) {
                t.setTag(s.getTag());
            }
        }
        if (target instanceof Link && source instanceof Link) {
            t = (Link)target;
            s = (Link)source;
            if (TUIManager.isPredefinedPropertyCopied("from")) {
                this.exportFrom((Link)s, (Link)t, box);
            }
            if (TUIManager.isPredefinedPropertyCopied("to")) {
                this.exportTo((Link)s, (Link)t, box);
            }
            if (TUIManager.isPredefinedPropertyCopied("linkType")) {
                ((Link)t).setLinkType(((Link)s).getLinkType());
            }
        }
        if (target instanceof Group && source instanceof Group) {
            t = (Group)target;
            s = (Group)source;
            if (TUIManager.isPredefinedPropertyCopied("expand")) {
                ((Group)t).setExpand(((Group)s).isExpand());
            }
            if (TUIManager.isPredefinedPropertyCopied("groupType")) {
                ((Group)t).setGroupType(((Group)s).getGroupType());
            }
        }
        if (target instanceof ShapeNode && source instanceof ShapeNode) {
            t = (ShapeNode)target;
            s = (ShapeNode)source;
            if (TUIManager.isPredefinedPropertyCopied("shapeNodeType")) {
                ((ShapeNode)t).setShapeNodeType(((ShapeNode)s).getShapeNodeType());
            }
            if (TUIManager.isPredefinedPropertyCopied("points")) {
                list = new ArrayList<Point2D>();
                points = ((ShapeNode)s).getPoints();
                for (i2 = 0; i2 < points.size(); ++i2) {
                    point = (Point2D)points.get(i2);
                    list.add((Point2D)point.clone());
                }
                ((ShapeNode)t).setPoints(list);
                if (((ShapeNode)s).getSegments() == null) {
                    ((ShapeNode)t).setSegments(null);
                } else {
                    ((ShapeNode)t).setSegments(new ArrayList(((ShapeNode)s).getSegments()));
                }
            }
        }
        if (target instanceof ShapeLink && source instanceof ShapeLink) {
            t = (ShapeLink)target;
            s = (ShapeLink)source;
            if (TUIManager.isPredefinedPropertyCopied("points")) {
                list = new ArrayList();
                points = ((ShapeLink)s).getPoints();
                for (i2 = 0; i2 < points.size(); ++i2) {
                    point = (Point2D)points.get(i2);
                    list.add((Point2D)point.clone());
                }
                ((ShapeLink)t).setPoints(list);
            }
        }
        if (target instanceof BTSAntenna && source instanceof BTSAntenna) {
            t = (BTSAntenna)target;
            s = (BTSAntenna)source;
            if (TUIManager.isPredefinedPropertyCopied("power")) {
                ((BTSAntenna)t).setPower(((BTSAntenna)s).getPower());
            }
            if (TUIManager.isPredefinedPropertyCopied("beamDirection")) {
                ((BTSAntenna)t).setBeamDirection(((BTSAntenna)s).getBeamDirection());
            }
            if (TUIManager.isPredefinedPropertyCopied("beamWidth")) {
                ((BTSAntenna)t).setBeamWidth(((BTSAntenna)s).getBeamWidth());
            }
            if (TUIManager.isPredefinedPropertyCopied("beamAlpha")) {
                ((BTSAntenna)t).setBeamAlpha(((BTSAntenna)s).getBeamAlpha());
            }
            if (TUIManager.isPredefinedPropertyCopied("antennaType")) {
                ((BTSAntenna)t).setAntennaType(((BTSAntenna)s).getAntennaType());
            }
            if (TUIManager.isPredefinedPropertyCopied("BTS")) {
                this.exportBTS((BTSAntenna)s, (BTSAntenna)t, box);
            }
        }
        if (target instanceof PolyLine && source instanceof PolyLine) {
            t = (PolyLine)target;
            s = (PolyLine)source;
            if (TUIManager.isPredefinedPropertyCopied("blinkingObject")) {
                ((PolyLine)t).setBlinkingObject(((PolyLine)s).getBlinkingObject());
            }
        }
        if (target instanceof Shelf && source instanceof Shelf) {
            t = (Shelf)target;
            s = (Shelf)source;
            if (TUIManager.isPredefinedPropertyCopied("equipIndex")) {
                ((Shelf)t).setEquipIndex(((Shelf)s).getEquipIndex());
            }
            if (TUIManager.isPredefinedPropertyCopied("equipCount")) {
                ((Shelf)t).setEquipCount(((Shelf)s).getEquipCount());
            }
        }
        if (target instanceof Slot && source instanceof Slot) {
            t = (Slot)target;
            s = (Slot)source;
            if (TUIManager.isPredefinedPropertyCopied("equipIndex")) {
                ((Slot)t).setEquipIndex(((Slot)s).getEquipIndex());
            }
            if (TUIManager.isPredefinedPropertyCopied("equipCount")) {
                ((Slot)t).setEquipCount(((Slot)s).getEquipCount());
            }
        }
        if (TUIManager.isPredefinedPropertyCopied("businessObject")) {
            target.setBusinessObject(source.getBusinessObject());
        }
        boolean all = TUIManager.isPredefinedPropertyCopied("all.clientproperties");
        Iterator it = source.getClientProperties().keySet().iterator();
        while (it.hasNext()) {
            String clientPropertyKey = it.next().toString();
            if (!all && !TUIManager.isPredefinedPropertyCopied(clientPropertyKey)) continue;
            sourceValue = source.getClientProperty(clientPropertyKey);
            target.putClientProperty((Object)clientPropertyKey, sourceValue);
        }
        all = TUIManager.isPredefinedPropertyCopied("all.userproperties");
        if (all) {
            it = source.getUserProperties().keySet().iterator();
            while (it.hasNext()) {
                String userPropertyKey = it.next().toString();
                sourceValue = source.getUserProperty(userPropertyKey);
                target.putUserProperty((Object)userPropertyKey, sourceValue);
            }
        }
    }
}

